<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFavs (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An application allowing site visitors to save, and store their favorite
#  items from various modules, and share them with their friends.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialize
//
$the_template = $this->GetPreference(CGFavs::PREF_DFLT_ADDTOFAV);
$category = null;
$error = '';
$postaction = '';
$fav_obj = null;
if( !isset($params['key1']) || !isset($params['uid']) ||
    $params['key1'] == '' || $params['uid'] == '')
  {
    $this->DisplayErrorMessage($this->Lang('error_missingparam'));
    return;
  }

 foreach( $params as $key => $value )
  {
    if( endswith($key,'_x') ) {
      $base = substr($key,0,strlen($key)-2);
      if( isset($params[$base.'_y']) && !isset($params[$base]) )
      {
        $params[$base] = $base;
      }
    }
  }


//
// setup
//
$fav_obj = new cgfav;
$fav_obj->uid = trim($params['uid']);
$fav_obj->key1 = trim($params['key1']);
$fav_obj->key2 = get_parameter_value($params,'key2',null);
$fav_obj->key3 = get_parameter_value($params,'key3',null);
$fav_obj->key4 = get_parameter_value($params,'key4',null);
$category = get_parameter_value($params,'category',null);
$the_template = get_parameter_value($params,'aftemplate',$the_template);
$postaction = get_parameter_value($params,'postaction',$postaction);

$tmp_obj = cgfav_ops::load_one($fav_obj->uid,$fav_obj->key1,$fav_obj->key2,$fav_obj->key3,$fav_obj->key4);
if( $tmp_obj )
  {
    $fav_obj = $tmp_obj;
    $fav_obj->value = 1;
  }


//
// handle form processing
//
if( isset($params['submit']) )
  {
    if( isset($params['favorite']) && $params['favorite'] == 1 )
      {
	$fav_obj->value = 1;
      }
    else
      {
	$fav_obj->value = 0;
      }

    if( $fav_obj->value )
      {
	// gotta create it, or update it.
	$fav_obj->save();
      }
    else
      {
	// gotta delete it.
	$fav_obj->delete();
      }

    // send the event
    $this->SendEvent('OnAddFavorite',array('fav'=>$fav_obj));

    // now what do we do.
    switch($postaction)
      {
      case 'url':
	if( isset($params['url']) && $params['url'] != '' )
	  {
	    redirect($params['url']);
	  }
	break;

      case 'inline':
	// do nothing.
	break;

      case 'page':
	$alias = get_parameter_value($params,'page',null);
	if( $alias ) $this->RedirectContent($alias);
	break;

      case 'nothing':
      default:
      }
  }

//
// give everything to smarty
//
// $parms = $params;
// $parms['ajax'] = 1;
// $smarty->assign('ajax_url',$this->CreateURL($id,'default',$returnid,$parms);
if( !isset($params['url']) )
  {
    $params['url'] = cge_url::current_url();
  }
$smarty->assign('formstart',$this->CGCreateFormStart($id,'default',$returnid,$params,($postaction == 'inline')));
$smarty->assign('formend',$this->CreateFormEnd());
if( $category ) $smarty->assign('category',$category);
if( $category )
  {
    $cat = cgfav_cat_ops::get_by_name($category);
    if( !is_object($cat) )
      {
	$cat = cgfav_cat_ops::get_by_id($category);
      }
    if( is_object($cat) )
      {
	$smarty->assign('category_obj',$cat);
      }
  }
if( is_object($fav_obj) )
  {
    $smarty->assign('fav_obj',$fav_obj);
  }
$allcats = cgfav_cat_ops::get_all();
$smarty->assign('categories',$allcats);

//
// display the output
//
echo $this->ProcessTemplateFromDatabase('addtofav_'.$the_template);

#
# EOF
#
?>
