<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFavs (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An application allowing site visitors to save, and store their favorite
#  items from various modules, and share them with their friends.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) exit;

$this->SetCurrentTab('categories');
$catid = '';
$dir = '';

if( !isset($params['catid']) || !isset($params['dir']))
  {
    $this->SetError($this->Lang('error_missingparam'));
    $this->RedirectToTab($id);
  }
$catid = (int)$params['catid'];
$dir = strtolower(trim($params['dir']));

try
{
  $thiscat = cgfav_cat_ops::load_by_id($catid);
  $othercat = '';
  if( !is_object($thiscat) )
    {
      throw new Exception($this->Lang('error_notfound'));
    }

  switch( $dir )
    {
    case 'up':
      // get the category id of the item with the sortin less than this one
      $othercat = cgfav_cat_ops::load_by_sorting($thiscat->sorting - 1);
      if( !is_object($thiscat) )
	{
	  throw new Exception($this->Lang('error_notfound'));
	}
      break;

    case 'down':
      // get the category id of the item with the sorting greater than this one
      $othercat = cgfav_cat_ops::load_by_sorting($thiscat->sorting + 1);
      if( !is_object($thiscat) )
	{
	  throw new Exception($this->Lang('error_notfound'));
	}
      break;
    }

  if( is_object($thiscat) && is_object($othercat) )
    {
      $tmp = $thiscat->sorting;
      $thiscat->sorting = $othercat->sorting;
      $othercat->sorting = $tmp;

      $thiscat->save();
      $othercat->save();
    }
}
catch( Exception $e )
{
  $this->SetError($e->getMessage());
}

$this->RedirectToTab($id);

#
# EOF
#
?>