<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFavs (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An application allowing site visitors to save, and store their favorite
#  items from various modules, and share them with their friends.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) exit;

//
// initialize
//
$this->SetCurrentTab('categories');
$catid = 0;
$name = '';
$cat = new cgfav_cat;

//
// setup
//
if( isset($params['catid']) ) $catid = (int)$params['catid'];
if( $catid > 0 )
  {
    $cat = cgfav_cat_ops::load_by_id($catid);
    if( !$cat )
      {
	$this->SetError($this->Lang('error_notfound'));
	$this->RedirectToTab();
      }
    $name = $cat->name;
  }
if( isset($params['name']) ) $name = trim($params['name']);
if( isset($params['cancel']) )
  {
    $this->RedirectToTab($id);
  }
else if( isset($params['submit']) )
  {
    $error = '';
    if( $name == '' )
      {
	$error = $this->ShowErrors($this->Lang('error_namerequired'));
      }

    if( !$error )
      {
	// check for duplicate name
	$cat2 = cgfav_cat_ops::load_by_name($name);
	if( is_object($cat2) && $cat2->id != $catid )
	  {
	    $error = $this->ShowErrors($this->Lang('error_nameexists'));
	  }
      }

    if( $error )
      {
	echo $error;
      }
    else
      {
	$cat->name = $name;
	$cat->save();
	$this->RedirectToTab($id);
      }
  }

//
// give everything to smarty.
//
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_editcat',$returnid,array('catid'=>$catid)));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('name',$name);
$smarty->assign('catid',$catid);
echo $this->ProcessTemplate('admin_editcat.tpl');

#
# EOF
#
?>