<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFavs (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An application allowing site visitors to save, and store their favorite
#  items from various modules, and share them with their friends.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

////////////////////////////////////////////////////////////
$cgextensions = cms_join_path(cmsms()->config['root_path'],'modules',
			      'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);
////////////////////////////////////////////////////////////

define('CGFAVS_TABLE',cms_db_prefix().'module_cgfavs');
define('CGFAVS_CATS_TABLE',cms_db_prefix().'module_cgfavs_cats');

class CGFavs extends CGExtensions
{
  const PREF_DFLT_ADDTOFAV = 'PREF_DFLT_ADDTOFAV';
  const TPL_SYSDFLT_ADDTOFAV = 'TPL_SYSDFLT_ADDTOFAV';
  const PREF_DFLT_MYFAVS = 'PREF_DFLT_MYFAVS';
  const TPL_SYSDFLT_MYFAVS = 'TPL_SYSDFLT_MYFAVS';

  /*---------------------------------------------------------
   Constructor
   ---------------------------------------------------------*/
  public function __construct()
  {
    parent::__construct();
  }


  /*---------------------------------------------------------
   SetParameters
   ---------------------------------------------------------*/
  function SetParameters()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();

    $this->Createparameter('category','',$this->Lang('param_category'));
    $this->SetParameterType('category',CLEAN_STRING);

    $this->Createparameter('uid','',$this->Lang('param_uid'));
    $this->SetParameterType('uid',CLEAN_STRING);

    $this->Createparameter('key1','',$this->Lang('param_key1'));
    $this->SetParameterType('key1',CLEAN_STRING);

    $this->Createparameter('key2','',$this->Lang('param_key2'));
    $this->SetParameterType('key2',CLEAN_STRING);

    $this->Createparameter('key3','',$this->Lang('param_key3'));
    $this->SetParameterType('key3',CLEAN_STRING);

    $this->Createparameter('key4','',$this->Lang('param_key4'));
    $this->SetParameterType('key4',CLEAN_STRING);

    $this->Createparameter('aftemplate','',$this->Lang('param_aftemplate'));
    $this->SetParameterType('aftemplate',CLEAN_STRING);

    $this->Createparameter('mftemplate','',$this->Lang('param_mftemplate'));
    $this->SetParameterType('mftemplate',CLEAN_STRING);

    $this->Createparameter('url','',$this->Lang('param_url'));
    $this->SetParameterType('url',CLEAN_STRING);

    $this->Createparameter('page','',$this->Lang('param_page'));
    $this->SetParameterType('page',CLEAN_STRING);

    $this->Createparameter('postaction','',$this->Lang('param_postaction'));
    $this->SetParameterType('postaction',CLEAN_STRING);

    $this->Createparameter('friends','',$this->Lang('param_friends'));
    $this->SetParameterType('friends',CLEAN_NONE);

    // form parameters.
    //$this->Createparameter('favorite','',$this->Lang('param_favorite'));
    $this->SetParameterType('favorite',CLEAN_INT);
    //$this->Createparameter('submit','',$this->Lang('param_submit'));
    $this->SetParameterType('submit',CLEAN_STRING);
    $this->SetParameterType('submit_x',CLEAN_INT);
    $this->SetParameterType('submit_y',CLEAN_INT);
    //$this->Createparameter('remove','',$this->Lang('param_remove'));
    $this->SetParameterType('remove',CLEAN_STRING);
  }


  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return get_class();
  }


  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }

	
  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '1.0.4';
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'calguy1000';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'calguy1000@cmsmadesimple.org';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    return @file_get_contents(dirname(__FILE__).'/changelog.inc');
  }
  

  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'extensions';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Site Preferences') ||
      $this->CheckPermission('Modify Templates');
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('CGExtensions'=>'1.22');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.9.1";
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('preuninstall');
  }	


  /*---------------------------------------------------------
   GetEventHelp()
   ---------------------------------------------------------*/
  function GetEventHelp( $eventname )
  {
    return $this->Lang('eventhelp_'.$eventname);
  }


  /*---------------------------------------------------------
   GetEventDescriptio()
   ---------------------------------------------------------*/
  function GetEventDescription( $eventname )
  {
    return $this->Lang('eventdesc_'.$eventname);
  }

} // class

?>
