<?php

if (!isset($gCms))
    exit;

if (!$this->CheckAccess("Manage Themes")) {
    return $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
}

/*
 * Steps:
 * 1. Select templates
 * 2. Select stylesheets
 * 3. Select pages
 * 4. Select module templates
 * 5. Select global content blocks
 * 6. Select user defined tags (UDT)
 * 7. Select files
 * 8. Select module settings
 * 9. Enter module information and user instructions: DIY section (e. g. module paramaters)
 * 10. See overview
 * 11. Do export */

/* ---------------------------------------------------------
  _extractTemplateFiles
  --------------------------------------------------------- */

function _extractTemplateFiles($content) {
    $result = array();
    $urls = get_urls($content);
    // we're only concerned about the src urls
    foreach ($urls['src'] as $src) {
        // if it's an external link we ignore it
        // if it's an internal link, we add it
        if (!preg_match('/^http\:/', $src)) {
            $result[] = $src;
        }
    }
    foreach ($urls['href'] as $href) {
        // if it's an external link we ignore it
        // if it's an internal link, we add it
        if (!preg_match('/^http\:/', $href)) {
            $result[] = $href;
        }
    }

    return $result;
}

function _extractStylesheetImages($stylesheet) {
    $regex = '/url\s*\(\"*(.*)\"*\)/i';
    preg_match_all($regex, $stylesheet->value, $matches);
    // $matches[1] is all immportant
    // now strip out any that have ^http in them
    $result = array();
    foreach ($matches[1] as $match) {
        if (!preg_match('/^http\:/', $match)) {
            $result[] = str_replace('[[root_url]]/', '', $match);
        }
    }

    return $result;
}

function list_dir($dir, $path='') {
    $gCms = cmsms();
		$config = $gCms->GetConfig();
    $listDir = array();
    if ($handler = opendir($dir)) {
        while (($sub = readdir($handler)) !== FALSE) {
            if ($sub != "." && $sub != ".." && $sub != "Thumb.db") {
                if (is_file($dir . "/" . $sub)) {
                    $filesize = filesize($dir . "/" . $sub);
                    $filemanager = $gCms->GetModuleInstance('FileManager');
                    $filesize = $filemanager->FormatFileSize($filesize);
                    $filelist[] = str_replace($config['uploads_path'], '', $dir . "/" . $sub);
                    $sub = array($sub => array('filesize' => $filesize['size'] . ' ' . $filesize['unit'], 'path' => str_replace($config['uploads_path'], '', $dir . "/" . $sub)));
                    $listDir[] = $sub;
                } elseif (is_dir($dir . "/" . $sub)) {
                    $filelist[] = list_dir($dir . "/" . $sub);
                    //$listDir[$sub] = list_dir($dir . "/" . $sub); //directories
                }
            }
        }
        closedir($handler);
    }
    return $filelist;
}

function ListFiles($dir) {

    if ($dh = opendir($dir)) {

        $files = Array();
        $inner_files = Array();

        while ($file = readdir($dh)) {
            if ($file != "." && $file != ".." && $file[0] != '.') {
                if (is_dir($dir . "/" . $file)) {
                    $inner_files = ListFiles($dir . "/" . $file);
                    if (is_array($inner_files))
                        $files = array_merge($files, $inner_files);
                } else {
                    array_push($files, $dir . "/" . $file);
                }
            }
        }

        closedir($dh);
        return $files;
    }
}

#######################debug############################
$debug = 0;
if ($debug) {
    print '<pre>';
    print_r($params);
    print '</pre>';

    print '<pre>';
    print_r($_SESSION['tms']);
    print '</pre>';
}
#######################debug############################

if (!isset($_SESSION['tms'])) {
    $_SESSION['tms'] = array();
}

if (!isset($params['step'])) {
    $step = 1;
} else {
    $step = $params['step'];
}



$found_templates = array();
$found_styles = array();
$found_pages = array();
$found_modules = array();
$found_blocks = array();
$found_udts = array();
$found_files = array();
$found_settings = array();
$package_info = array();

$this->smarty->assign('idtext', $this->Lang('id'));

$this->smarty->assign('title_section', $this->Lang('title_export_step' . $step));
$this->smarty->assign('help_section', $this->Lang('help_export_step' . $step));

switch ($step) {
    case 1:
        $rowclass = 'row1';
        $rowarray = array();
        $templateops = & $gCms->GetTemplateOperations();
        $alltemplates = $templateops->LoadTemplates();

        foreach ($alltemplates as $templ) {
            $tmp['id'] = $templ->id;
            $tmp['name'] = $templ->name;
            $tmp['input'] = $this->CreateInputCheckbox($id, 'templ' . $templ->id, $templ->id);
            $found_templs[] = $tmp;
        }
        # export smarty variables
        $this->smarty->assign('table_items', $found_templs);
        break;
    case 2:
        # get selected items from the previous step
        $tmp = array();
        $templateops = & $gCms->GetTemplateOperations();
        foreach ($params as $key => $value) {
            if (!preg_match('/^templ/i', $key)) {
                continue;
            }

            $template_id = substr($key, strlen('templ'));
            $templates_content = $templateops->LoadTemplateByID($template_id);
            if (!$templates_content) {
                $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('error_templatenotfound'));
                return;
            }

            $tmp['id'] = $template_id;
            $tmp['name'] = $templates_content->name;
            $found_templates[] = $tmp;
        }
        # write items to session
        $_SESSION['tms']['found_templates'] = $found_templates;

        #prepare table for this step
        $styleops = & $gCms->GetStylesheetOperations();
        $styles = $styleops->LoadStylesheets();
        # get styles' names and create checkbox input
        $tmp = array();
        foreach ($styles as $style) {
            $tmp['id'] = $style->id;
            $tmp['name'] = $style->name;
            $tmp['input'] = $this->CreateInputCheckbox($id, 'style' . $style->id, $style->id);
            $found_styles[] = $tmp;
        }

        # export smarty variables
        $this->smarty->assign('table_items', $found_styles);
        break;

    case 3:
        # assign already selected items to session
        $found_templates = $_SESSION['tms']['found_templates'];

        # get selected items from the previous step
        # get details of stylesheet(s) selected on the previous page
        $tmp = array();
        $styleops = & $gCms->GetStylesheetOperations();
        foreach ($params as $key => $value) {
            if (!preg_match('/^style/i', $key)) {
                continue;
            }

            $style_id = substr($key, strlen('style'));
            $css = $styleops->LoadStylesheetByID($style_id);
            if (!$css) {
                $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('error_cssnotfound'));
                return;
            }

            $tmp['id'] = $style_id;
            $tmp['name'] = $css->name;
            $found_styles[] = $tmp;
        }
        # write items to session
        $_SESSION['tms']['found_styles'] = $found_styles;

        # prepare table for this step
        # get pages
        $db = &$gCms->GetDb();
        $tmp = array();
        foreach ($found_templates as $template) {
            $result = array();
            $query = "SELECT c.content_id, c.content_name, c.hierarchy_path FROM " . cms_db_prefix() . "content c WHERE c.template_id = ? AND (c.type='content' OR c.type='content2')";
            $dbresult = &$db->Execute($query, array($template['id']));
            while ($dbresult && !$dbresult->EOF) {
                $tmp['id'] = $dbresult->fields['content_id'];
                $tmp['name'] = $dbresult->fields['content_name'] . ' (' . $dbresult->fields['hierarchy_path'] . ')';
                $tmp['input'] = $this->CreateInputCheckbox($id, 'page' . $dbresult->fields['content_id'], $dbresult->fields['content_id']);
                $found_pages[] = $tmp;
                $dbresult->MoveNext();
            }
        }

        # export smarty variables
        $this->smarty->assign('table_items', $found_pages);
        break;

    case 4:
        # assign already selected items to session
        $found_templates = $_SESSION['tms']['found_templates'];
        $found_styles = $_SESSION['tms']['found_styles'];

        # get selected items from the previous step
        # get details of page(s) selected on the previous page
        $tmp = array();
        $db = &$gCms->GetDb();
        foreach ($params as $key => $value) {
            if (!preg_match('/^page/i', $key)) {
                continue;
            }

            $page_id = substr($key, strlen('page'));
            $result = array();
            $query = "SELECT c.content_id, c.content_name FROM " . cms_db_prefix() . "content c WHERE c.content_id = ?";
            $dbresult = &$db->Execute($query, array($page_id));
            while ($dbresult && !$dbresult->EOF) {
                $tmp['id'] = $dbresult->fields['content_id'];
                $tmp['name'] = $dbresult->fields['content_name'];
                $found_pages[] = $tmp;
                $dbresult->MoveNext();
            }
        }
        # write items to session
        $_SESSION['tms']['found_pages'] = $found_pages;
				
        # prepare table for this step
        $all_modules = array();
				$modops = $gCms->GetModuleOperations();
				$all_modules = $modops->GetInstalledModules();
        $tmp = array();
        $i = 1;
        foreach ($all_modules as $module_name) {
            $test = CmsModule::GetModuleInstance($module_name);
            $temps = $test->ListTemplates($module_name);
            foreach ($temps as $template_name) {
                $tmp['id'] = $module_name;
                $tmp['name'] = $template_name;
                $tmp['input'] = $this->CreateInputCheckbox($id, 'modtemp' . $i, $module_name . '#' . $template_name);
                $found_modules[] = $tmp;
                $i++;
            }
        }

        # export smarty variables
        $this->smarty->assign('idtext', $this->Lang('modulename'));
        $this->smarty->assign('table_items', $found_modules);
        break;

    case 5:
        # assign already selected items to session
        $found_templates = $_SESSION['tms']['found_templates'];
        $found_styles = $_SESSION['tms']['found_styles'];
        $found_pages = $_SESSION['tms']['found_pages'];
				
        # get selected items from the previous step
        # get module templates
        foreach ($params as $key => $value) {
            if (!preg_match('/^modtemp/i', $key)) {
                continue;
            }

            $test = explode('#', $value);
            $tmp['id'] = $test[0];
            $tmp['name'] = $test[1];
            $found_modules[] = $tmp;
        }
        # write items to session
        $_SESSION['tms']['found_modules'] = $found_modules;
				
        # prepare table for this step
        $blockops = & $gCms->GetGlobalContentOperations();
        $all_gbls = $blockops->LoadHtmlBlobs();
        $tmp = array();
        foreach ($all_gbls as $block) {
            $tmp['id'] = $block->id;
            $tmp['name'] = $block->name;
            $tmp['input'] = $this->CreateInputCheckbox($id, 'block' . $block->id, $block->id);
            $found_blocks[] = $tmp;
        }

        # export smarty variables
        $this->smarty->assign('table_items', $found_blocks);
        break;

    case 6:
        # assign already selected items to session
        $found_templates = $_SESSION['tms']['found_templates'];
        $found_styles = $_SESSION['tms']['found_styles'];
        $found_pages = $_SESSION['tms']['found_pages'];
        $found_modules = $_SESSION['tms']['found_modules'];

        # get selected items from the previous step
        # get content blocks
        $tmp = array();
        foreach ($params as $key => $value) {
            if (!preg_match('/^block/i', $key)) {
                continue;
            }

            $block_id = substr($key, strlen('block'));
            $blockops = & $gCms->GetGlobalContentOperations();
            $block = $blockops->LoadHtmlBlobByID($block_id);
            $tmp['id'] = $block_id;
            $tmp['name'] = $block->name;
            $found_blocks[] = $tmp;
        }
        # write items to session
        $_SESSION['tms']['found_blocks'] = $found_blocks;

        # prepare table for this step
        # get all user defined tags
        $tmp = array();
        $db = &$gCms->GetDb();
        $query = "SELECT u.userplugin_id, u.userplugin_name FROM " . cms_db_prefix() . "userplugins u";
        $dbresult = &$db->Execute($query);
        while ($dbresult && !$dbresult->EOF) {
            $tmp['id'] = $dbresult->fields['userplugin_id'];
            $tmp['name'] = $dbresult->fields['userplugin_name'];
            $tmp['input'] = $this->CreateInputCheckbox($id, 'udt' . $dbresult->fields['userplugin_id'], $dbresult->fields['userplugin_name']);
            $found_udts[] = $tmp;
            $dbresult->MoveNext();
        }
        # export smarty variables
        $this->smarty->assign('table_items', $found_udts);
        break;

    case 7:
        # assign already selected items to session
        $found_templates = $_SESSION['tms']['found_templates'];
        $found_styles = $_SESSION['tms']['found_styles'];
        $found_pages = $_SESSION['tms']['found_pages'];
        $found_modules = $_SESSION['tms']['found_modules'];
        $found_blocks = $_SESSION['tms']['found_blocks'];

        # get selected items from the previous step
        # get content blocks
        $tmp = array();
        foreach ($params as $key => $value) {
            if (!preg_match('/^udt/i', $key)) {
                continue;
            }

            $udt_id = substr($key, strlen('udt'));
            $tmp['id'] = $udt_id;
            $tmp['name'] = $value;
            $found_udts[] = $tmp;
        }
        # write items to session
        $_SESSION['tms']['found_udts'] = $found_udts;

        # prepare table for this step
        $urls = ListFiles($config['uploads_path']);

        $tmp = array();
        $i = 1;
        $filemanager = $this->GetModuleInstance('FileManager');
        foreach ($urls as $url) {
            $tmp['id'] = $i;
            $filesize = $filemanager->FormatFileSize(filesize($url));
            $url = str_replace($config['uploads_path'], '', $url);
            $tmp['input'] = $this->CreateInputCheckbox($id, 'file' . $i, $url);
            $tmp['name'] = $url . ' (' . implode(' ', $filesize) . ')';
            $found_files[] = $tmp;
            $i++;
        }

        # export smarty variables
        $this->smarty->assign('table_items', $found_files);
        break;

    case 8:
        # assign already selected items to session
        $found_templates = $_SESSION['tms']['found_templates'];
        $found_styles = $_SESSION['tms']['found_styles'];
        $found_pages = $_SESSION['tms']['found_pages'];
        $found_modules = $_SESSION['tms']['found_modules'];
        $found_blocks = $_SESSION['tms']['found_blocks'];
        $found_udts = $_SESSION['tms']['found_udts'];

        # get selected items from the previous step
        # get files
        $tmp = array();
        foreach ($params as $key => $value) {
            if (!preg_match('/^file/i', $key)) {
                continue;
            }

            $file_id = substr($key, strlen('file'));
            $tmp['id'] = $file_id;
            $tmp['name'] = $value;
            $found_files[] = $tmp;
        }
        # write items to session
        $_SESSION['tms']['found_files'] = $found_files;

        # prepare table for this step
        $all_modules = array();
				$modops = $gCms->GetModuleOperations();
				$all_modules = $modops->GetInstalledModules();
        $tmp = array();
        $i = 1;
        foreach ($all_modules as $module_name) {
            $tmp['id'] = $module_name;
            $tmp['name'] = $module_name;
            $tmp['input'] = $this->CreateInputCheckbox($id, 'setting' . $i, $module_name);
            $found_settings[] = $tmp;
            $i++;
        }

        # export smarty variables
        $this->smarty->assign('table_items', $found_settings);
        break;

    case 9:

        if (isset($params['message'])) {
            $this->smarty->assign('message', $params['message']);
        }
        # assign already selected items to session
        $found_templates = $_SESSION['tms']['found_templates'];
        $found_styles = $_SESSION['tms']['found_styles'];
        $found_pages = $_SESSION['tms']['found_pages'];
        $found_modules = $_SESSION['tms']['found_modules'];
        $found_blocks = $_SESSION['tms']['found_blocks'];
        $found_udts = $_SESSION['tms']['found_udts'];
        $found_files = $_SESSION['tms']['found_files'];
				
        # get selected items from the previous step
        $tmp = array();
        foreach ($params as $key => $value) {
            if (!preg_match('/^setting/i', $key)) {
                continue;
            }

            $setting_id = substr($key, strlen('setting'));
            $tmp['id'] = $setting_id;
            $tmp['name'] = $value;
            $found_settings[] = $tmp;
        }

        # write items to session
        $_SESSION['tms']['found_settings'] = $found_settings;

        # prepare input fields
        $this->smarty->assign('prompt_packagename', $this->Lang('prompt_packagename'));
        $this->smarty->assign('input_packagename', $this->CreateInputText($id, 'packagename', isset($params['packagename']) ? $params['packagename'] : '', 20, 20));
        $this->smarty->assign('info_packagename', $this->Lang('info_packagename'));
        $this->smarty->assign('prompt_packageversion', $this->Lang('prompt_packageversion'));
        $this->smarty->assign('input_packageversion', $this->CreateInputText($id, 'packageversion', isset($params['packageversion']) ? $params['packageversion'] : '', 20, 20));
        $this->smarty->assign('info_packageversion', $this->Lang('info_packageversion'));
        $this->smarty->assign('prompt_authorname', $this->Lang('prompt_authorname'));
        $this->smarty->assign('input_authorname', $this->CreateInputText($id, 'authorname', isset($params['authorname']) ? $params['authorname'] : '', 20));
        $this->smarty->assign('info_authorname', $this->Lang('info_authorname'));
        $this->smarty->assign('prompt_notes', $this->Lang('prompt_notes'));
        $this->smarty->assign('input_notes', $this->CreateTextArea(true, $id, isset($params['notes']) ? $params['notes'] : '', 'notes'));
        $this->smarty->assign('info_notes', $this->Lang('info_notes'));

        # export smarty variables
        break;

    case 10:
        #check package
        if (empty($params['packagename'])) {
            $params['message'] = 'emptypackagename';
            $params['step'] = 9;
            $this->Redirect($id, 'export', $returnid, $params);
        }
        if (empty($params['packageversion'])) {
            $params['message'] = 'emptypackageversion';
            $params['step'] = 9;
            $this->Redirect($id, 'export', $returnid, $params);
        }

        # assign already selected items to session
        $found_templates = $_SESSION['tms']['found_templates'];
        $found_styles = $_SESSION['tms']['found_styles'];
        $found_pages = $_SESSION['tms']['found_pages'];
        $found_modules = $_SESSION['tms']['found_modules'];
        $found_blocks = $_SESSION['tms']['found_blocks'];
        $found_udts = $_SESSION['tms']['found_udts'];
        $found_files = $_SESSION['tms']['found_files'];
        $found_settings = $_SESSION['tms']['found_settings'];

        # get fields from the previous page
        $package_info = array('packagename' => $params['packagename'],
            'packageversion' => $params['packageversion'],
            'authorname' => $params['authorname'],
            'notes' => $params['notes']);
        $this->smarty->assign('mod', $this);
        $this->smarty->assign('info', $package_info);
        # write fields to session
        $_SESSION['tms']['info'] = $package_info;

        # export smarty variables
        break;

    case 11:
        $found_templates = $_SESSION['tms']['found_templates'];
        $found_styles = $_SESSION['tms']['found_styles'];
        $found_pages = $_SESSION['tms']['found_pages'];
        $found_modules = $_SESSION['tms']['found_modules'];
        $found_blocks = $_SESSION['tms']['found_blocks'];
        $found_udts = $_SESSION['tms']['found_udts'];
        $found_files = $_SESSION['tms']['found_files'];
        $found_settings = $_SESSION['tms']['found_settings'];
        $package_info = $_SESSION['tms']['info'];
        $this->smarty->assign('mod', $this); // this is only for debug!


        $doc = new DomDocument('1.0');
        $package = $doc->createElement('package');
        $package = $doc->appendChild($package);

        # 0. write info part to the package
        $infos = $doc->createElement('infos');
        $package->appendChild($infos);
        foreach ($package_info as $l => $v) {
            $info = $doc->createElement($l);
            $infos->appendChild($info);
            $text = $doc->createTextNode($v);
            $info->appendChild($text);
        }

        # read and write CMSMS version
        $info = $doc->createElement('cmsmsversion');
        $infos->appendChild($info);
        $text = $doc->createTextNode($GLOBALS['CMS_VERSION']);
        $info->appendChild($text);
        
        # read and write the version of Themes Made Simple module
        # XML files can differ while the module version changes.
        $info = $doc->createElement('tmsversion');
        $infos->appendChild($info);
        $text = $doc->createTextNode($this->GetVersion());
        $info->appendChild($text);

        # 0. read and write modules version
        $modules = array();
        if (sizeof($found_modules) > 0) {
            foreach ($found_modules as $key => $data) {
                $modules[] = $data['id'];
            }
        }
        if (sizeof($found_settings) > 0) {
            foreach ($found_settings as $key => $data) {
                $modules[] = $data['name'];
            }
        }
        $modules = array_unique($modules);

        $moduleversions = $doc->createElement('moduleversions');
        $package->appendChild($moduleversions);

        foreach ($modules as $modulename) {
            $module = $doc->createElement('moduleversion');
            $moduleversions->appendChild($module);
            $name = $doc->createElement('name');
            $module->appendChild($name);
            $text = $doc->createTextNode($modulename);
            $name->appendChild($text);
            $version = $doc->createElement('version');
            $module->appendChild($version);
            $test = CmsModule::GetModuleInstance($modulename);
            $text = $doc->CreateTextNode($test->GetVersion());
            $version->appendChild($text);
        }

        # 1. write templates
        if (sizeof($found_templates) > 0) {
            $templates = $doc->createElement('templates');
            $package->appendChild($templates);

            $ids = array();
            foreach ($found_templates as $template) {
                $ids[] = $template['id'];
            }
            $query = "SELECT template_name, template_content FROM " . cms_db_prefix() . "templates WHERE template_id IN (" . implode(',', $ids) . ")";
            $dbresult = $db->Execute($query);

            while ($dbresult && $row = $dbresult->FetchRow()) {
                $table = $doc->createElement('template');
                $templates->appendChild($table);
                // add a child node for each field
                foreach ($row as $fieldname => $fieldvalue) {
                    $child = $doc->createElement($fieldname);
                    $table->appendChild($child);
                    $value = $doc->createCDATASection($fieldvalue);
                    $child->appendChild($value);
                }
            }
        }

        # 2. write stylesheets
        if (sizeof($found_styles) > 0) {
            $stylesheets = $doc->createElement('stylesheets');
            $package->appendChild($stylesheets);

            $ids = array();
            foreach ($found_styles as $style) {
                $ids[] = $style['id'];
            }
            $query = "SELECT css_name, css_text, media_type FROM " . cms_db_prefix() . "css WHERE css_id IN (" . implode(',', $ids) . ")";
            $dbresult = $db->Execute($query);

            while ($dbresult && $row = $dbresult->FetchRow()) {
                $table = $doc->createElement('css');
                $stylesheets->appendChild($table);
                // add a child node for each field
                foreach ($row as $fieldname => $fieldvalue) {
                    $child = $doc->createElement($fieldname);
                    $table->appendChild($child);
                    $value = $doc->createCDATASection($fieldvalue);
                    $child->appendChild($value);
                }
            }
        }

        # 2a. write assocs
        if (sizeof($found_templates) > 0 && sizeof($found_styles) > 0) {
            $assocs = $doc->createElement('assocs');
            $package->appendChild($assocs);

            $ids = array();
            foreach ($found_templates as $template) {
                $tpl_ids[] = $template['id'];
            }
            foreach ($found_styles as $style) {
                $css_ids[] = $style['id'];
            }
            $query = "SELECT css_name, template_name FROM " . cms_db_prefix() . "css, "
                    . cms_db_prefix() . "templates, " . cms_db_prefix() . "css_assoc "
                    . " WHERE css_id=assoc_css_id and template_id=assoc_to_id"
                    . " AND template_id IN (" . implode(',', $tpl_ids)
                    . ") AND css_id IN (" . implode(',', $css_ids) . ")";
            $dbresult = $db->Execute($query);

            while ($dbresult && $row = $dbresult->FetchRow()) {
                $table = $doc->createElement('assoc');
                $assocs->appendChild($table);
                // add a child node for each field
                foreach ($row as $fieldname => $fieldvalue) {
                    $child = $doc->createElement($fieldname);
                    $table->appendChild($child);
                    $value = $doc->createCDATASection($fieldvalue);
                    $child->appendChild($value);
                }
            }
        }

        # 3. write pages
        if (sizeof($found_pages) > 0) {
            $contents = $doc->createElement('pages');
            $package->appendChild($contents);

            $ids = array();
            foreach ($found_pages as $page) {
                $ids[] = $page['id'];
            }
            $query = "SELECT content_name, type, t.template_id, template_name, menu_text, content_alias, show_in_menu,
                markup, cachable, prop_names, metadata, hierarchy_path  FROM " . cms_db_prefix() . "content c, "
                    . cms_db_prefix() . "templates t WHERE t.template_id=c.template_id"
                    . " AND content_id IN (" . implode(',', $ids) . ")";
            $dbresult = $db->Execute($query);

            while ($dbresult && $row = $dbresult->FetchRow()) {
                // check level
                //$row['level'] = substr_count($row['hierarchy_path'],"/");
                $content = $doc->createElement('page');
                $contents->appendChild($content);
                // add a child node for each field
                foreach ($row as $fieldname => $fieldvalue) {
                    $child = $doc->createElement($fieldname);
                    $content->appendChild($child);
                    $value = $doc->createCDATASection($fieldvalue);
                    $child->appendChild($value);
                }
                $content_props = $doc->createElement('content_props');
                $content->appendChild($content_props);
                // get content properties
                $query = "SELECT c.content_alias, p.type, p.prop_name, p.param1, p.param2, p.param3,
                    content FROM " . cms_db_prefix() . "content_props p, " . cms_db_prefix() . "content c
                            WHERE c.content_id = p.content_id"
                        . " AND c.content_alias = ?";
                $dbresult2 = $db->Execute($query, array($row['content_alias']));

                while ($dbresult2 && $row2 = $dbresult2->FetchRow()) {
                    $content_prop = $doc->createElement('content_prop');
                    $content_props->appendChild($content_prop);
                    // add a child node for each field
                    foreach ($row2 as $fieldname => $fieldvalue) {
                        $child = $doc->createElement($fieldname);
                        $content_prop->appendChild($child);
                        $value = $doc->createCDATASection($fieldvalue);
                        $child->appendChild($value);
                    }
                }
            }
        }

        # 4. write module templates
        if (sizeof($found_modules) > 0) {

            $module_templates = $doc->createElement('module_templates');
            $package->appendChild($module_templates);
						
            foreach ($found_modules as $found_module) {
                $module_template = $doc->createElement('module_template');
                $module_templates->appendChild($module_template);
                $test = CmsModule::GetModuleInstance($found_module['id']);
                $content = $test->GetTemplate($found_module['name'], $found_module['id']);
                $child = $doc->createElement('module_name');
                $module_template->appendChild($child);
                $value = $doc->createCDATASection($found_module['id']);
                $child->appendChild($value);
                $child = $doc->createElement('template_name');
                $module_template->appendChild($child);
                $value = $doc->createCDATASection($found_module['name']);
                $child->appendChild($value);
                $child = $doc->createElement('content');
                $module_template->appendChild($child);
                $value = $doc->createCDATASection($content);
                $child->appendChild($value);
            }
        }

        # 5. write global contents
        if (sizeof($found_blocks) > 0) {

            $htmlblobs = $doc->createElement('htmlblobs');
            $package->appendChild($htmlblobs);

            $blockops = & $gCms->GetGlobalContentOperations();
            foreach ($found_blocks as $block) {
                $htmlblob = $blockops->LoadHtmlBlobByName($block['name']);
                $table = $doc->createElement('htmlblob');
                $htmlblobs->appendChild($table);
                $child = $doc->createElement('htmlblob_name');
                $table->appendChild($child);
                $value = $doc->createCDATASection($htmlblob->name);
                $child->appendChild($value);
                $child = $doc->createElement('html');
                $table->appendChild($child);
                $value = $doc->createCDATASection($htmlblob->content);
                $child->appendChild($value);
                $child = $doc->createElement('use_wysiwyg');
                $table->appendChild($child);
                $value = $doc->createCDATASection($htmlblob->use_wysiwyg);
                $child->appendChild($value);
                $child = $doc->createElement('description');
                $table->appendChild($child);
                $value = $doc->createCDATASection($htmlblob->description);
                $child->appendChild($value);
            }
        }

        # 6. write user defined tags
        if (sizeof($found_udts) > 0) {
            $userplugins = $doc->createElement('userplugins');
            $package->appendChild($userplugins);

            $udtops = & $gCms->GetUserTagOperations();
            foreach ($found_udts as $udt) {
                $code = $udtops->GetUserTag($udt['name']);
                $userplugin = $doc->createElement('userplugin');
                $userplugins->appendChild($userplugin);
                $child = $doc->createElement('userplugin_name');
                $userplugin->appendChild($child);
                $value = $doc->createCDATASection($udt['name']);
                $child->appendChild($value);
                $child = $doc->createElement('code');
                $userplugin->appendChild($child);
                $value = $doc->createCDATASection($code['code']);
                $child->appendChild($value);
            }
        }

        # 7. write files
        if (sizeof($found_files) > 0) {
            $files = $doc->createElement('files');
            $package->appendChild($files);

            foreach ($found_files as $ref) {
                $contents = @file_get_contents($config['uploads_path'] . $ref['name']);
                if (!$contents) {
                    continue;
                }
                $encoded = base64_encode($contents);
                $file = $doc->createElement('file');
                $files->appendChild($file);
                $child = $doc->createElement('location');
                $file->appendChild($child);
                $value = $doc->createCDATASection($ref['name']);
                $child->appendChild($value);
                $child = $doc->createElement('encoded');
                $file->appendChild($child);
                $value = $doc->createCDATASection($encoded);
                $child->appendChild($value);
            }
        }

        # 8. write module settings (preferences)
        if (sizeof($found_settings) > 0) {

            $settings = $doc->createElement('settings');
            $package->appendChild($settings);

            foreach ($found_settings as $module) {
                $query = "SELECT sitepref_name, sitepref_value FROM " . cms_db_prefix() . "siteprefs "
                        . " WHERE sitepref_name LIKE '" . $module['name'] . "_mapi_pref_%'";
                $dbresult = $db->Execute($query);

                $setting = $doc->createElement('setting');
                $settings->appendChild($setting);
                $modulename = $doc->createElement('modulename');
                $setting->appendChild($modulename);
                $value = $doc->createCDATASection($module['name']);
                $modulename->appendChild($value);

                while ($dbresult && $row = $dbresult->FetchRow()) {
                    // add a child node for each field
                    $sitepref = $doc->createElement('sitepref');
                    $setting->appendChild($sitepref);
                    foreach ($row as $fieldname => $fieldvalue) {
                        $child = $doc->createElement($fieldname);
                        $sitepref->appendChild($child);
                        $value = $doc->createCDATASection($fieldvalue);
                        $child->appendChild($value);
                    }
                }
            }
        }

        $xml_string = $doc->saveXML();

        // and write it to file
        header('Content-Description: File Transfer');
        header('Content-Type: application/force-download');
        header('Content-Disposition: attachment; filename=' . munge_string_to_url($package_info['packagename'] . '.' . $package_info['packageversion']) . '.xml');
        while (@ob_end_clean())
            ;
        echo $xml_string;
        exit();
        /* $file = $config['root_path'] . '\modules\ThemesMadeSimple\examples\test1.xml';
          $fh = fopen($file, 'w') or die('not file');
          fwrite($fh, $xml_string);
          fclose($fh); */

        break;
}

$this->smarty->assign('found_templates', $found_templates);
$this->smarty->assign('found_styles', $found_styles);
$this->smarty->assign('found_pages', $found_pages);
$this->smarty->assign('found_modules', $found_modules);
$this->smarty->assign('found_blocks', $found_blocks);
$this->smarty->assign('found_udts', $found_udts);
$this->smarty->assign('found_files', $found_files);
$this->smarty->assign('found_settings', $found_settings);
$this->smarty->assign('package_info', $package_info);

$this->smarty->assign('nametext', $this->Lang('name'));
$this->smarty->assign('actiontext', $this->Lang('action'));
$this->smarty->assign('step', $step);
$this->smarty->assign('nextstep', $this->CreateInputHidden($id, 'step', ($step + 1)));
$this->smarty->assign('startform', $this->CreateFormStart($id, 'export', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('continue_export')));

$this->smarty->assign('mod', $this);
echo $this->ProcessTemplate('export.tpl');
?>