<?php

if (!isset($gCms))
    exit;

if (!$this->CheckAccess("Manage Themes")) {
    return $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
}

function xml_parse_into_assoc($file) {
    $data = implode("", file($file));
    $p = xml_parser_create();

    xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);
    xml_parser_set_option($p, XML_OPTION_SKIP_WHITE, 1);

    xml_parse_into_struct($p, $data, $vals, $index);
    xml_parser_free($p);

    $levels = array(null);

    foreach ($vals as $val) {
        if ($val['type'] == 'open' || $val['type'] == 'complete') {
            if (!array_key_exists($val['level'], $levels)) {
                $levels[$val['level']] = array();
            }
        }

        $prevLevel = & $levels[$val['level'] - 1];
        $parent = $prevLevel[sizeof($prevLevel) - 1];

        if ($val['type'] == 'open') {
            $val['children'] = array();
            array_push(&$levels[$val['level']], $val);
            continue;
        } else if ($val['type'] == 'complete' && isset($val['value'])) {
            $parent['children'][$val['tag']] = $val['value'];
        } else if ($val['type'] == 'close') {
            $pop = array_pop($levels[$val['level']]);
            $tag = $pop['tag'];


            if ($parent) {
                if (!array_key_exists($tag, $parent['children'])) {
                    $parent['children'][$tag] = $pop['children'];
                } else if (is_array($parent['children'][$tag])) {
                    if (!isset($parent['children'][$tag][0])) {
                        $oldSingle = $parent['children'][$tag];
                        $parent['children'][$tag] = null;
                        $parent['children'][$tag][] = $oldSingle;
                    }
                    $parent['children'][$tag][] = $pop['children'];
                }
            } else {
                return(array($pop['tag'] => $pop['children']));
            }
        }

        $prevLevel[sizeof($prevLevel) - 1] = $parent;
    }
}

function getTemplateIdByName($name) {
    global $db;
    $query = "SELECT template_id FROM " . cms_db_prefix() . "templates WHERE template_name = ?";
    $result = $db->getOne($query, array($name));
    return $result;
}

function insertImport($theme_id, $type, $name, $system_id = '', $module = '', $location = '') {
    global $db;
    $insert = false;
    switch ($type) {
        case 'template':
            $query = "SELECT count(1) FROM " . cms_db_prefix() . "module_themesms_comp WHERE theme_id = ? AND type =? AND name = ?";
            $found = $db->GetOne($query, array($theme_id, $type, $name));
            if (!$found) {
                $insert = true;
            } else {
                $query = "UPDATE " . cms_db_prefix() . "module_themesms_comp SET system_id = ? WHERE WHERE theme_id = ? AND type =? AND name = ?";
                $db->Execute($query, array($system_id, $theme_id, $type, $name));
            }
            break;
        case 'style':
            $query = "SELECT count(1) FROM " . cms_db_prefix() . "module_themesms_comp WHERE theme_id = ? AND type =? AND name = ?";
            $found = $db->GetOne($query, array($theme_id, $type, $name));
            if (!$found) {
                $insert = true;
            } else {
                $query = "UPDATE " . cms_db_prefix() . "module_themesms_comp SET system_id = ? WHERE WHERE theme_id = ? AND type =? AND name = ?";
                $db->Execute($query, array($system_id, $theme_id, $type, $name));
            }
            break;
        case 'page':
            $query = "SELECT count(1) FROM " . cms_db_prefix() . "module_themesms_comp WHERE theme_id = ? AND type =? AND name = ?";
            $found = $db->GetOne($query, array($theme_id, $type, $name));
            if (!$found) {
                $insert = true;
            }
            break;
        case 'module':
            $query = "SELECT count(1) FROM " . cms_db_prefix() . "module_themesms_comp WHERE theme_id = ? AND type =? AND name = ? and module = ?";
            $found = $db->GetOne($query, array($theme_id, $type, $name, $module));
            if (!$found) {
                $insert = true;
            }
            break;
        case 'udt':
            $query = "SELECT count(1) FROM " . cms_db_prefix() . "module_themesms_comp WHERE theme_id = ? AND type =? AND name = ?";
            $found = $db->GetOne($query, array($theme_id, $type, $name));
            if (!$found) {
                $insert = true;
            }
            break;
        case 'file':
            $query = "SELECT count(1) FROM " . cms_db_prefix() . "module_themesms_comp WHERE theme_id = ? AND type =? AND name = ? AND location = ?";
            $found = $db->GetOne($query, array($theme_id, $type, $name, $location));
            if (!$found) {
                $insert = true;
            }
            break;
    }
    if ($insert) {
        $query = "INSERT INTO " . cms_db_prefix() . "module_themesms_comp (theme_id, type, system_id, name, module, location) VALUES (?,?,?,?,?,?)";
        $db->Execute($query, array($theme_id, $type, $system_id, $name, $module, $location));
    }
}

function saveEncodedFile($obj, $prefix, $name, $location, $encoded, $data) {
    // clean up the location
    if (substr($location, 0, 1) == '/') {
        $location = substr($location, 1);
    }

    if ($encoded) {
        $data = base64_decode($data);
    }

    // translate slashes if we have to
    $newloc = preg_replace('|\/|', DIRECTORY_SEPARATOR, $location);

    $dir = $prefix . DIRECTORY_SEPARATOR . dirname($location);
    if (!file_exists($dir)) {
        $obj->_mkdirr( $dir );
        if (!file_exists($dir)) {
            return 0;
        }
    }

    // and put it out there
    global $gCms;
    $fn = $prefix . DIRECTORY_SEPARATOR . $newloc;
    $fp = fopen($fn, "w");
    if (!$fp) {
        return 0;
    }
    fwrite($fp, $data);
    fclose($fp);
    return 1;
}

function checkPage($page_hierarchy, $found_pages) {
    global $db, $gCms;
    $paths = array();
    $parents = array();
    foreach ($found_pages as $page) {
        $parents[] = $page['hierarchy_path'];
    }
    $query = "SELECT hierarchy_path FROM " . cms_db_prefix() . "content";
    $dbresult = $db->Execute($query);
    while ($dbresult && $row = $dbresult->FetchRow()) {
        $paths[] = $row['hierarchy_path'];
    }
    $paths = array_unique($paths);
    $parents = array_unique($parents);
    $parent = substr($page_hierarchy, 0, strrpos($page_hierarchy, '/', -2));
    if (in_array($page_hierarchy, $paths)) {
        // page exists in the hierarchy, page can be overwritten!
        return 'caution';
    } else if (in_array($parent, $paths) || empty($parent) || in_array($parent, $parents)) {
        // page does not exist, but hierarchy exists, page can be created
        return 'new';
    } else {
        // hierarchy path not found, page will not be created
        return 'false';
    }
}

if (!isset($params['step'])) {
    $step = 1;
} else {
    $step = $params['step'];
}

if ($step == 1 && empty($_FILES[$id . 'importfile'])) {
    $this->Redirect($id, 'defaultadmin', $returnid, array('message' => 'nofile', 'active_tab' => 'import'));
} elseif ($step == 1 && !empty($_FILES[$id . 'importfile'])) {
    // TODO: check file, XML?, root is package, packagename?
    $tmp_name = $_FILES[$id . 'importfile']['tmp_name'];
    $xml_file = $config['previews_path'] . DIRECTORY_SEPARATOR . $_FILES[$id . 'importfile']['name'];
    if (!move_uploaded_file($tmp_name, $xml_file)) {
        $this->Redirect($id, 'defaultadmin', $returnid, array('message' => 'uploadfailed', 'active_tab' => 'import'));
    }
    $_SESSION['xml_file'] = $xml_file;
} else {
    $xml_file = $_SESSION['xml_file'];
}

$xml_array = xml_parse_into_assoc($xml_file);

$this->smarty->assign('title_section', $this->Lang('title_import_step' . $step));
$this->smarty->assign('help_section', $this->Lang('help_import_step' . $step));


/*
  print '<pre>';
  print_r($xml_array);
  print '</pre>';
  exit;
 */

$package_info = $xml_array["package"]["infos"];
if (!isset($package_info['authorname'])) {
    $package_info['authorname'] = "";
}
if (!isset($package_info['notes'])) {
    $package_info['notes'] = "";
}

// this is very akward due to the function xml_parse_into_assoc() creating no array for single child, suggestions welcome :)
if (isset($xml_array["package"]["templates"])) {
    $found_templates = isset($xml_array["package"]["templates"]["template"][0]) ? $xml_array["package"]["templates"]["template"] : $xml_array["package"]["templates"];
} else {
    $found_templates = array();
}
if (isset($xml_array["package"]["stylesheets"])) {
    $found_styles = isset($xml_array["package"]["stylesheets"]["css"][0]) ? $xml_array["package"]["stylesheets"]["css"] : $xml_array["package"]["stylesheets"];
} else {
    $found_styles = array();
}
if (isset($xml_array["package"]["assocs"])) {
    $found_assocs = isset($xml_array["package"]["assocs"]["assoc"][0]) ? $xml_array["package"]["assocs"]["assoc"] : $xml_array["package"]["assocs"];
} else {
    $found_assocs = array();
}
if (isset($xml_array["package"]["pages"])) {
    $found_pages = isset($xml_array["package"]["pages"]["page"][0]) ? $xml_array["package"]["pages"]["page"] : $xml_array["package"]["pages"];
} else {
    $found_pages = array();
}
if (isset($xml_array["package"]["module_templates"])) {
    $found_module_tpls = isset($xml_array["package"]["module_templates"]["module_template"][0]) ? $xml_array["package"]["module_templates"]["module_template"] : $xml_array["package"]["module_templates"];
} else {
    $found_module_tpls = array();
}
if (isset($xml_array["package"]["htmlblobs"])) {
    $found_blocks = isset($xml_array["package"]["htmlblobs"]["htmlblob"][0]) ? $xml_array["package"]["htmlblobs"]["htmlblob"] : $xml_array["package"]["htmlblobs"];
} else {
    $found_blocks = array();
}
if (isset($xml_array["package"]["userplugins"])) {
    $found_udts = isset($xml_array["package"]["userplugins"]["userplugin"][0]) ? $xml_array["package"]["userplugins"]["userplugin"] : $xml_array["package"]["userplugins"];
} else {
    $found_udts = array();
}
if (isset($xml_array["package"]["files"])) {
    $found_files = isset($xml_array["package"]["files"]["file"][0]) ? $xml_array["package"]["files"]["file"] : $xml_array["package"]["files"];
} else {
    $found_files = array();
}
if (isset($xml_array["package"]["settings"])) {
    $found_settings = isset($xml_array["package"]["settings"]["setting"][0]) ? $xml_array["package"]["settings"]["setting"] : $xml_array["package"]["settings"];
} else {
    $found_settings = array();
}
if (isset($xml_array["package"]["moduleversions"])) {
    $found_modules = isset($xml_array["package"]["moduleversions"]["moduleversion"][0]) ? $xml_array["package"]["moduleversions"]["moduleversion"] : $xml_array["package"]["moduleversions"];
} else {
    $found_modules = array();
}

switch ($step) {
    case 1:
        // get package info
        foreach ($package_info as $label => $value) {
            $this->smarty->assign('prompt_' . $label, $this->Lang('prompt_' . $label));
            $this->smarty->assign('input_' . $label, isset($value) ? $value : '');
        }

        $this->smarty->assign('module_versions', $found_modules);
        $this->smarty->assign('found_templates', $found_templates);
        $this->smarty->assign('found_styles', $found_styles);
        $this->smarty->assign('found_pages', $found_pages);
        $this->smarty->assign('found_modules', $found_module_tpls);
        $this->smarty->assign('found_blocks', $found_blocks);
        $this->smarty->assign('found_udts', $found_udts);
        $this->smarty->assign('found_files', $found_files);
        $this->smarty->assign('found_settings', $found_settings);

        break;
    case 2:
        // check cmsmsversion
        if ($GLOBALS['CMS_VERSION'] != $package_info['cmsmsversion']) {
            $this->smarty->assign('check_cmsmsversion', $GLOBALS['CMS_VERSION'] . $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif') . $this->Lang('recommended', $package_info['cmsmsversion']));
        } else {
            $this->smarty->assign('check_cmsmsversion', $package_info['cmsmsversion'] . $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', lang('OK')));
        }

        // check Themes Made Simple version
        if ($this->GetVersion() != $package_info['tmsversion']) {
            $this->smarty->assign('check_tmsversion', $this->GetVersion() . $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif') . $this->Lang('recommended', $package_info['tmsversion']));
        } else {
            $this->smarty->assign('check_tmsversion', $package_info['tmsversion'] . $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', lang('OK')));
        }


        $foo = array();
        foreach ($found_modules as $module) {
            // check if module installed
            $test = CmsModule::GetModuleInstance($module['name']);
            if (!$test) {
                $module['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif') . $this->Lang('required', $module['version']);
            } elseif ($module['version'] != $test->GetVersion($module['name'])) {
                $module['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif') . $this->Lang('recommended', $module['version']);
            } else {
                $module['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('success'));
            }
            array_push($foo, $module);
        }
        $this->smarty->assign('module_versions', $foo);

        break;
    case 3:
        // TODO: Check package name for duplicates, upgrade?
        // check name conflicts
        $templateops = & $gCms->GetTemplateOperations();
        $foo = array();
        foreach ($found_templates as $template) {
            if ($templateops->CheckExistingTemplateName($template['template_name'])) {
                $template['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif', $this->Lang('warning'));
            } else {
                $template['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('success'));
            }
            array_push($foo, $template);
        }
        $this->smarty->assign('found_templates', $foo);

        $styleops = & $gCms->GetStylesheetOperations();
        $foo = array();
        foreach ($found_styles as $style) {
            if ($styleops->CheckExistingStylesheetName($style['css_name'])) {
                $style['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif', $this->Lang('warning'));
            } else {
                $style['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('success'));
            }
            array_push($foo, $style);
        }
        $this->smarty->assign('found_styles', $foo);

        // check pages
        $foo = array();
        foreach ($found_pages as $page) {
            $check = checkPage($page['hierarchy_path'], $found_pages);
            switch ($check) {
                case 'new':
                    $page['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('success'));
                    break;
                case 'caution':
                    $page['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif', $this->Lang('warning'));
                    break;
                case 'false':
                    $page['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif', $this->Lang('error'));
                    break;
            }
            array_push($foo, $page);
        }
        $this->smarty->assign('found_pages', $foo);

        $foo = array();
        foreach ($found_module_tpls as $module) {
            if ($this->GetTemplate($module['template_name'], $module['module_name'])) {
                $module['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif', $this->Lang('warning'));
            } else {
                $module['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('success'));
            }
            array_push($foo, $module);
        }
        $this->smarty->assign('found_modules', $foo);

        // check blocks
        $blockops = & $gCms->GetGlobalContentOperations();
        $foo = array();
        foreach ($found_blocks as $block) {
            if ($blockops->CheckExistingHtmlBlobName($block['htmlblob_name'])) {
                $block['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif', $this->Lang('warning'));
            } else {
                $block['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('success'));
            }
            array_push($foo, $block);
        }
        $this->smarty->assign('found_blocks', $foo);

        $udtops = & $gCms->GetUserTagOperations();
        $foo = array();
        foreach ($found_udts as $udt) {
            if ($udtops->GetUserTag($udt['userplugin_name'])) {
                $udt['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif', $this->Lang('warning'));
            } else {
                $udt['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('success'));
            }
            array_push($foo, $udt);
        }
        $this->smarty->assign('found_udts', $foo);

        $foo = array();
        foreach ($found_files as $file) {
            if (file_exists($config['uploads_path'] . $file['location'])) {
                $file['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/warning.gif', $this->Lang('warning'));
            } else {
                $file['info'] = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('success'));
            }
            array_push($foo, $file);
        }
        $this->smarty->assign('found_files', $foo);
        break;
    case 4:
        // start to log package info
        $query = "SELECT id FROM " . cms_db_prefix() . "module_themesms WHERE name=?";
        $package_id = $db->GetOne($query, array($package_info['packagename']));
        if (!$package_id) {
            $package_id = $db->GenID(cms_db_prefix() . "module_themesms_seq");
            $query = "INSERT INTO " . cms_db_prefix() . "module_themesms (id, name, notes, version, author) values (?,?,?,?,?)";
            $db->Execute($query, array($package_id, $package_info['packagename'], $package_info['notes'],
                $package_info['packageversion'], $package_info['authorname']));
        } else {
            $query = "UPDATE " . cms_db_prefix() . "module_themesms SET notes = ?, version = ?, author = ? WHERE id = ?";
            $db->Execute($query, array($package_info['notes'],
                $package_info['packageversion'], $package_info['authorname'], $package_id));
        }

        // import templates
        $templateops = & $gCms->GetTemplateOperations();
        foreach ($found_templates as $template) {
            $tpl = new Template();
            $tpl->name = $template['template_name'];
            $tpl->content = $template['template_content'];
            $tpl->active = 1;
            if ($templateops->CheckExistingTemplateName($template['template_name'])) {
                $templateops->UpdateTemplate($tpl);
                $tpl_id = getTemplateIdByName($template['template_name']);
            } else {
                $tpl_id = $templateops->InsertTemplate($tpl);
            }
            insertImport($package_id, 'template', $template['template_name'], $tpl_id);
        }

        // import stylesheets
        $styleops = & $gCms->GetStylesheetOperations();
        foreach ($found_styles as $style) {
            $stl = new Stylesheet();
            $stl->name = $style['css_name'];
            $stl->value = $style['css_text'];
            $stl->media_type = isset($style['media_type']) ? $style['media_type'] : '';

            if ($styleops->CheckExistingStylesheetName($style['css_name'])) {
                $styleops->UpdateStylesheet($stl);
                $query = "SELECT css_id FROM " . cms_db_prefix() . "css WHERE css_name = ?";
                $css_id = $db->getOne($query, array($style['css_name']));
            } else {
                $css_id = $styleops->InsertStylesheet($stl);
            }
            insertImport($package_id, 'style', $style['css_name'], $css_id);
        }

        // associate stylesheet to template
        foreach ($found_assocs as $assoc) {
            $tpl_id = getTemplateIdByName($assoc['template_name']);
            $query = "SELECT css_id FROM " . cms_db_prefix() . "css WHERE css_name = ?";
            $css_id = $db->getOne($query, array($assoc['css_name']));
            // API does not check if assoc already exists
            $query = "SELECT count(1) FROM " . cms_db_prefix() . "css_assoc WHERE assoc_to_id = ? AND assoc_css_id = ?";
            $found = $db->getOne($query, array($tpl_id, $css_id));
            if (!$found) {
                $styleops->AssociateStylesheetToTemplate($css_id, $tpl_id);
            }
        }

        // import module templates
        foreach ($found_module_tpls as $module) {
            if (CmsModule::GetModuleInstance($module['module_name'])) {
                $this->SetTemplate($module['template_name'], $module['content'], $module['module_name']);
                insertImport($package_id, 'module', $module['template_name'], '', $module['module_name']);
            }
        }

        // import pages
        $contentops = & $gCms->GetContentOperations();
        $userid = get_userid();
        foreach ($found_pages as $page) {
            $status = checkPage($page['hierarchy_path'], $found_pages);
            if ($status != 'false') {
                $contentobj = $contentops->LoadContentFromAlias($page['content_alias']);
                if (!$contentobj) {
                    $contentobj = $contentops->CreateNewContent($page['type']);
                    $contentobj->SetParentId(-1);
                }
                $contentobj->SetMenuText($page['menu_text']);
                $contentobj->SetName($page['content_name']);
                $contentobj->SetAlias($page['content_alias']);
                $contentobj->SetOwner($userid);
                $contentobj->SetCachable($page['cachable']);
                $contentobj->SetActive(1);
                $contentobj->SetShowInMenu($page['show_in_menu']);
                $contentobj->SetLastModifiedBy($userid);
                $contentobj->SetMetadata(isset($page['metadata']) ? $page['metadata'] : '');
                $contentobj->SetTemplateId(getTemplateIdByName($page['template_name']));
                foreach ($page['content_props']['content_prop'] as $prop) {
                    if (isset($prop['content'])) {
                        $contentobj->SetPropertyValue($prop['prop_name'], $prop['content']);
                    }
                }
                $contentobj->Save();
            }
        }

        // set hierarchy
        foreach ($found_pages as $page) {
            $status = checkPage($page['hierarchy_path'], $found_pages);
            if ($status != 'false') {
                $contentobj = $contentops->LoadContentFromAlias($page['content_alias']);
                if ($contentobj) {
                    $parent = basename(str_replace($page['content_alias'], '', $page['hierarchy_path']));
                    $contentobj->SetOldParentId($contentobj->ParentId());
                    if (!empty($parent)) {
                        $contentobj->SetParentId($contentops->GetPageIDFromAlias($parent));
                    } else {
                        $contentobj->SetParentId(-1);
                    }
                    if ($contentobj->ParentId() <> $contentobj->OldParentId()) {
                        $contentobj->SetItemOrder(-1);
                    }
                    $contentobj->SetHierarchyPath($page['hierarchy_path']);
                    $contentobj->Save();
                }
                insertImport($package_id, 'page', $page['content_alias'], $contentobj->Id());
            }
        }
        $contentops->SetAllHierarchyPositions(); // This does not set the position hierarchy correctly
        // import blocks
        $blockops = & $gCms->GetGlobalContentOperations();
        foreach ($found_blocks as $block) {
            if ($blockops->CheckExistingHtmlBlobName($block['htmlblob_name'])) {
                $blk = $blockops->LoadHTMLBlobByName($block['htmlblob_name']);
                $blk->content = $block['html'];
                $blk->use_wysiwyg = $block['use_wysiwyg'];
                $blk->description = $block['description'];
                $blockops->UpdateHtmlBlob($blk);
            } else {
                $blk = new GlobalContent();
                $blk->name = $block['htmlblob_name'];
                $blk->content = $block['html'];
                $blk->owner = $userid;
                $blk->description = $block['description'];
                $blockops->InsertHtmlBlob($blk);
            }
        }

        // import udts
        $udtops = & $gCms->GetUserTagOperations();
        foreach ($found_udts as $udt) {
            $udtops->SetUserTag($udt['userplugin_name'], $udt['code']);
            insertImport($package_id, 'udt', $udt['userplugin_name']);
        }

        // write files
        foreach ($found_files as $file) {
            $prefix = str_replace(basename($file['location']),'',$file['location']);
            $prefix = preg_replace('|\/|', DIRECTORY_SEPARATOR, $prefix);
            saveEncodedFile($this, $config['uploads_path'].$prefix, basename($file['location']), basename($file['location']), true, $file['encoded']);
            insertImport($package_id, 'file', basename($file['location']), '', '', $file['location']);
        }

        // update module settings
        foreach ($found_settings as $setting) {
            $mod = CmsModule::GetModuleInstance($setting['modulename']);
            if ($mod && isset($setting['sitepref']) && is_array($setting['sitepref'])) {
                if (isset($setting['sitepref'][0])) {
                    foreach ($setting['sitepref'] as $sitepref) {
                        $pref = str_replace($setting['modulename'] . '_mapi_pref_', '', $sitepref['sitepref_name']);
                        $mod->SetPreference($pref, isset($sitepref['sitepref_value']) ? $sitepref['sitepref_value'] : '');
                    }
                } else {
                        $pref = str_replace($setting['modulename'] . '_mapi_pref_', '', $sitepref['sitepref_name']);
                        $mod->SetPreference($pref, isset($sitepref['sitepref_value']) ? $sitepref['sitepref_value'] : '');                    
                }
            }
        }

        $this->smarty->assign('help_section', $package_info['notes']);
        $this->smarty->assign('submit', '');

        break;
}


$this->smarty->assign('step', $step);
$this->smarty->assign('nextstep', $this->CreateInputHidden($id, 'step', ($step + 1)));
$this->smarty->assign('startform', $this->CreateFormStart($id, 'import', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('continue_import')));

$this->smarty->assign('mod', $this);
echo $this->ProcessTemplate('import.tpl');
?>