<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown
#
# This function will create tables and generate records needed for the module servicedesk
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Initialize the Database
$db = cmsms()->GetDb();

// MySQL-specific, but ignored by other database
$taboptarray = array('mysql' => 'TYPE=MyISAM');
$dict = NewDataDictionary($db);

// Table schema Categories
$flds = "
	cat_id I KEY,
	code C(10),
	description C(80)
	";

// Create it. 
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_servicedesk_categories',
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// Create a sequence
$db->CreateSequence(cms_db_prefix().'module_servicedesk_categories_seq');
// Insert a miscellaneous category
$cat_id = $db->GenID(cms_db_prefix()."module_servicedesk_categories_seq");
$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_categories (cat_id, code, description)
	VALUES (?,?,?)';
$db->Execute($query, array($cat_id, 'Other', 'Other'));

// Table schema Statusses
$flds = "
	stat_id I KEY,
	status C(2),
	description C(80),
	sendmail I2,
	mailsubject C(50),
	mailbody X,
	htmlmail I2
	";

// Create it. 
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_servicedesk_statusses',
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// Create a sequence
$db->CreateSequence(cms_db_prefix().'module_servicedesk_statusses_seq');
// Create base statusses
$stat_id = $db->GenID(cms_db_prefix()."module_servicedesk_statusses_seq");
$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_statusses (stat_id, status, description, 
	sendmail, mailsubject, mailbody)
	VALUES (?,?,?,?,?,?)';
$db->Execute($query, array($stat_id, 'OP', 'Opened', 0, '', ''));
$stat_id = $db->GenID(cms_db_prefix()."module_servicedesk_statusses_seq");
$mailsubject = $this->Lang('statussettoclosedmailsubject');
$mailbody = '';
$fn = cms_join_path(dirname(__FILE__),'templates','orig_incident2closedmail_template.tpl');
if( file_exists( $fn ) )
{
	$mailbody = @file_get_contents($fn);
}

$db->Execute($query, array($stat_id, 'CL', 'Closed', 0, $mailsubject, $mailbody));

// Table schema Incidents
// For the priority score see: http://www.itsmsolutions.com/newsletters/DITYvol3iss1.htm
$flds = "
	incident_id I KEY,
	description C(80),
	product C(20),
	cat_id I,
	requestor_id I,
	status C(2),
	sendmail I2,
	requestor_ref C(25),
	detail_description X,
	owner_id I,
	priority C(1),
	priorityseq I,   
	create_date " . CMS_ADODB_DT . ",
	modified_date " . CMS_ADODB_DT . ",
	start_date " . CMS_ADODB_DT . ",
	end_date " . CMS_ADODB_DT . "
	";

// Create it. 
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_servicedesk_incidents',
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// Create a sequence
$db->CreateSequence(cms_db_prefix().'module_servicedesk_incidents_seq');

// Table schema Incident Note
$flds = "
	note_id I KEY,
	incident_id I,
	user_id I,
	note X,
	note_date " . CMS_ADODB_DT . "
	";

// Create it. 
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_servicedesk_notes',
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// Create a sequence
$db->CreateSequence(cms_db_prefix().'module_servicedesk_notes_seq');

// Table schema attributes
$flds = "
	attr_id I KEY AUTO NOT NULL,
	name C(255) NOT NULL,
	prompt C(255),
	type C(20),
	max_length I,
	options X,
	sort_order I,
	public I1,
	showinsearch I1
	";

// Create it. 
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_servicedesk_attributes',
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// Create project_to_attributes table
$flds = "
	incident_id I KEY,
	attr_id I KEY,
	value X
		";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_servicedesk_incident_attributes', 
		$flds, $taboptarray );
$dict->ExecuteSQLArray( $sqlarray );

// Permissions
$this->CreatePermission('Use ServiceDesk','Use ServiceDesk');
$this->CreatePermission('ModifyServiceDeskAttr','Service Desk: Modify Attributes');

// Setup form incident entry template
$fn = cms_join_path(dirname(__FILE__),'templates','orig_form_template.tpl');
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetPreference('default_form_template_contents',$template);
	$this->SetTemplate('form_FrontEndEntry',$template);
	$this->SetPreference('current_form_template','form_FrontEndEntry');
}

// Setup form front end incident entry with attributes template
$fn = cms_join_path(dirname(__FILE__),'templates','orig_feentryattr_template.tpl');
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetPreference('default_form_template_contents',$template);
	$this->SetTemplate('form_FrontEndEntry',$template);
	$this->SetPreference('current_feentryattr_template','form_FrontEndEntryAttributes');
}

// Setup form incident listing template
$fn = cms_join_path(dirname(__FILE__),'templates','orig_feinclist_template.tpl');
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetPreference('default_feinclist_template_contents',$template);
	$this->SetTemplate('form_FrontEndList',$template);
	$this->SetPreference('current_feinclist_template','form_FrontEndList');
}

// Setup received incident mail template
$fn = cms_join_path(dirname(__FILE__),'templates','orig_rcvdincidentmail_template.tpl');
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetPreference('default_receiveincidentmailtemplate',$template);
	$this->SetTemplate('receiveincidentmailtemplate',$template);
	$this->SetPreference('receiveincidentmailtemplate',$template);
}

// Setup new incident mail template
$fn = cms_join_path(dirname(__FILE__),'templates','orig_newincidentmail_template.tpl');
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetPreference('default_newincidentmail2admintemplate',$template);
	$this->SetTemplate('newincidentmail2admintemplate',$template);
	$this->SetPreference('newincidentmail2admintemplate',$template);
}

// Preferences
$this->SetPreference('defaultstatus', 'OP');
$this->SetPreference('fesubmit_redirect','home');
$this->SetPreference('newincidentmail2adminsubject', $this->Lang('subjectnewincident2admin'));
$this->SetPreference('receivedincidentmailsubject', $this->Lang('receivedincidentmailsubject'));
$this->SetPreference('enableeditor', 1);
$this->SetPreference('allowchangerequestor', 1);
$this->SetPreference('enablemailwysiwyg', 1);
$this->SetPreference('allowedfiletypes', 'txt,pdf,doc');
$this->SetPreference('allowedimagetypes', 'png,jpg,jpeg,gif');
	
// Setup events
$this->CreateEvent('IncidentAdded');
$this->CreateEvent('IncidentEdited');
$this->CreateEvent('IncidentDeleted');

// Write audit trail to the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));
        
?>