<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2009 by Duketown <duketown@mantox.nl>
#
# This function shows the incidents on the front end
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$detailpage = '';
if (isset($params['detailpage'])) {
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($params['detailpage']);
	if (isset($node)) {
		$content =& $node->GetContent();	
		if (isset($content)) {
			$detailpage = $content->Id();
		}
	} else {
		$node =& $manager->sureGetNodeById($params['detailpage']);
		if (isset($node)) {
			$detailpage = $params['detailpage'];
		}
	}
}

// Set the id of the current user
$currentuser = 0;
if (isset($params['currentuser'])) {
	$currentuser = $params['currentuser'];
}
if (!$currentuser > 0) {
	exit;
}

$whereclauseavail = false;
$entryarray = array();
$query1 = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_incidents';
if (isset($params['status']) && $params['status'] != '') {
	$whereclause .= ' WHERE status = '. $params['status'];
	$whereclauseavail = true;
}
if (isset($params['statusnot']) && $params['statusnot'] != '') {
	if (!$whereclauseavail) {
		$whereclause .= ' WHERE ';
		$whereclauseavail = true;
	} else {
		$whereclause .= ' and ';
	}
	$whereclause .= ' status != '. $params['statusnot'];
}

$sequence .= ' ORDER BY create_date';

$query2 = 'SELECT count(*) as count FROM ' . cms_db_prefix() . 'module_servicedesk_incidents';

#			WHERE user_id= ' . $currentuser . '';

$query1 .= $whereclause;
$query1 .= $sequence;
$query2 .= $whereclause;
$query2 .= $sequence;

// Set the page hyperlinks if needed
$pagelimit = 100000;

if (isset($params['pagelimit'])) {
	$pagelimit = intval($params['pagelimit']);
}
		
// Get the number of rows (so we can determine the numer of pages)
$pagecount = -1;
$startelement = 0;
$pagenumber = 1;
// Get the total number of items that match the query
// and determine a number of pages
$row2 = $db->GetRow($query2);
$count = intval($row2['count']);
if (isset( $params['start'] ) )
{
	$count -= (int)$params['start'];
}
$pagecount = (int)($count / $pagelimit);
if ( ($count % $pagelimit) != 0 ) $pagecount++;

if (isset( $params['pagenumber'] ) && $params['pagenumber'] != '' )
{
	// If given a page number, determine a start element
	$pagenumber = (int)$params['pagenumber'];
	$startelement = ($pagenumber-1) * $pagelimit;
}
if (isset( $params['start'] ) )
{
	// Given a start element, determine a page number
	$startelement = $startelement + (int)$params['start'];
}
if ($startelement == $pagelimit) {
	// This happens when there are less results then one page. Reset to starting position.
	#$startelement = 0;
}
// Assign some pagination variables to smarty
if ( $pagenumber == 1 ) {
	$smarty->assign('prevpage',$this->Lang('prevpage'));
	$smarty->assign('firstpage',$this->Lang('firstpage'));
} else {
	$params['pagenumber'] = $pagenumber-1;
	$smarty->assign('prevpage', $this->CreateFrontendLink($id, $returnid, 'default', $this->Lang('prevpage'), $params));
	$params['pagenumber'] = 1;
	$smarty->assign('firstpage', $this->CreateFrontendLink($id, $returnid, 'default', $this->Lang('firstpage'), $params));
}
   
if ( $pagenumber >= $pagecount ) {
	$smarty->assign('nextpage',$this->Lang('nextpage'));
	$smarty->assign('lastpage',$this->Lang('lastpage'));
} else {
	$params['pagenumber'] = $pagenumber+1;
	$smarty->assign('nextpage', $this->CreateFrontendLink($id, $returnid, 'default', $this->Lang('nextpage'), $params));
	$params['pagenumber'] = $pagecount;
	$smarty->assign('lastpage', $this->CreateFrontendLink($id, $returnid, 'default', $this->Lang('lastpage'), $params));
}

$smarty->assign('pagenumber', $pagenumber);
$smarty->assign('pagecount', $pagecount);
$smarty->assign('oftext', $this->Lang('prompt_of'));
$smarty->assign('pagetext', $this->Lang('prompt_page'));

// Build the limit and starting point: $query1 .= " LIMIT $pagelimit OFFSET $startelement";
$dbresult = '';
if ( $pagelimit < 100000 || $startelement > 0 )
{
	$dbresult = $db->SelectLimit( $query1, $pagelimit,$startelement);
}
else
{
	$dbresult =& $db->Execute($query1);
}

// Now that the query result is available, prepare the rows
while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->description = $row['description'];
	
	$moretext = isset($params['moretext'])?$params['moretext']:$this->Lang('more');
	$sendtodetail = array('incident_id'=>$row['incident_id']);
	if (isset($params['detailpage']))
	{
		$sendtodetail['origid'] = $returnid;
	}
	if (isset($params['detailtemplate']))
	{
		$sendtodetail['detailtemplate'] = $params['detailtemplate'];
	}
		
	$prettyurl = 'servicedesk/'.$row['incident_id'].'/'.($detailpage!=''?$detailpage:$returnid);
	if (isset($sendtodetail['detailtemplate']))
	{
		$prettyurl .= '/d,' . $sendtodetail['detailtemplate'];
	}
		
	$sendtoprint = array('incident_id' => $row['incident_id'], 'showtemplate' => 'false');
	if (isset($params['printtemplate']))
	{
		$sendtoprint['printtemplate'] = $params['printtemplate'];
		$sendtodetail['printtemplate'] = $params['printtemplate'];
	}

	if (isset($params['lang']))
	{
		$sendtodetail['lang'] = $params['lang'];
		$sendtoprint['lang'] = $params['lang'];
	}

	#CreateLink($id, $action, $returnid='', $contents='', $params=array(), $warn_message='', $onlyhref=false, $inline=false, $addttext='', $targetcontentonly=false, $prettyurl='')
	$onerow->link = $this->CreateLink($id, 'displaydetail', $detailpage!=''?$detailpage:$returnid, '', $sendtodetail,'', true, false, '', true, $prettyurl);
	$onerow->incidentlink = $this->CreateLink($id, 'displaydetail', $detailpage!=''?$detailpage:$returnid, $row['description'], $sendtodetail, '', false, false, '', true, $prettyurl);
	$onerow->morelink = $this->CreateLink($id, 'displaydetail', $detailpage!=''?$detailpage:$returnid, $moretext, $sendtodetail, '', false, false, '', true, $prettyurl);
	$onerow->moreurl = $this->CreateLink($id, 'displaydetail', $detailpage!=''?$detailpage:$returnid, $moretext, $sendtodetail, '', true, false, '', true, $prettyurl);
	$onerow->printlink = $this->CreateLink($id, 'print', $returnid, $this->Lang('print'), $sendtoprint);
	$onerow->printurl = $this->CreateLink($id, 'print', $returnid, $this->Lang('print'), $sendtoprint, '', true);

	$entryarray[]= $onerow;
}

$smarty->assign('itemcount', count($entryarray));
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('noincidentsfound', $this->Lang('noincidentsfound'));
	
foreach( $params as $key => $value )
{
	if( $key == 'mact' || $key == 'action' ) continue;
	$smarty->assign('param_'.$key,$value);
}

// Display template
echo "<!-- Displaying Service Desk Module (by Duketown) Incidents -->\n";

$template = $this->GetPreference('current_feinclist_template');
if (isset($params['formtemplate']))
  {
    $template = 'form_'.$params['formtemplate'];
  }
echo $this->ProcessTemplateFromDatabase($template);
?>