<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports upgrading module servicedesk to the next version
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$current_version = $oldversion;
switch($current_version)
{
	case '0.1.0':
		$db = cmsms()->GetDb();
		$dict = NewDataDictionary($db);

		$this->SetPreference('allowchangerequestor', true);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_servicedesk_statusses', 'htmlmail L' );
		$dict->ExecuteSQLArray($sqlarray);
  		$current_version = '0.2';

	case '0.2':

  		$current_version = '0.3';
	case '0.3':

  		$current_version = '0.4';
	case '0.4':

  		$current_version = '0.5';
	case '0.5':
		$db = cmsms()->GetDb();
		$dict = NewDataDictionary($db);
		// Create new tables for use with the Gold extension
		// Table schema attributes
		$flds = "
			attr_id I KEY AUTO NOT NULL,
			name C(255) NOT NULL,
			prompt C(255),
			type C(20),
			max_length I,
			options X,
			sort_order I,
			public I1,
			showinsearch I1
			";
		
		// Create it. 
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_servicedesk_attributes',
				$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		// Create project_to_attributes table
		$flds = "
			incident_id I KEY,
			attr_id I KEY,
			value X
				";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_servicedesk_incident_attributes', 
				$flds, $taboptarray );
		$dict->ExecuteSQLArray( $sqlarray );

		$this->CreatePermission('ModifyServiceDeskAttr','Service Desk: Modify Attributes');

		// Setup form front end incident entry with attributes template
		$fn = cms_join_path(dirname(__FILE__),'templates','orig_feentryattr_template.tpl');
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetPreference('default_form_template_contents',$template);
			$this->SetTemplate('form_FrontEndEntry',$template);
			$this->SetPreference('current_feentryattr_template','form_FrontEndEntryAttributes');
		}
		// Prepare some defaults for the usable file extensions for uploads
		$this->SetPreference('allowedfiletypes', 'txt,pdf,doc');
		$this->SetPreference('allowedimagetypes', 'png,jpg,jpeg,gif');


  		$current_version = '0.6';
	case '0.6':

  		$current_version = '0.7';
	case '0.7':
		break;
}

// Generate an audit trail in the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded',$this->GetVersion()));

?>