<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports editing a status
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$detailpage = '';
if (isset($params['detailpage']))
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }


if (!$this->CheckPermission('Use ServiceDesk'))
  {
	echo $this->ShowErrors($this->Lang('needpermission', array('Use ServiceDesk')));
    return;
  }

if (isset($params['cancel']))
  {
	$params = array('active_tab' => 'statusses');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
  }

$stat_id = '';
if (isset($params['stat_id'])) {
	$stat_id = $params['stat_id'];
}

$sendmail = 0;
if (isset($params['sendmail'])) {
	$sendmail = $params['sendmail'];
}

$mailsubject = '';
if (isset($params['mailsubject'])) {
	$mailsubject = $params['mailsubject'];
}

$mailbody = '';
if (isset($params['mailbody'])) {
	$mailbody = $params['mailbody'];
}
$htmlmail = 0;
if (isset($params['htmlmail'])) {
	$htmlmail = $params['htmlmail'];
}

$origdesc = 0;
if (isset($params['origdesc'])) {
	$origdesc = $params['origdesc'];
}

$description = '';
if (isset($params['description']))
  {
    $description = $params['description'];
    if ($description != '')
      {
		$query = 'UPDATE '.cms_db_prefix().'module_servicedesk_statusses SET description = ?, 
			sendmail = ?, mailsubject = ?, mailbody = ?, htmlmail = ?
			WHERE stat_id = ?';
		$db->Execute($query, array($description, $sendmail, $mailsubject, 
			$mailbody, $htmlmail,  
			$stat_id));

		#@$this->SendEvent('StatusEdited', array('stat_id' => $stat_id, 'description' => $description, 'origdesc' => $origdesc));

		$params = array('tab_message'=> 'statusupdated', 'active_tab' => 'statusses');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
      }
    else
      {
		echo $this->ShowErrors($this->Lang('nostatdescgiven'));
      }
  }
 else
   {
     $query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_statusses WHERE stat_id = ?';
     $row = $db->GetRow($query, array($stat_id));

     if ($row)
       {
		$status = $row['status'];
		$description = $row['description'];
		$sendmail = $row['sendmail'];
		$mailsubject = $row['mailsubject'];
		$mailbody = $row['mailbody'];
		$htmlmail = $row['htmlmail'];
       }
   }

// Prepare a list of possible values for the user to use in the template
$subjectparms = array();
$subjectparms = $this->GetPossibleMailVars('statussubject');
$mailparms = array();
$mailparms = $this->GetPossibleMailVars('statusbody');

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'editstatus', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('statustext', $this->Lang('status'));
$this->smarty->assign('statusinput', $status);
$this->smarty->assign('descriptiontext', $this->Lang('statusdescription'));
$this->smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 40, 40));
$this->smarty->assign('sendmailtext', $this->Lang('sendmail'));
$this->smarty->assign('sendmailinput', $this->CreateInputCheckbox($id, 'sendmail', true, $sendmail));
// Make it possible to prepare mail settings to send mail to requestor once status changed
$this->smarty->assign('fieldset_mailtext', $this->Lang('title_fieldset_mail'));
$this->smarty->assign('subjecttext', $this->Lang('title_mail_subject'));
$this->smarty->assign('subjectinput', $this->CreateInputText($id, 'mailsubject', $mailsubject, 50, 50));
$this->smarty->assign('mail_templatetext', $this->Lang('title_mail_template'));
$this->smarty->assign('mail_templateinput',$this->CreateTextArea($this->GetPreference('enablemailwysiwyg', true), $id, $mailbody,'mailbody'));
$this->smarty->assign('htmlmailtext', $this->Lang('title_htmlmail'));
$this->smarty->assign('htmlmailinput', $this->CreateInputCheckbox($id, 'htmlmail', true, $htmlmail));

$this->smarty->assign('title_parms_to_use', $this->Lang('title_parms_to_use'));
$this->smarty->assign('parametersshow', $this->Lang('parametersshow'));
$this->smarty->assign('parametershide', $this->Lang('parametershide'));
$this->smarty->assign('subjectnames', $subjectparms);
$this->smarty->assign('names', $mailparms);

$this->smarty->assign('hidden',
	$this->CreateInputHidden($id, 'stat_id', $stat_id).
	$this->CreateInputHidden($id, 'origdesc', $description));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editstatus.tpl');
?>
