<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports front end calls for the module servicedesk
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (isset($params['display'])) {
	$display = $params['display'];
}
else {
	$display = 'incidents';
}

// Set the id of the current user if custom content is used
$currentuser = $this->smarty->get_template_vars('customcontent_loggedin');
// Set user id if just FEU is used
if (!$currentuser > 0) {
	$currentuser = $this->smarty->get_template_vars('userid');
}
if (!$currentuser > 0) {
 		echo $this->Lang('notloggedin');
 		return;
} else {
	$params['currentuser'] = $currentuser;
}

switch($display) {
	case 'incdetails':
		break;
	case 'incidents':
		break;
}

$founddisplay = false;
// Check the version that is in use
$servicedeskversion = $this->GetPreference('servicedeskversion');
switch ($servicedeskversion)
{
	case 'gold':
	case 'silver':
		$ap = cms_join_path(dirname(__FILE__),'silver','silver.display'.$display.'.php');
		if( file_exists( $ap ) )
		{
			include_once $ap;
			$founddisplay = true;
		}
	case 'free':
		$ap = cms_join_path(dirname(__FILE__),'action.display'.$display.'.php');
		if( file_exists( $ap ) )
		{
			include_once $ap;
			$founddisplay = true;
		}
		//require(dirname(__FILE__).'/action.display'.$display.'.php');
	default:
		break;
}

if (!$founddisplay) {
	echo $this->Lang('unknown_display', $display);
	return;
}

?>