<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFeedMaker - A flexible tool for the creation and management
#         of RSS Feeds
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$db =& $this->GetDb();

$dict = NewDataDictionary($db);
$taboptarray = array('mysql' => 'TYPE=MyISAM');
$flds = "
   id I KEY AUTO,
   name C(255),
   extension C(20),
   title C(255),
   link C(255),
   description X,
   pageid I,
   copyright C(255),
   managing_editor C(255),
   ttl I,
   image C(255),
   template X,
   create_date " . CMS_ADODB_DT .",
   modified_date " . CMS_ADODB_DT . "
";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_cgfeedmaker", 
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
   id   I KEY AUTO,
   name C(255)
";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_cgfeedmaker_categories", 
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
   feed_id     I KEY,
   category_id I KEY
";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_cgfeedmaker_feed_categories", 
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);


// Setup a basic category
$query = 'INSERT INTO '.cms_db_prefix().'module_cgfeedmaker_categories 
            (name) VALUES (?)';
$db->Execute($query,array('Sample RSS Feeds'));
$cat_id = $db->Insert_ID();

// Setup some basic feeds.
$dir = dirname(__FILE__).'/templates';
if( $dh = opendir($dir) )
  {
    $config =& $gCms->GetConfig();
    $contentops =& $gCms->GetContentOperations();

    $link = $config['root_url'];
    $pageid = $contentops->GetDefaultContent();
    $ttl = 0;
    $now = $db->DbTimeStamp(time());

    $query = 'INSERT INTO '.cms_db_prefix()."module_cgfeedmaker
                (name, title, link, description, pageid, ttl, template,
                 create_date, modified_date)
              VALUES (?,?,?,?,?,?,?,$now,$now)";
    $query2 = 'INSERT INTO '.cms_db_prefix().'module_feed_categories
                 (feed_id, category_id) VALUES (?,?)';
    while( false !== ( $file = readdir( $dh ) ) )
      {
	if( $file == '.' || $file == '..' ) continue;
	if( !preg_match('/^orig_feed_template/',$file) ) continue;
	
	$template = @file_get_contents("$dir/$file");
	if( empty($template) ) continue;
	$ext = strrchr($file,'.');
	$n = strlen('orig_feed_template');
	$name = substr($file,$n,strlen($file)-strlen($ext)-$n);
	if( empty($name) ) $name = 'news';
	while( startswith($name,'_') ) $name = substr($name,1);
	$name = str_replace('_',' ',$name);
	$feedname = 'Sample '.ucwords($name).' feed';
	$feeddesc = sprintf('Sample RSS Feed for the %s module',ucwords($name));
	$db->Execute($query,array($name,$feedname,$link,$feeddesc,$pageid,$ttl,$template));
	$feed_id = $db->Insert_ID();

	$db->Execute($query2,array($feed_id,$cat_id));
      }
    closedir($dh);
  }

# Set Permission
$this->CreatePermission('Manage RSS Feeds', 'Manage RSS Feeds');

# Preferences


#
# EOF
#
?>
