<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFeedMaker - A flexible tool for the creation and management
#         of RSS Feeds
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

#
# Output one or more auto discovery links
# 

$names = array();
if( isset($params['category']) )
{
  //
  // comma separated list of category names
  //
  $tmp = explode(',',$params['category']);
  for( $i = 0; $i < count($tmp); $i++ )
    {
      $tmp[$i] = "'".$tmp[$i]."'";
    }
  $str = implode(',',$tmp);
  $query = 'SELECT id FROM '.cms_db_prefix()."module_cgfeedmaker_categories WHERE name in ($str)";
  $tmp = $db->GetArray($query);
  $tmp2 = array();
  foreach( $tmp as $one )
    {
      $tmp2[] = $one['id'];
    }
  $tmp = implode(',',$tmp2);
  $query = 'SELECT DISTINCT name,title 
            FROM '.cms_db_prefix().'module_cgfeedmaker A 
            LEFT OUTER JOIN '.cms_db_prefix().'module_cgfeedmaker_feed_categories B
            ON A.id = B.feed_id
            WHERE B.category_id IN ('.$tmp.')';
  $names = $db->GetArray($query);
}
else if( isset($params['feed']) )
{
  //
  // comma separated list of feed names
  //
  $tmp = explode(',',$params['feed']);
  for( $i = 0; $i < count($tmp); $i++ )
    {
      $tmp[$i] = "'".$tmp[$i]."'";
    }
  $tmp3 = implode(',',$tmp);
  $query = 'SELECT name,title,extension FROM '.cms_db_prefix()."module_cgfeedmaker WHERE name in ($tmp3)";
  $names = $db->GetArray($query);
}
else
{
  //
  // All feeds
  //
  $query = 'SELECT name,title,extension FROM '.cms_db_prefix().'module_cgfeedmaker';
  $names = $db->GetArray($query);
}

$fmt = '<link rel="alternate" type="application/rss+xml" title="%s" href="%s" />'."\n";
$output = '';
if( is_array($names) )
  {
    foreach( $names as $one )
      {
	$url = $this->CreateFeedURL($id,$one['name'],$one['extension']);
	$is_pretty = (strpos($url,'/feeds') !== FALSE);
// 	if( !$is_pretty )
// 	  {
// 	    $url = str_replace('amp;','',$url);
// 	  }
	$output .= sprintf($fmt,$one['title'],$url);
      }
  }

echo $output;

#
# EOF
#
?>