<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFeedMaker - A flexible tool for the creation and management
#         of RSS Feeds
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
$this->SetCurrentTab('categories');
if( !$this->CheckPermission('Manage RSS Feeds') )
{
  echo $this->ShowErrors($this->Lang('error_nopermission'));
  return;
}


// Get input parameters
$name = '';
$catid = '';
if( isset($params['catid']) )
{
  // we're editing.
  $catid = (int)$params['catid'];
  $query = 'SELECT name FROM '.cms_db_prefix().'module_cgfeedmaker_categories WHERE id = ?';
  $name = $db->GetOne($query,array($catid));
}
if( isset($params['input_categoryname']) )
{
  $name = trim($params['input_categoryname']);
}


if( isset($params['cancel']) )
{
  $this->RedirectToTab($id);
}
else if( isset($params['submit']))
{
  //
  // Handle submit.
  //

  //
  // Data validation
  //

  // check for empty name
  $error = '';
  if( empty($name) )
    {
      $error = $this->Lang('error_nocatname');
    }
  else
    {
      if( empty($catid) )
	{
	  //
	  // Adding a new record
	  //

	  // Check for an existing name
	  $query = 'SELECT id FROM '.cms_db_prefix().'module_cgfeedmaker_categories
                 WHERE name = ?';
	  $tmp = $db->GetOne($query,array($name));
	  if( $tmp )
	    {
	      $error = $this->Lang('error_nameexists');
	    }
	  else
	    {
	      // ready to add
	      $query = 'INSERT INTO '.cms_db_prefix().'module_cgfeedmaker_categories (name) VALUES (?)';
	      $db->Execute( $query, array($name) );
	      
	      // redirect
	      $this->RedirectToTab($id);
	    }
	}
      else
	{
	  //
	  // Editing an existing record
	  //

	  // Check for an existing name
	  $query = 'SELECT id FROM '.cms_db_prefix().'module_cgfeedmaker_categories
                 WHERE name = ? AND id != ?';
	  $tmp = $db->GetOne($query,array($name,$catid));
	  if( $tmp )
	    {
	      $error = $this->Lang('error_nameexists');
	    }
	  else
	    {
	      // ready to update
	      $query = 'UPDATE '.cms_db_prefix().'module_cgfeedmaker_categories SET name = ? WHERE id = ?';
	      $db->Execute( $query, array($name,$catid) );
	      
	      // redirect
	      $this->RedirectToTab($id);
	    }
	}
    }  
}

if( !empty($error) )
{
  echo $this->ShowErrors($error);
}

$smarty->assign('formstart',$this->CGCreateFormStart($id,'addcategory',$returnid,
						   array('catid'=>$catid)));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('input_categoryname',
		$this->CreateInputText($id,'input_categoryname',$name,80,255));
$smarty->assign('submit',
		$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('cancel',
		$this->CreateInputSubmit($id,'cancel',$this->Lang('cancel')));

echo $this->ProcessTemplate('addcategory.tpl');
#
# EOF
#
?>