<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFeedMaker - A flexible tool for the creation and management
#         of RSS Feeds
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE


$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
			      'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);

class CGFeedMaker extends CGExtensions
{
  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return 'CGFeedMaker';
  }

  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }

	
  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '1.0.15';
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'calguy1000';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'calguy1000@cmsmadesimple.org';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    return @file_get_contents('changelog.html');
  }
  
  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'extensions';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Manage RSS Feeds');
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('CGExtensions'=>'1.20');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.9.4.3";
  }
	
	
  /*---------------------------------------------------------
   SetParameters()
   ---------------------------------------------------------*/
  function SetParameters()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();
    $this->RegisterRoute('/[Ff]eeds\/(?P<feed>.*?)$/', array('action'=>'default','showtemplate'=>'false'));

    $this->SetParameterType('category',CLEAN_STRING);
    $this->CreateParameter('category','',$this->Lang('param_category'));

    $this->SetParameterType('feed',CLEAN_STRING);
    $this->CreateParameter('feed','',$this->Lang('param_feed'));

    $this->SetParameterType('image',CLEAN_STRING);
    $this->CreateParameter('image','',$this->Lang('param_image'));

    $this->SetParameterType('imageonly',CLEAN_INT);
    $this->CreateParameter('imageonly','',$this->Lang('param_imageonly'));

    $this->SetParameterType('imageclass',CLEAN_STRING);
    $this->CreateParameter('imageclass','',$this->Lang('param_imageclass'));

    $this->SetParameterType('linkclass',CLEAN_STRING);
    $this->CreateParameter('linkclass','',$this->Lang('param_linkclass'));

    $this->SetParameterType('text',CLEAN_STRING);
    $this->CreateParameter('text','',$this->Lang('param_text'));

    $this->CreateParameter('action','',$this->Lang('param_action'));

    $this->SetParameterType('urlonly',0,$this->Lang('param_urlonly'));
    $this->SetParameterType('urlonly',CLEAN_INT);
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }	


  /*---------------------------------------------------------
   CreateFeedURL()

   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  function CreateFeedURL($id,$feedalias,$ext = '',$pageid='')
  {
    global $gCms;
    $config = $gCms->GetConfig();
    $defext = '';
    if( isset($config['page_extension']) && !empty($config['page_extension']) )
      {
	$defext = $config['page_extension'];
      }

    if( empty($feedalias) ) return;

    if( empty($pageid) )
      {
	// Get the default page id
	$contentops =& $gCms->GetContentOperations();
	$pageid = $contentops->GetDefaultPageID();
      }

    $params = array();
    $params['feed'] = $feedalias;
    $params['showtemplate'] = 'false';
    $prettyurl = "feeds/$feedalias";

    $url = $this->create_url($id,'default',$pageid,$params,false,false,$prettyurl);
    $is_pretty = (strpos($url,'/feeds') !== FALSE);
    if( $is_pretty )
      {
	if( isset($config['url_rewriting']) && $config['url_rewriting'] != 'none' )
	  {
	    if( !empty($config['page_extension']) )
	      {
		// remove the old extension from the URL if not empty
		$url = substr($url,0,strlen($url)-strlen($config['page_extension']));
	      }
	    if( $ext == '' )
	      {
		$ext = $this->GetPreference('feed_extension','rss');
	      }
	    if( !startswith($ext,'.') )
	      {
		$ext = '.'.$ext;
	      }
	    $url .= $ext;
	  }
      }
    else
      {
	$url .= '&showtemplate=false';
      }

    return $url;
  }	


} // class
