<?php
#-------------------------------------------------------------------------
# Module: Custom Global Settings
# Author: Rolf Tjassens, Jos
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/customgs
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

class CustomGS extends CMSModule
{
	function GetName()
	{
		return 'CustomGS';
	}

	function GetFriendlyName()
	{
		return $this->GetPreference('input_custom_modulename');
	}
	
	function GetVersion()
	{
		return '1.2';
	}
	
	function MinimumCMSVersion()
	{
		return '1.10';
	}
	
	function GetHelp()
	{
		return file_get_contents(dirname(__FILE__).'/help_text.inc');
	}
	
	function GetAuthor()
	{
		return 'Rolf Tjassens';
	}
	
	function GetAuthorEmail()
	{
		return 'rolf at cmsmadesimple dot org';
	}
	
	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.inc');
	}
	
	function IsPluginModule()
	{
		return true;
	}
	
	function HasAdmin()
	{
		return true;
	}
	
	function GetAdminSection()
	{
		return $this->GetPreference('admin_section', 'extensions');
	}
	
	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}

	function VisibleToAdminUser() 
	{
		return $this->CheckPermission('Custom Global Settings - Manage' || 'Custom Global Settings - Use');
	}

	function GetDependencies()
	{
		return array();
	}
	
	function SetParameters()
	{
		$this->RegisterModulePlugin();
	  $this->RestrictUnknownParams();
		$this->CreateParameter('showvars','1','Set this parameter to show all available variables and their values. For testing purposes only.');
	  $this->SetParameterType('showvars',CLEAN_STRING);
	}
	
  function GetEventDescription($eventname)
  {
    return $this->Lang('event_info_'.$eventname );
  }

  function GetEventHelp($eventname)
  {
    return $this->Lang('event_help_'.$eventname );
  }

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('uninstall_confirm');
	}
	
	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function GetHeaderHTML()
	{
		$tmpl = <<<EOT
<link rel="stylesheet" type="text/css" href="../modules/CustomGS/lib/jquery/jquery-ui.smoothness.css" media="screen" /> <!-- smoothness/jquery-ui-1.8.12.custom.css -->
{literal}
<style type="text/css">
	.cms_label { margin-right:12px; }
	/* css for timepicker */
	.ui-timepicker-div .ui-widget-header { margin-bottom: 8px; }
	.ui-timepicker-div dl { text-align: left; }
	.ui-timepicker-div dl dt { height: 25px; margin-bottom: -25px; }
	.ui-timepicker-div dl dd { margin: 0 10px 10px 65px; }
	.ui-timepicker-div td { font-size: 90%; }
	.ui-tpicker-grid-label { background: none; border: none; margin: 0; padding: 0; }
</style>
{/literal}
EOT;
		return $this->ProcessTemplateFromData($tmpl);
	}

	/**
	* Method to get parameters of a field by name or by fieldid
	*
	* @final
	* @access public
	* @return array()
	*/
	function GetField($field)
	{
		$db = cmsms()->GetDB();
		$query = "SELECT * FROM ".cms_db_prefix()."module_customgs WHERE fieldid=? OR name=?";
		$result = $db->Execute($query, array($field, $field));
		if( $result && $result->RecordCount() > 0 )
		{
			$row = $result->FetchRow();
		}
		else
		{
			$row = FALSE;
		}
		return $row;
	}

	/**
	* Method to get all settings
	*
	* @final
	* @access public
	* @return array()
	*/
	function GetSettings()
	{
		$fields = array();

		$db = cmsms()->GetDB();
		$query = "SELECT * FROM " . cms_db_prefix() . "module_customgs";
		$result = $db->Execute($query);
		if ( $result && $result->RecordCount() > 0 )
		{
			while ( $row=$result->FetchRow() )
			{
				$alias = str_replace('__', '_', str_replace('-', '_', munge_string_to_url($row['name'])));
				if ( ($row['type'] == 'textarea' || $row['type'] == 'wysiwyg') && $row['properties'] )
				{
					$fields[$alias] = $this->ProcessTemplateFromData($row['value']);
				}
				else
				{
					$fields[$alias] = $row['value'];
				}
				$fields[$row['fieldid']] = $fields[$alias];
			}
		}
		return $fields;
	}

	/**
	* Method to clear the site cache
	*
	* @final
	* @access private
	* @return void
	*/
	function ClearCache()
	{
		$gCms = cmsms();
		$contentops = $gCms->GetContentOperations();
		$contentops->ClearCache();
	}

}
?>