<?php
final class ac_admin_ops
{
	private $_variables = array(
		'display_settings' => array(),
		'tab_ids'          => array(),
		'page_tabs'        => array(),
		'block_tabs'       => array(),
		'block_groups'     => array(),
		'block_types'      => array(),
		'admin_groups'     => null,
		'all_admin_users'  => null,
		'all_admin_groups' => null 
	);
	
	private static $_instance;
	
	private function __construct() {}
	private function __clone() {}
	
	public static function &get_instance()
	{
		if(!self::$_instance)
		{
			self::$_instance = new self;
		}
		return self::$_instance;
	}
	
	public function GetVariable($varname)
	{
		return isset($this->_variables[$varname]) ? $this->_variables[$varname] : false;
	}
	
	public function SetVariable($varname, $value)
	{
		$this->_variables[$varname] = $value;
	}
	
	public function GetPages()
	{
		$db =& cmsms()->GetDb();
		$query = "SELECT C.active, C.type, C.content_id, C.parent_id, C.hierarchy, C.menu_text, CP.content FROM " . cms_db_prefix() . "content C
			LEFT JOIN " . cms_db_prefix() . "content_props CP ON CP.content_id = C.content_id AND CP.prop_name = ?
			ORDER BY hierarchy";
		$dbresult = $db->Execute($query, array('redirect_page'));
		if(!$pages = $dbresult->GetArray())
			return array();
		return $pages;
	}
	
	public function CreateRedirectDropdown($id = '', $name = 'redirect_page', $selectedPage = '', $currentPage = '', $add_txt = '')
	{
		$AC         =& cms_utils::get_module('AdvancedContent');
		$pages      = $this->GetPages();
		$dropdown   = '<select class="cms_dropdown" name="'.$id.$name.'" '.($add_txt != '' ? $add_txt: '').(!$AC->GetPreference('use_advanced_pageoptions',0) ? ' disabled="disabled"' : '') .'>';
		$dropdown  .= '<option value=""' . ($selectedPage == ''?' selected="selected"':'') . '>' . $AC->lang('hide_content') . '</option>';
		$dropdown  .= '<option value="-1"' . ($selectedPage == -1?' selected="selected"':'') . '>' . $AC->lang('inherit_from_parent') . '</option>';
		if(count($pages))
		{
			$dropdown  .= '<optgroup label="------------------------------------">';
			$contentops =& cmsms()->GetContentOperations();
			foreach($pages as $page)
			{
				$page['content'] = ($page['content'] < 0 ? ac_utils::InheritParentProp($page['content_id'], $page['parent_id'], 'redirect_page') : $page['content']);
				$disabled = '';
				$indent   = '';
				foreach(explode('.',$page['hierarchy']) as $v)
				{
					$indent .= '&nbsp;&nbsp;&nbsp;';
				}
				# don't redirect to pages with no public access, invalid content type, inactive or same content id
				if($page['active'] != 1 || $page['content']<>0 || $page['content_id'] == $currentPage || ($page['type'] != 'content' && $page['type'] != 'content2'))
				{
					$disabled = ' disabled="disabled"';
				}
				$dropdown .= '<option'. $disabled .' value="' . $page['content_id'] . '" ' .
					($selectedPage == $page['content_id'] && $disabled == ''?'selected="selected"':'') . '>' . $indent . 
					$contentops->CreateFriendlyHierarchyPosition($page['hierarchy']) .
					' - ' . $page['menu_text'] . ($disabled != ''?' (' . $AC->lang('invalid') . ')':'') . '</option>';
			}
			$dropdown  .= '</optgroup>';
		}
		$dropdown .= '</select>';
		return $dropdown;
	}
	
	public function SetVisibility($item_type, $item_id, $content_id, $template_id, $display)
	{
		$AC    =& cms_utils::get_module('AdvancedContent');
		$db    =& cmsms()->GetDb();
		$query =  "SELECT item_display FROM ". cms_db_prefix() . "module_AdvancedContent_".$item_type."display
			WHERE user_id = ? AND item_id = ? AND ";
		
		$q = array();
		$p = array(get_userid(), $item_id);
		
		if($content_id
		&& ($AC->GetPreference($item_type.'_display_settings','content') == 'content'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both2'))
		{
			$q[] = "content_id = ?";
			$p[] = $content_id;
		}
		
		if($template_id > 0
		&& ($AC->GetPreference($item_type.'_display_settings','content') == 'template'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both2'))
		{
			$q[] = "template_id = ?";
			$p[] = $template_id;
		}
		
		if(!count($q)) {
			return;
		}
		
		if($AC->GetPreference($item_type.'_display_settings','content') == 'both1')
		{
			$query .= "(" . implode(" OR ",$q) . ")";
		}
		else if($AC->GetPreference($item_type.'_display_settings','content') == 'both2')
		{
			$query .= "(" . implode(" AND ",$q) . ")";
		}
		else
		{
			$query .= $q[0];
		}
		
		$dbresult = $db->Execute($query, $p);
		if($dbresult && $row = $dbresult->FetchRow()) {
			echo $display;
			array_unshift($p,$display);
			$query = "UPDATE ". cms_db_prefix() . "module_AdvancedContent_".$item_type."display
				SET item_display = ? WHERE user_id = ? AND item_id = ? AND ".implode(' AND ',$q);
			$dbresult = $db->Execute($query, $p);
		}
		else
		{
			$query = "INSERT INTO ". cms_db_prefix() ."module_AdvancedContent_".$item_type."display
				(user_id, content_id, template_id, item_id, item_display) VALUES (?,?,?,?,?)";
			$dbresult = $db->Execute($query, array(get_userid(), $content_id, $template_id, $item_id, $display));
		}
		$this->_variables['display_settings'][$item_type][implode('_',array($content_id,$template_id))][$item_id] = $display;
	}
	
	public function GetVisibility($item_type, $item_id, $content_id, $template_id, $default_value = 1)
	{
		$ids =  array();
		$AC  =& cms_utils::get_module('AdvancedContent');
		
		if($content_id
		&& ($AC->GetPreference($item_type.'_display_settings','content') == 'content'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both2'))
		{
			$ids[] = $content_id;
		}
		
		if($template_id > 0
		&& ($AC->GetPreference($item_type.'_display_settings','content') == 'template'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both2'))
		{
			$ids[] = $template_id;
		}
		
		if(!count($ids))
		{
			return $default_value;
		}
		
		if(!isset($this->_variables['display_settings'][$item_type][implode('_',$ids)]))
		{
			$this->_load_visibilities($item_type, $content_id, $template_id);
		}
		if(!isset($this->_variables['display_settings'][$item_type][implode('_',$ids)][$item_id]))
		{
			$this->_variables['display_settings'][$item_type][implode('_',$ids)][$item_id] = $default_value;
		}
		return $this->_variables['display_settings'][$item_type][implode('_',$ids)][$item_id];
	}
	
	private function _load_visibilities($item_type, $content_id, $template_id)
	{
		$AC =& cms_utils::get_module('AdvancedContent');
		$db =& cmsms()->GetDb();
		$query = "SELECT * FROM ". cms_db_prefix() . "module_AdvancedContent_".$item_type."display
			WHERE user_id = ? AND ";
		
		$q = array();
		$p = array(get_userid());
		
		if($content_id
		&& ($AC->GetPreference($item_type.'_display_settings','content') == 'content'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both2'))
		{
			$q[] = "content_id = ?";
			$p[] = $content_id;
		}
		
		if($template_id > 0
		&& ($AC->GetPreference($item_type.'_display_settings','content') == 'template'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $AC->GetPreference($item_type.'_display_settings','content') == 'both2'))
		{
			$q[] = "template_id = ?";
			$p[] = $template_id;
		}
		
		if(!count($q))
		{
			return;
		}
		
		if($AC->GetPreference($item_type.'_display_settings','content') == 'both1')
		{
			$query .= "(" . implode(" OR ",$q) . ")";
		}
		else if($AC->GetPreference($item_type.'_display_settings','content') == 'both2')
		{
			$query .= "(" . implode(" AND ",$q) . ")";
		}
		else
		{
			$query .= $q[0];
		}
		$dbresult = $db->Execute($query, $p);
		while($dbresult && $row = $dbresult->FetchRow())
		{
			if($AC->GetPreference($item_type.'_display_settings','content') == 'both1'
			|| $AC->GetPreference($item_type.'_display_settings','content') == 'both2')
			{
				$this->_variables['display_settings'][$item_type][$row['content_id'] . '_' . $row['template_id']][$row['item_id']] = $row['item_display'];
			}
			else
			{
				$this->_variables['display_settings'][$item_type][$row[$AC->GetPreference($item_type.'_display_settings','content').'_id']][$row['item_id']] = $row['item_display'];
			}
		}
	}
	
	public function GetMultiInputFull($inputs = array())
	{
		if(!is_array($inputs))
		{
			$inputs = ac_utils::CleanArray(explode(",",$inputs));
		}
		$db    =& cmsms()->GetDb();
		$query = "SELECT MULTI_INPUT.*, TPL_ASSOCS.tpl_name FROM ". cms_db_prefix() . "module_AdvancedContent_multi_inputs MULTI_INPUT
			LEFT OUTER JOIN ".cms_db_prefix()."module_AdvancedContent_multi_input_tpl_assocs TPL_ASSOCS
			ON MULTI_INPUT.input_id = TPL_ASSOCS.input_id";
		
		$q     = array();
		$p     = array();
		$return_array = array();
		foreach($inputs as $input_id)
		{
			$q[$input_id] = "MULTI_INPUT.input_id = ?";
			$p[$input_id] = $input_id;
		}
		if(count($p))
		{
			$query .= " WHERE " . implode(" OR ", $q);
		}
		$dbresult = $db->Execute($query, $p);
		while($dbresult && $row = $dbresult->FetchRow())
		{
			$return_array[$row['input_id']] = $row;
		}
		return $return_array;
	}
	
	public function GetMultiInput($input_id)
	{
		$db       =& cmsms()->GetDb();
		$query    = "SELECT input_fields FROM ". cms_db_prefix() . "module_AdvancedContent_multi_inputs WHERE input_id = ? LIMIT 1";
		$dbresult = $db->Execute($query, array($input_id));
		if($dbresult && $row = $dbresult->FetchRow())
		{
			return $row['input_fields'];
		}
	}
	
	public function GetMultiInputList()
	{
		$db       =& cmsms()->GetDb();
		$query    = "SELECT A.input_id, B.tpl_name FROM ". cms_db_prefix() . "module_AdvancedContent_multi_inputs A
			LEFT JOIN ". cms_db_prefix() . "module_AdvancedContent_multi_input_tpl_assocs B
			ON A.input_id = B.input_id";
		$dbresult = $db->Execute($query);
		$return_array = array();
		while($dbresult && $row = $dbresult->FetchRow())
		{
			$return_array[] = $row;
		}
		return $return_array;
	}
	
	public function AddMultiInput($input_id, $input_fields)
	{
		$db    =& cmsms()->GetDb();
		$query = "SELECT input_id FROM ". cms_db_prefix() . "module_AdvancedContent_multi_inputs
			WHERE input_id = ? LIMIT 1";
		
		$dbresult = $db->Execute($query, array($input_id));
		if($dbresult && $row = $dbresult->FetchRow())
		{
			return false;
		}
		
		$query = "INSERT INTO ". cms_db_prefix() ."module_AdvancedContent_multi_inputs
			(input_id, input_fields) VALUES (?,?)";
		$dbresult = $db->Execute($query, array($input_id, $input_fields));
		return $dbresult;
	}
	
	public function UpdateMultiInput($input_id, $input_fields)
	{
		$db    =& cmsms()->GetDb();
		$query = "UPDATE ". cms_db_prefix() . "module_AdvancedContent_multi_inputs
			SET input_fields = ? WHERE input_id = ? ";
		$dbresult = $db->Execute($query, array($input_fields, $input_id));
		return $dbresult;
	}
	
	public function UpdateTplAssoc($tpl_type, $input_id, $tpl_name)
	{
		$db    =& cmsms()->GetDb();
		$query = "UPDATE ". cms_db_prefix() . "module_AdvancedContent_".$tpl_type."_tpl_assocs
			SET tpl_name = ? WHERE input_id = ? ";
		$dbresult = $db->Execute($query, array($tpl_name, $input_id));
		return $dbresult;
	}
	
	public function AddTplAssoc($tpl_type, $input_id, $tpl_name)
	{
		$db    =& cmsms()->GetDb();
		$query = "INSERT INTO ". cms_db_prefix() ."module_AdvancedContent_".$tpl_type."_tpl_assocs
			(input_id, tpl_name) VALUES (?,?)";
		$dbresult = $db->Execute($query, array($input_id, $tpl_name));
		return $dbresult;
	}
	
	public function DeleteTplAssoc($tpl_type,$input_ids = array())
	{
		$db =& cmsms()->GetDb();
		if(!is_array($input_ids))
		{
			$input_ids = ac_utils::CleanArray(explode(",",$input_ids));
		}
		if(!count($input_ids))
		{
			return false;
		}
		$query = "DELETE FROM ". cms_db_prefix() . "module_AdvancedContent_".$tpl_type."_tpl_assocs WHERE ";
		$q = array();
		foreach($input_ids as $_id)
		{
			$q[] = "input_id = ?";
		}
		$query   .=  implode(" OR ", $q);
		$dbresult = $db->Execute($query, $input_ids);
		return $dbresult;
	}
	
	public function DeleteMultiInput($input_ids = array())
	{
		$db =& cmsms()->GetDb();
		if(!is_array($input_ids))
		{
			$input_ids = ac_utils::CleanArray(explode(",",$input_ids));
		}
		if(!count($input_ids))
		{
			return false;
		}
		$query = "DELETE FROM ". cms_db_prefix() . "module_AdvancedContent_multi_inputs WHERE ";
		$q = array();
		foreach($input_ids as $_id)
		{
			$q[] = "input_id = ?";
		}
		
		$query   .=  implode(" OR ", $q);
		$dbresult = $db->Execute($query, $input_ids);
		return $dbresult;
	}
	
	public function GetTemplates($prefix)
	{
		$db     =& cmsms()->GetDb();
		$query  = "SELECT TPL.template_name, TPL_ASSOCS.* FROM ". cms_db_prefix() . "module_templates TPL
			LEFT OUTER JOIN ".cms_db_prefix()."module_AdvancedContent_".$prefix."_tpl_assocs TPL_ASSOCS
			ON TPL.template_name = TPL_ASSOCS.tpl_name
			WHERE TPL.module_name = ? AND TPL.template_name LIKE ? ";
		$return_array = array();
		$dbresult     = $db->Execute($query, array('AdvancedContent',$prefix.'_%'));
		while($dbresult && $row = $dbresult->FetchRow())
		{
			if(!isset($return_array[$row['template_name']]))
			{
				$return_array[$row['template_name']] = array();
			}
			$return_array[$row['template_name']]['tpl_name'] = substr($row['template_name'],strlen($prefix.'_'));
			$return_array[$row['template_name']]['tpl_id']   = $row['template_name'];
			if(!isset($return_array[$row['template_name']]['tpl_assocs']))
			{
				$return_array[$row['template_name']]['tpl_assocs'] = array();
				$return_array[$row['template_name']]['is_used'] = false;
			}
			if($row['input_id'])
			{
				$return_array[$row['template_name']]['tpl_assocs'][] = $row['input_id'];
				$return_array[$row['template_name']]['is_used'] = true;
			}
		}
		return $return_array;
	}
	
	public function GetTplList($prefix)
	{
		$prefix = trim($prefix,'_') . '_';
		$db     =& cmsms()->GetDb();
		$query  = "SELECT template_name FROM ". cms_db_prefix() . "module_templates
			WHERE module_name = ? AND template_name LIKE ? ";
		$return_array = array();
		$dbresult = $db->Execute($query, array('AdvancedContent',$prefix.'%'));
		while($dbresult && $row = $dbresult->FetchRow())
		{
			$tpl_name = substr($row['template_name'],strlen($prefix));
			$return_array[$tpl_name] = $row['template_name'];
		}
		return $return_array;
	}
	
	public function IsTplUsed($tpl_name, $assoc_type)
	{
		$db     =& cmsms()->GetDb();
		$query  = "SELECT tpl_name FROM ". cms_db_prefix() . "module_AdvancedContent_".$assoc_type."_tpl_assocs
			WHERE template_name = ? ";
		$dbresult = $db->Execute($query, array($tpl_name));
		if(!$dbresult || !$row = $dbresult->FetchRow())
		{
			return false;
		}
		return true;
	}
	
	public function &GetCustomBlockTypes()
	{
		$config     = cmsms()->GetConfig();
		$dir        = cms_join_path($config['root_path'], 'module_custom', 'AdvancedContent', 'lib');
		$blockTypes = array();
		
		if(is_dir($dir))
		{
			$contentops =& cmsms()->GetContentOperations();
			$contentobj = $contentops->CreateNewContent('Content2');
			$classnames = array();
			
			$d = @dir($dir);
			while($entry = $d->read())
			{
				if(preg_match('/class\.(acBlockType_\w+)\.php/', $entry, $matches))
				{
					$blockTypes[] = new $matches[1]($contentobj, $params);
				}
			}
		}
		return $blockTypes;
	}
	
	public function &GetCoreBlockTypes()
	{
		$config     = cmsms()->GetConfig();
		$dir        = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'lib';
		$blockTypes = array();
		
		$contentops =& cmsms()->GetContentOperations();
		$contentobj = $contentops->CreateNewContent('Content2');
		$classnames = array();
		
		$d = @dir($dir);
		while($entry = $d->read())
		{
			if(preg_match('/class\.(acBlockType_\w+)\.php/', $entry, $matches))
			{
				$blockTypes[] = new $matches[1]($contentobj, $params);
			}
		}
		return $blockTypes;
	}
	
	
	
	/**
	 * Get the groups of the backend user
	 * @return array
	 * @internal
	 */
	public function &GetAdminGroups()
	{
		if(!$this->_variables['admin_groups'])
		{
			$db =& cmsms()->GetDb();
			$this->_variables['admin_groups'] = array();
			$query = "SELECT group_id FROM ".cms_db_prefix()."user_groups WHERE user_id = ?";
			$dbresult = $db->Execute($query, array(get_userid()));
			while( $dbresult && $row = $dbresult->FetchRow() )
			{
				$this->_variables['admin_groups'][] = $row['group_id'] * -1;
			}
		}
		return $this->_variables['admin_groups'];
	}
	
	/**
	 * Get all backend groups
	 * @return array
	 * @access private
	 */
	private function &_get_all_admin_groups()
	{
		if(!$this->_variables['all_admin_groups'])
		{
			$groupOps =& cmsms()->GetGroupOperations();
			$this->_variables['all_admin_groups'] = $groupOps->LoadGroups();
		}
		return $this->_variables['all_admin_groups'];
	}
	
	
	/**
	 * Get all backend users
	 * @return array
	 * @access private
	 */
	private function &_get_all_admin_users()
	{
		if(!$this->_variables['all_admin_users'])
		{
			$userOps              =& cmsms()->GetUserOperations();
			$this->_variables['all_admin_users'] =& $userOps->LoadUsers();
		}
		return $this->_variables['all_admin_users'];
	}
	
	
	/**
	 * Checks if a backend user has sufficient permission to edit a block
	 * @return boolean
	 * @internal
	 */
	public function CheckBlockPermission($editor_users, $editor_groups)
	{
		$addt_editors = array();
		if(($editor_users != '' || $editor_groups != '')
			&& !check_permission(get_userid(), 'Manage All AdvancedContent Blocks'))
		{
			$editorGroups =  ac_utils::CleanArray(explode(',',$editor_groups));
			$editorUsers  =  ac_utils::CleanArray(explode(',',$editor_users));
			foreach ($this->_get_all_admin_groups() as $oneGroup)
			{
				if(in_array($oneGroup->name,$editorGroups))
				{
					$addt_editors[] = $oneGroup->id*-1;
				}
			}
			
			foreach ($this->_get_all_admin_users() as $oneUser)
			{
				if(in_array($oneUser->username,$editorUsers))
				{
					$addt_editors[] = $oneUser->id;
				}
			}
			
			if(!in_array(get_userid(),$addt_editors)
				&& !count(array_intersect($this->_get_admin_groups(),$addt_editors)))
			{
				return false;
			}
		}
		return true;
	}
}
?>
