<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010-2012 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2012 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.9.3
# File   : AdvancedContent.module.php
# Purpose: initial module class.
# License: GPL
#
#-------------------------------------------------------------------------------

class AdvancedContent extends CMSModule
{
	protected $_pp = '<div style="float:right"><form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick" />
<input type="hidden" name="hosted_button_id" value="FA2D3FPLSTAKJ" />
<input type="image" src="https://www.paypal.com/en_GB/i/btn/btn_donate_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online." />
<img alt="" border="0" src="https://www.paypal.com/de_DE/i/scr/pixel.gif" width="1" height="1" />
</form></div>';

	public final function __construct()
	{
		parent::__construct();
		$this->RegisterContentType(
			'Content2', 
			dirname(__FILE__) . '/contenttype.Content2.php', 
			$this->lang('AdvancedContent')
		);
		$config = cmsms()->GetConfig();
		$this->smarty->plugins_dir[] = $config["root_path"].'/modules/AdvancedContent/plugins';
	}
	
	public final function GetName()
	{
		return get_class($this);
	}
	
	public final function GetFriendlyName()
	{
		return $this->Lang($this->GetPreference('friendly_name', $this->GetName()));
	}
	
	public final function GetVersion()
	{
		return '0.9.3';
	}
	
	public final function GetHelp()
	{
		if(isset($_GET['action']) && $_GET['action'] == 'showmodulehelp')
		{
			$block_help = array();
			foreach(ac_admin_ops::get_instance()->GetCustomBlockTypes() as $blockType)
			{
				$block_help[] = $blockType->GetHelp();
			}
			$block_help = implode('<div class="pageheader"></div>', $block_help);
			
			$plugin_help = array();
			$d = dir(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'plugins');
			while ($entry = $d->read())
			{
				if(preg_match('/^function\.(\w+)\.php$/i',$entry,$matches))
				{
					if(!function_exists('smarty_cms_function_' . $matches[1]))
					{
						require_once(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'plugins' . DIRECTORY_SEPARATOR . $entry);
					}
					if(function_exists('smarty_cms_help_function_' . $matches[1]))
					{
						$plugin_help[] = call_user_func('smarty_cms_help_function_' . $matches[1]);
					}
				}
			}
			$plugin_help = implode('<div class="pageheader"></div>', $plugin_help);
			
			$help_file = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'doc' . DIRECTORY_SEPARATOR . 'help_' . $this->curlang . '.html';
			if(!is_file($help_file))
			{
				$help_file = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'doc' . DIRECTORY_SEPARATOR . 'help_en_US.html';
			}
			
			$helptext = $this->_pp;
			
			if($block_help || $plugin_help)
			{
				$helptext .= $this->StartTabHeaders() . $this->SetTabHeader('help', lang('help'), true);
				if($block_help)
				{
					$helptext .= $this->SetTabHeader('custom_blocktypes', $this->lang('custom_blocktypes'), false);
				}
				if($plugin_help)
				{
					$helptext .= $this->SetTabHeader('plugins', $this->lang('plugins'), false);
				}
				$helptext .= $this->EndTabHeaders() . $this->StartTabContent() . $this->StartTab('help');
			}
			
			$helptext .= file_get_contents($help_file);
			
			if($block_help || $plugin_help)
			{
				$helptext .= $this->EndTab();
				if($block_help)
				{
					$helptext .= $this->StartTab('custom_blocktypes') . $block_help . $this->EndTab();
				}
				if($plugin_help)
				{
					$helptext .= $this->StartTab('plugins') . $plugin_help . $this->EndTab();
				}
				$helptext .= $this->EndTabContent();
			}
			return $helptext;
		}
		return true;
	}
	
	public final function GetAuthor()
	{
		return 'Georg Busch (NaN)';
	}
	
	/**
	 * @todo plugin changelog
	 */
	public final function GetChangeLog()
	{
		if(isset($_GET['action']) && $_GET['action'] == 'showmoduleabout')
		{
			$blockChangeLog = array();
			foreach(ac_admin_ops::get_instance()->GetCustomBlockTypes() as $blockType)
			{
				$blockChangeLog[] = $blockType->GetChangeLog();
			}
			$blockChangeLog = implode('',$blockChangeLog);
			$changeLog      = $this->_pp;
			if($blockChangeLog)
			{
				$changeLog .=
					$this->StartTabHeaders() .
						$this->SetTabHeader('help', lang('help'), true) .
						$this->SetTabHeader('custom_blocktypes', $this->lang('custom_blocktypes'), false) .
					$this->EndTabHeaders() .
					$this->StartTabContent() . 
						$this->StartTab('help');
			}
			$changeLog .= file_get_contents(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'doc' . DIRECTORY_SEPARATOR . 'changelog.html');
			if($blockChangeLog)
			{
				$changeLog .= 
						$this->EndTab() .
						$this->StartTab('custom_blocktypes') . 
							$blockChangeLog . 
						$this->EndTab() .
					$this->EndTabContent();
			}
			return $changeLog;
		}
		return true;
	}
	
	public final function HasContentType()
	{
		return true;
	}
	
	public final function IsPluginModule()
	{
		return true;
	}
	
	public final function HasAdmin()
	{
		return true;
	}
	
	public final function GetAdminSection()
	{
		return 'extensions';
	}
	
	public final function GetAdminDescription()
	{
		return $this->lang('admindescription');
	}
	
	public final function VisibleToAdminUser()
	{
		return $this->CheckPermission('Manage AdvancedContent Preferences') || $this->CheckPermission('Manage AdvancedContent MultiInputs') || $this->CheckPermission('Manage AdvancedContent MultiInput Templates');
	}
	
	public final function MinimumCMSVersion()
	{
		return "1.10.3";
	}
	
	public final function MaximumCMSVersion()
	{
		return "1.11";
	}
	
	public final function InstallPostMessage()
	{
		return $this->Lang('postinstall', $this->GetVersion());
	}
	
	public final function UninstallPostMessage()
	{
		return $this->Lang('postuninstall', $this->GetVersion());
	}
	
	public final function UninstallPreMessage()
	{
		return $this->Lang('confirmuninstall', $this->lang('warninguninstall' . $this->GetPreference('uninstall_action')));
	}
	
	public final function HandlesEvents()
	{
		return true;
	}
	
	public final function DoAction($action, $id, $params, $returnid = '')
	{
		switch($action) {
			case 'importpages':
			case 'deleteMultiInput':
			case 'deleteMultiInputTpl':
			case 'switchParams':
			case 'default':
			case 'savePrefs':
			case 'defaultadmin':
			case 'addMultiInput':
			case 'editMultiInput':
			case 'addMultiInputTpl':
			case 'editMultiInputTpl':
				parent::DoAction($action, $id, $params, $returnid);
				break;
			default: break;
		}
	}
	
	public final function InitializeFrontend()
	{
		$this->SetParameters();
	}
	
	public final function InitializeAdmin()
	{
	}
	
	public final function SetParameters()
	{
		$this->RegisterModulePlugin();
	}
	
	public final function GetHeaderHTML()
	{
		$config = cmsms()->GetConfig();
		$this->smarty->assign('module_id', 'm1_');
		$this->smarty->assign('debug',$config['debug'] ? 'true' : '\'\'');
		
		$dir = cms_join_path($config['root_path'], 'lib', 'jquery', 'css', 'smoothness');
		if(!is_dir($dir))
		{
			$jq_ui_css = $config['root_url'] . '/modules/' . $this->GetName() . '/css/jquery-ui/base/jquery.ui.all.css';
		}
		else 
		{
			$d = @dir($dir);
			while ($entry = $d->read())
			{
				if(preg_match('/jquery-ui-[\d\.]+\.custom\.css/i', $entry))
				{
					$jq_ui_css = $config['root_url'] . '/lib/jquery/css/smoothness/' . $entry;
					break;
				}
			}
		}
		$this->smarty->assign('jq_ui_css', $jq_ui_css);
		$this->smarty->assign('locale', substr(get_preference(get_userid(),'default_cms_language'), 0, 2));
		return $this->ProcessTemplate('header.tpl');
	}
	
	public final function LazyLoadFrontend()
	{
		return FALSE;
	}
	
	public final function LazyLoadAdmin()
	{
	  return TRUE;
	}
}

function AdvancedContent_Autoloader($classname)
{
	$config = cmsms()->GetConfig();
	$fn     = cms_join_path($config['root_path'], 'module_custom', 'AdvancedContent', 'lib', 'class.'.$classname.'.php');
	if( file_exists($fn) )
	{
		require_once($fn);
		return TRUE;
	}
	return FALSE;
}
spl_autoload_register('AdvancedContent_Autoloader');

?>
