<?php
#-------------------------------------------------------------------------
# Module: EventsManager
# Method: Upgrade
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#-------------------------------------------------------------------------
if (!isset($gCms)) exit;

$current_version = $oldversion;
switch($current_version)
{
	// we are now 0.1 and want to upgrade to latest
	case "0.1":
	{
		$this->CreateEvent('EventsManagerEventAdded');
		$this->CreateEvent('EventsManagerEventEdited');
		$this->CreateEvent('EventsManagerEventDeleted');
		
		$this->CreateEvent('EventsManagerCategoryAdded');
		$this->CreateEvent('EventsManagerCategoryEdited');
		$this->CreateEvent('EventsManagerCategoryDeleted');
		
		$this->CreateEvent('EventsManagerRegistrationAdded');
		$this->CreateEvent('EventsManagerRegistrationEdited');
	}
	
	case "0.1.1":
	case "0.1.2":
	case "0.1.3":
	case "0.1.4":
	case "0.1.5":
	case "0.1.6":
	case "0.1.7":
	case "0.1.8":
	case "0.1.9":
	{
		$fn = cms_join_path(dirname(__FILE__),'templates','orig_registrationslisttemplate.tpl');
		if( file_exists( $fn ) )
		{
			$template = file_get_contents( $fn );
			$this->SetPreference('orig_registrationslist_template',$template);
			$this->SetTemplate('registrationslist_Sample',$template);
			$this->SetPreference('dflt_registrationslist_template','Sample');
		}
	}
}

// put mention into the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded', $this->GetVersion()));
?>