<?php

class EventsManager_registration extends EventsManager_object
{
	protected $table = 'events_registrations';
	
	protected $custom_fields = array(
		'id_event'=>'',
		'id_user'=>'',
		'nb_persons'=>0
	);
	
	// Constructor - we try to load the registration from the id_event and current logged in user
	public function __construct($id=false, $load_fields=true, $id_event=false)
	{
		if ($id_event)
		{
			$db = cmsms()->GetDb();
			$feu_module = cms_utils::get_module('FrontEndUsers');
			$id_user = $feu_module->LoggedInId();
			
			// Try to load the id from the db
			$query = "SELECT id FROM ".cms_db_prefix()."module_".$this->table." WHERE id_event=? AND id_user=?";
			$id_registration = $db->GetOne($query, array($id_event, $id_user));
			
			if ($id_registration)
			{
				// Load with id
				parent::__construct($id_registration);
			}
			else
			{
				$this->custom_fields['id_event'] = $id_event;
				$this->custom_fields['id_user'] = $id_user;
				parent::__construct($id, $load_fields);
			}
		}
		else
			parent::__construct($id, $load_fields);
		
		if ($this->id_user)
			$this->load_user();
	}
	
	// Load the user with the properties
	public function load_user()
	{
		$this->user = new EventsManager_user($this->id_user);
	}
	
	// Smarty object with the user
	public function get_smarty_object()
	{
		if (!$this->user)
			$this->load_user();
		
		$obj = parent::get_smarty_object();
		$obj->user = $this->user;
		
		return $obj;
	}
	
}

?>