<?php
if (!isset($gCms)) exit;
if (!$this->HasPermission()) exit;

// Preferences tab
$this->SetCurrentTab('preferences');

// Submit ?
if (isset($params['cancel']))
	$this->RedirectToTab($id);

if (isset($params['submit']))
{
	// Update the preferences
	$this->SetPreference('menuname', trim($params['menuname']));
	$this->SetPreference('dflt_detailpage', $params['dflt_detailpage']);
	$this->SetPreference('urlprefix', trim($params['urlprefix']));
	$this->SetPreference('registerurlprefix', trim($params['registerurlprefix']));
	$this->SetPreference('dflt_registrationpage', $params['dflt_registrationpage']);
	
	$tmp = implode(',', $params['displayed_feu_properties']);
	if ($tmp)
		$this->SetPreference('displayed_feu_properties', $tmp);
	else
		$this->SetPreference('displayed_feu_properties', '');
	
	$this->SetPreference('exportencoding', $params['exportencoding']);
	
	$this->RedirectToTab($id);
}

// Form
$smarty->assign('form_start', $this->CreateFormStart($id, 'defaultadmin'));
$smarty->assign('form_end', $this->CreateFormEnd());
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));

// Content operations
$contentops = cmsms()->GetContentOperations();

// General options
// Menu name
$smarty->assign('label_menuname', $this->CreateLabelForInput($id, 'menuname', $this->Lang('label_menuname')));
$smarty->assign('input_menuname', $this->CreateInputText($id, 'menuname', $this->GetPreference('menuname'), 50));

// Default detail page for an event
$smarty->assign('label_dflt_detailpage', $this->CreateLabelForInput($id, 'dflt_detailpage', $this->Lang('label_dflt_detailpage')));
$smarty->assign('input_dflt_detailpage', $contentops->CreateHierarchyDropdown('', $this->GetPreference('dflt_detailpage'), $id.'dflt_detailpage'));

// URL prefixes (url rewriting)
$smarty->assign('label_urlprefix', $this->CreateLabelForInput($id, 'urlprefix', $this->Lang('urlprefix')));
$smarty->assign('input_urlprefix', $this->CreateInputText($id, 'urlprefix', $this->GetPreference('urlprefix'), 50));
// Register prefix
$smarty->assign('label_registerurlprefix', $this->CreateLabelForInput($id, 'registerurlprefix', $this->Lang('registerurlprefix')));
$smarty->assign('input_registerurlprefix', $this->CreateInputText($id, 'registerurlprefix', $this->GetPreference('registerurlprefix'), 50));

// Default page for an event registration
$smarty->assign('label_dflt_registrationpage', $this->CreateLabelForInput($id, 'dflt_registrationpage', $this->Lang('label_dflt_registrationpage')));
$smarty->assign('input_dflt_registrationpage', $contentops->CreateHierarchyDropdown('', $this->GetPreference('dflt_registrationpage'), $id.'dflt_registrationpage'));

// FEU Properties to display in the registerd users list and in export
$feu_module = cms_utils::get_module('FrontEndUsers');
$feu_properties = $feu_module->GetPropertyDefns();

if ($feu_properties)
{
	$options_list = array();
	foreach ($feu_properties as $key=>$val)
		$options_list[$val['prompt']] = $key;
	$current_options_list = explode(',', $this->GetPreference('displayed_feu_properties'));

	$smarty->assign('label_displayed_feu_properties', $this->CreateLabelForInput($id, 'displayed_feu_properties', $this->Lang('displayed_feu_properties')));
	$smarty->assign('input_displayed_feu_properties', $this->CreateInputSelectList($id, 'displayed_feu_properties[]', $options_list, $current_options_list, 5));
}

// CSV export encoding
$smarty->assign('label_exportencoding', $this->CreateLabelForInput($id, 'exportencoding', $this->Lang('exportencoding')));
$smarty->assign('input_exportencoding', $this->CreateInputText($id, 'exportencoding', $this->GetPreference('exportencoding', 'UTF-8')));

// Display the form
echo $this->ProcessTemplate('admin_tab_preferences.tpl');

?>