<?php
$lang['moddescription'] = 'This module adds the ability to include additional Meta data, Analytics tracking code and other useful SEO information.';
$lang['friendlyname'] = 'Meta Max';
$lang['postinstall'] = 'Be sure to set "Use Meta Max" permissions to use this module!';
$lang['postuninstall'] = 'Thanks! Come again soon.';
$lang['really_uninstall'] = 'Really? You\'re sure you want to uninstall this fine module?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['alert_no_records'] = 'No preferences have been set, please change and save your preferences before implementing MetaMax on your site.';
$lang['prefsupdated'] = 'Module preferences updated.';
$lang['submit'] = 'Save';
$lang['accessdenied'] = 'Access Denied. Please check your permissions.';
$lang['error'] = 'Error!';
$lang['analyticserror'] = 'Only one option can be checked at a time!';
$lang['none'] = 'None';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['page_title_legend'] = 'Page title and description';
$lang['html_title_legend'] = 'HTML options';
$lang['additional_title_legend'] = 'Additional content';
$lang['meta_title_legend'] = 'Meta tags';
$lang['metaoptions_title_legend'] = 'Meta content';
$lang['keywords_title_legend'] = 'Keyword settings';
$lang['analytics_title_legend'] = 'Google Analytics settings';
$lang['search_title_legend'] = 'Google Analytics Search settings (All fields are required for this feature to work)';
$lang['bing_title_legend'] = 'Bing webmaster settings';
$lang['tab_mod_general'] = 'General settings';
$lang['tab_mod_html'] = 'HTML tag settings';
$lang['tab_mod_meta'] = 'Page title & Meta information';
$lang['tab_mod_keywords'] = 'Keyword settings';
$lang['tab_mod_analytics'] = 'Analytics Account settings';
$lang['tab_mod_bing'] = 'Bing Account settings';
$lang['page_smarty'] = 'Page title smarty tag';
$lang['page_smarty_help'] = 'This allows you to replace the standard current page title with a smarty tag';
$lang['page_title'] = 'Page title';
$lang['page_title_help'] = 'This will get appended to your page and site name';
$lang['delimiter_title'] = 'Page title delimiter';
$lang['delimiter_title_help'] = 'This is the symbol used to seperate your title text';
$lang['meta_block_title'] = 'Name of metadata content block';
$lang['meta_block_title_help'] = 'This should be the name given to your metadata content block, check module help for more info';
$lang['block_title'] = 'Name of page description content block';
$lang['block_title_help'] = 'This should be the name given to your page description content block, check module help for more info';
$lang['length_title'] = 'Number of words to appear in auto description';
$lang['auto_title'] = 'Automatically generate a page description where none is provided';
$lang['base_title'] = 'Generate Base Tag';
$lang['opendoctype_title'] = 'Generate Doctype tag';
$lang['doctype_title'] = 'Specify Doctype';
$lang['doctype_select'] = 'Please select one';
$lang['doctype_html5'] = 'HTML5';
$lang['doctype_xhtml_s'] = 'XHTML 1.0 Strict';
$lang['doctype_xhtml_t'] = 'XHTML 1.0 Transitional';
$lang['doctype_xhtml_f'] = 'XHTML 1.0 Frameset';
$lang['doctype_html4_s'] = 'HTML 4.01 Strict';
$lang['doctype_html4_t'] = 'HTML 4.01 Transitional';
$lang['doctype_html4_f'] = 'HTML 4.01 Frameset';
$lang['doctype_html4_rdf'] = 'HTML 4.01 + RDFa 1.1';
$lang['doctype_html3'] = 'HTML 3.2';
$lang['doctype_html2'] = 'HTML 2.0';
$lang['doctype_xhtml1'] = 'XHTML 1.1';
$lang['doctype_xhtml1_rdf'] = 'XHTML 1.1 + RDFa';
$lang['doctype_xhtml_rdf'] = 'XHTML + RDFa';
$lang['doctype_xhtml_basic_1_0'] = 'XHTML Basic 1.0';
$lang['doctype_xhtml_basic_1_1'] = 'XHTML Basic 1.1';
$lang['html_title'] = 'Specify HTML language';
$lang['htmlextra_title'] = 'Extra HTML tag content';
$lang['htmlextra_title_help'] = 'Manifest information for example';
$lang['openhtml_title'] = 'Generate Opening HTML Tag';
$lang['xmlns_title'] = 'Inlcude XMLNS';
$lang['dir_title'] = 'Include text direction';
$lang['dirchoice_title'] = 'Text direction';
$lang['dirchoice_select'] = 'Please select one';
$lang['dirchoice_ltr'] = 'Left to right';
$lang['dirchoice_rtl'] = 'Right to left';
$lang['lang_title'] = 'Include language';
$lang['xmllang_title'] = 'Include XML language';
$lang['openhead_title'] = 'Generate Opening Head Tag';
$lang['closehead_title'] = 'Generate Closing Head Tag';
$lang['stylesheet_title'] = 'Include &#123;cms_stylesheet} tag';
$lang['compatible_title'] = 'Include X-UA-Compatible tag';
$lang['compatibleie_title'] = 'IE version for compatibility tag';
$lang['compatiblechrome_title'] = 'Chrome version for compatibility tag';
$lang['compatible_select'] = 'Please select one';
$lang['compatible_7'] = 'IE 7';
$lang['compatible_8'] = 'IE 8';
$lang['compatible_9'] = 'IE 9';
$lang['compatible_edge'] = 'IE Edge';
$lang['compatible_chrome'] = 'Chrome';
$lang['additional_title'] = 'Additional content to appear in head';
$lang['standard_title'] = 'Generate standard Meta Tags';
$lang['dublin_title'] = 'Generate Dublin Core Meta Tags';
$lang['opengraph_title'] = 'Generate OpenGraph Meta Tags (e.g. for Facebook Like Button)';
$lang['publisher_title'] = 'Site publisher';
$lang['contributor_title'] = 'Site contributor';
$lang['relation_title'] = 'Related website';
$lang['location_title'] = 'Location of your entity';
$lang['region_title'] = 'Region of your entity';
$lang['latitude_title'] = 'Latitude of your entity';
$lang['longitude_title'] = 'Longitude of your entity';
$lang['ogtitle_title'] = 'OpenGraph page title';
$lang['ogtype_title'] = 'OpenGraph default page type';
$lang['ogname_title'] = 'OpenGraph site name';
$lang['ogimage_title'] = 'OpenGraph default image';
$lang['ogimage_title_help'] = 'Select an image from your /uploads/images directory to be used as the default for OpenGraph pages';
$lang['fbadmin_title'] = 'Facebook site administrators';
$lang['fbapp_title'] = 'Facebook application';
$lang['key_number'] = 'Number of keywords';
$lang['key_length'] = 'Length of keywords';
$lang['key_length_help'] = 'Minimum character length before becoming a keyword';
$lang['key_density'] = 'Density of keywords';
$lang['key_density_help'] = 'How many times a word has to appear before becoming a Keyword';
$lang['key_default'] = 'Set of default keywords to always include, comma seperated list';
$lang['keyskip_title'] = 'Keyword STOP words';
$lang['key_stop_help'] = 'Words not to include as keywords, comma seperated list';
$lang['xml_title'] = 'Create an XML Google Sitemap';
$lang['push_title'] = 'Automatically push the sitemap to Google after content changes';
$lang['robots_title'] = 'Create a robots.txt file';
$lang['analytics_type'] = 'Anlytics type';
$lang['analytics_select'] = 'Please select one';
$lang['analytics_single'] = 'A single domain';
$lang['analytics_sub'] = 'One domain with multiple subdomains';
$lang['analytics_multiple'] = 'Multiple top-level domains';
$lang['propertyid_title'] = 'Web Property ID';
$lang['webmasterid_title'] = 'Webmaster meta verification key';
$lang['pretty_title'] = 'Are pretty URLs enabled?';
$lang['post_title'] = 'Search type POST being used?';
$lang['query_title'] = 'Query parameter';
$lang['query_help'] = 'This must be the same as the one entered in your Analytics account settings';
$lang['results_title'] = 'Results page alias';
$lang['results_help'] = 'Page alias of your search results page';
$lang['bingid_title'] = 'Bing verification ID';
$lang['changelog'] = '<ul>
<li>Version 1.0. 10 December 2011. Initial Release.</li>
<li>Version 1.1. 14 December 2011. Removed code that restricted description length when specifying page description rather than using the auto description feature.</li>
<li>Version 1.2. 14 December 2011. Fixed bug that threw errors on some servers.</li>
<li>Version 1.3. 14 December 2011. Added the ability to use a smarty tag as the current page title.</li>
<li>Version 1.4. 15 December 2011. Added Bing webmaster tab.</li>
<li>Version 1.5. 16 December 2011. Added HTML and Doctype controls.</li>
<li>Version 1.6. 19 December 2011. Merged Google and Bing tabs and added the ability to specify keyword stop words.</li>
<li>Version 1.6.1. 19 December 2011. Minor bug fix.</li>
<li>Version 1.6.2. 21 December 2011. Added more HTML tag controls.</li>
<li>Version 1.6.3. 21 December 2011. Added X-UA-Compatability Meta tag and controls.</li>
<li>Version 1.6.4. 25 January 2012. Bug fix #7513 as suggested by Stephen Owens.</li>
<li>Version 1.6.5. 27 January 2012. Removed error if no text appears in the page content area.</li>
<li>Version 1.6.6. 31 January 2012. Added Analytics search options.</li>
<li>Version 1.6.7. 22 February 2012. Bug fixes and addition of Metadata content block to enable page specific metadata.</li>
<li>Version 1.6.8. 24 February 2012. Minor bug fix.</li></ul>';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>This module adds the ability to include additional Meta data, Analytics tracking code and other useful SEO information. It can also be used to generate Doctype and Head tags, replacing the entire head of your document.</p>
<h3>How Do I Use It</h3>
<p>Meta Max can be used either to add additional meta data to your templates by inserting the call into the head section, or completely replace the head code in your templates.</p>
<p>Meta Max has the ability to generate opening HTML tags, Doctype tag and everything you could need in your Head tags too.</p>
<p>Firstly you need to remove the standard &#123;metadata} call, this is not compatible with Meta Max and may cause problems. You may also need to remove your <DOCTYPE>, opening <html> tag and <head> tags depending on which parameters you have enabled.</p>
<p>Just add &#123;MetaMax} to the top or head of each template.</p>
<p>If you are using the auto description option you will need to add &#123;capture}&#123;content block=\'Page Description\' oneline=\'true\' wysiwyg=\'false\'}&#123;/capture} to your templates and reference this content blocks name in the \'page description content block\' input field, which in this example is Page Description.</p>
<p>If you want page specific metadata simply add &#123;capture}&#123;content block=\'Metadata\' wysiwyg=\'false\'}&#123;/capture} to your templates and reference this content blocks namie in the \'metadata content block\' input field, which in this example is Metadata.</p>
<p>The Analytics search options are only required if you are using pretty URL\'s in conjunction with the search module\'s POST method otherwise simply adding the default cntnt01searchinput into your Analytics setup will track site search queries.</p>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report, please visit the Module Forge
<a href="http://dev.cmsmadesimple.org/projects/metamax/">Meta Max Page</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, oliverseddon, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2011, Oliver Seddon <a href="mailto:oliver@threefold.co.uk">&lt;oliver@threefold.co.uk&gt;</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.</p>
';
?>