<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Retrieve the selection criteria from previous visit
if (isset($user_id) ) {
	$usedhometeam = get_preference( $user_id, 'tss_hometeam' );
	$usedvisitorteam = get_preference( $user_id, 'tss_visitorteam' );
	$usedleaguename = get_preference( $user_id, 'tss_leaguename' );
	$usedfuture = get_preference( $user_id, 'tss_future' );
	$datefrom = get_preference( $user_id, 'tss_datefrom' );
	$dateto = get_preference( $user_id, 'tss_dateto' );
	$sortby = get_preference( $user_id, 'tss_sortby' );
	$sequence = get_preference( $user_id, 'tss_sequence' );
}

// Reset of user preferences
if (isset($params['submitreset'])) {
	$query = 'DELETE FROM '.cms_db_prefix().'userprefs WHERE preference like "tss_%" and user_id = '. $user_id;
	$db->Execute($query);
	$usedhometeam = 0;
	$usedvisitorteam = 0;
	$usedleaguename = 0;
	$usedfuture = 'NOPLAY';
	$datefrom = date('Y-m-d', time());
	$dateto = $datefrom;
	$sortby = 'sb_matchdate';
	$sequence = 'ASC';
}

// Submit has been used, use all the parameters to prepare the query for the data
if (isset($params['submitfilter'])) {
	if (isset($params['hometeam']))
	{
		 $usedhometeam = $params['hometeam'];
	}
	if (isset($params['visitorteam']))
	{
		 $usedvisitorteam = $params['visitorteam'];
	}
	if (isset($params['future']))
	{
		 $usedfuture = $params['future'];
	}
	if (isset($params['leaguename']))
	{
		 $usedleaguename = $params['leaguename'];
	}
	if (isset($params['datefrom_Month']))
	{
		$datefrom = date("Y-m-d H:i:s",mktime(0,0,0,$params['datefrom_Month'],$params['datefrom_Day'],$params['datefrom_Year'])); 
	}
	if (isset($params['dateto_Month']))
	{
		$dateto = date("Y-m-d H:i:s",mktime(23,59,59,$params['dateto_Month'],$params['dateto_Day'],$params['dateto_Year']));
		// Make sure that the to date is not less then the from date
		if ( substr($datefrom, 1, 10) > substr($dateto, 1, 10) ) {
			$dateto = $datefrom;
		}
	}
	if (isset($params['sortby']))
	{
		 $sortby = $params['sortby'];
	}
	if (isset($params['sequence']))
	{
		 $sequence = $params['sequence'];
	}
	if (isset($user_id) ) {
		// Store the used selection criteria for next visit
		set_preference( $user_id, 'tss_hometeam', $usedhometeam );
		set_preference( $user_id, 'tss_visitorteam', $usedvisitorteam );
		set_preference( $user_id, 'tss_leaguename', $usedleaguename );
		set_preference( $user_id, 'tss_future', $usedfuture );
		set_preference( $user_id, 'tss_sortby', $sortby );
		set_preference( $user_id, 'tss_sequence', $sequence );
		set_preference( $user_id, 'tss_datefrom', $datefrom );
		set_preference( $user_id, 'tss_dateto', $dateto );
	}

}

// Prepare dropdown values for hometeams
$hometeamlist = array();
// Add a selection option to see all
$NotApplicable=$this->Lang('allhometeams');
$hometeamlist[$NotApplicable] = 0;
$query = 'SELECT DISTINCT(hometeam) FROM '.cms_db_prefix().'module_tss_gameschedule_score ORDER BY hometeam';
$dbresult = $db->Execute($query);

while ($dbresult && $row = $dbresult->FetchRow())
{
	$hometeamlist[$row['hometeam']] = $row['hometeam'];
}

// Prepare a list of the visitors teams
$visitorteamlist = array();
// Add a selection option to see all
$NotApplicable=$this->Lang('allvisitorteams');
$visitorteamlist[$NotApplicable] = 0;
$query = 'SELECT DISTINCT(visitorteam) FROM '.cms_db_prefix().'module_tss_gameschedule_score ORDER BY visitorteam';
$dbresult = $db->Execute($query);

while ($dbresult && $row = $dbresult->FetchRow())
{
	$visitorteamlist[$row['visitorteam']] = $row['visitorteam'];
}

// Prepare a list of league names
$leagueslist = array();
// Add a selection option to see all
$NotApplicable=$this->Lang('allleagues');
$leagueslist[$NotApplicable] = 0;
$query = 'SELECT DISTINCT(name) FROM '.cms_db_prefix().'module_tss_leagues ORDER BY name';
$dbresult = $db->Execute($query);

while ($dbresult && $row = $dbresult->FetchRow())
{
	$leagueslist[$row['name']] = $row['name'];
}

$sortbylist = array();
$sortbylist[$this->Lang('matchbyhometeam')] = 'sb_hometeam';
$sortbylist[$this->Lang('matchbyvisitorteam')] = 'sb_visitorteam';
$sortbylist[$this->Lang('matchbyleaguename')] = 'sb_leaguename';
$sortbylist[$this->Lang('matchbydate')] = 'sb_matchdate';

$sequencelist = array();
$sequencelist[$this->Lang('matchbyseqasc')] = 'ASC';
$sequencelist[$this->Lang('matchbyseqdesc')] = 'DESC';

$matchtypes = array($this->Lang('all')=>'ALL',
	$this->Lang('notplayed')=>'NOPLAY',
	$this->Lang('played')=>'PLAY');

// Prepare the basic statement
$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_gameschedule_score gss LEFT OUTER JOIN '
		.cms_db_prefix().'module_tss_leagues lea ON gss.league_id = lea.league_id';

// Set where clause
$query .= ' WHERE gss_id > 0';

switch ($usedfuture) {
	case 'PLAY':
		$query .= ' AND hometeam_score <> \'\'';
		break;
	case 'NOPLAY':
		$query .= ' AND hometeam_score = \'\'';
		break;
	default:
		break;
}

// Select the hometeam (if one selected)
if ($usedhometeam != $this->Lang('allteams') && $usedhometeam != '0') {
	$query .= ' AND hometeam = \''. $usedhometeam.'\'';
}

// Select the visitorteam (if one selected)
if ($usedvisitorteam != $this->Lang('allteams') && $usedvisitorteam != '0') {
	$query .= ' AND visitorteam = \''. $usedvisitorteam.'\'';
}
// Select the leaguename (if one selected)
if ($usedleaguename != $this->Lang('allleagues') && $usedleaguename != '0') {
	$query .= ' AND name = \''. $usedleaguename.'\'';
}
// Select date range
if ( substr($datefrom, 1, 10) != substr($dateto, 1, 10)) {
	$query .= ' AND date BETWEEN "'.$datefrom.'" AND "'.$dateto.'"';
}

// Set order by
switch ($sortby) {
	case 'sb_hometeam':
		$query .= ' ORDER by hometeam';
		break;
	case 'sb_visitorteam':
		$query .= ' ORDER by visitorteam';
		break;
	case 'sb_leaguename':
		$query .= ' ORDER by name';
		break;
	case 'sb_matchdate':
		$query .= ' ORDER by date';
		break;
	default:
		$query .= ' ORDER by gss_id';
} 

// Sequence
$query .= ' '.$sequence;

// Complete SQL statement is now build and thus w're able to run it
$dbresult = $db->Execute($query);

// Using the front end language would make it possible to use set localle, 
// which would translate month names. But no not with smarty.
// code left inside for maybe later update
$frontendlang = get_site_preference('frontendlang','');
if ($frontendlang != '')
{
	@setlocale(LC_ALL, $frontendlang);
}

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['gss_id'];
	$onerow->hometeam = $this->CreateLink($id, 'editmatch', $returnid, $row['hometeam'], array('gss_id'=>$row['gss_id']));
	$onerow->visitorteam = $this->CreateLink($id, 'editmatch', $returnid, $row['visitorteam'], array('gss_id'=>$row['gss_id']));
	$onerow->matchdate = $row['date'];
	
	if ($row['hometeam_score'] != NULL) {
		if ($row['hometeam_score'] != 'C') {
			$onerow->match_score = $row['hometeam_score'].' - '.$row['visitorteam_score'];
		}
		else {
			// This match has been canceled (due to flood, snow or other reason)
			$onerow->match_score = $this->Lang('cancelledcode');
		}
	}
	else {
		$onerow->match_score = $this->Lang('noscoreavailable');
	}
	$onerow->league_name = $row['name'];

	// Show the icons needed for editing, deleting
	$onerow->editlink = $this->CreateLink($id, 'editmatch', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('gss_id'=>$row['gss_id']));
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Matches','gss_id'=>$row['gss_id']), $this->Lang('areyousurematch'));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$smarty->assign('formstart', $this->CreateFormStart($id, 'defaultadmin', $returnid, $params));

$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));
if (count($entryarray) == 0) {
	$smarty->assign('message', $this->Lang('nomatchfound'));
}

#Setup links
$smarty->assign('addmatchlink', $this->CreateLink($id, 'addmatch', $returnid, $this->Lang('addmatch'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addmatchlink', $this->CreateLink($id, 'addmatch', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addmatch'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addmatch', $returnid, $this->Lang('addmatch'), array(), '', false, false, 'class="pageoptions"'));

$smarty->assign('matchfiltertitle', $this->Lang('matchfiltertitle'));
$smarty->assign('hometeamidinput', $this->CreateInputDropdown($id, 'hometeam', $hometeamlist, -1, $usedhometeam));
$smarty->assign('visitorteamidinput', $this->CreateInputDropdown($id, 'visitorteam', $visitorteamlist, -1, $usedvisitorteam));
$smarty->assign('leaguenameinput', $this->CreateInputDropdown($id, 'leaguename', $leagueslist, -1, $usedleaguename));
$smarty->assign('datefromtitle', $this->Lang('matchdatefrom'));
$smarty->assign_by_ref('datefrom', $datefrom);
$smarty->assign('datefromprefix', $id.'datefrom_');
$smarty->assign('datetotitle', $this->Lang('matchdateto'));
$smarty->assign_by_ref('dateto', $dateto);
$smarty->assign('datetoprefix', $id.'dateto_');
$smarty->assign('sortmatchbytitle', $this->Lang('matchsortbytitle'));
$smarty->assign('sortmatchbyinput', $this->CreateInputDropdown($id, 'sortby', $sortbylist, -1, $sortby));
$smarty->assign('matchsequenceinput', $this->CreateInputDropdown($id, 'sequence', $sequencelist, -1, $sequence));
$smarty->assign('futurematchonlytitle',$this->Lang('futurematchonlytitle'));
$smarty->assign('futurematchonlyinput', $this->CreateInputRadioGroup($id, 'future', $matchtypes, $usedfuture));

$smarty->assign('titlehometeam', $this->Lang('title_hometeam'));
$smarty->assign('titlevisitorteam', $this->Lang('title_visitorteam'));
$smarty->assign('titlematchdate', $this->Lang('title_matchdate'));
$smarty->assign('titlescore', $this->Lang('title_score'));
$smarty->assign('titleleaguename', $this->Lang('title_leaguename'));

$params['active_tab'] = 'matches';

$smarty->assign('submitfilter', $this->CreateInputSubmit($id,'submitfilter',$this->Lang('submit')));
$smarty->assign('submitreset', $this->CreateInputSubmit($id,'submitreset',$this->Lang('reset')));

$smarty->assign('formend', $this->CreateFormEnd());
// Display template
echo $this->ProcessTemplate('listmatches.tpl');

?>
