<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function deletes a row based upon parameters
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
switch ($params['table'])
{
	case 'Associations':
		$association_id = $params['association_id'];
		// Reset all the member to no team situation
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_member
						WHERE team_id IN
							(SELECT team_id FROM '.cms_db_prefix().'module_tss_team
							 WHERE club_id IN
							 (SELECT club_id FROM  '.cms_db_prefix().'module_tss_club
							  WHERE association_id = ?))';
		$dbresult = $db->Execute( $query, array($association_id) );
		if ($dbresult) {
		  $query = 'UPDATE '.cms_db_prefix().'module_tss_member set team_id=0
							WHERE team_id IN
								(SELECT team_id FROM '.cms_db_prefix().'module_tss_team
								 WHERE club_id IN
								 (SELECT club_id FROM  '.cms_db_prefix().'module_tss_club
								  WHERE association_id = ?))';
		  $db->Execute($query, array($association_id) );
		}
		// Remove any connected teams
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_team WHERE club_id in ' .
		   '(SELECT club_id FROM  '.cms_db_prefix().'module_tss_club WHERE association_id = ?)';
		$row = $db->GetRow( $query, array($association_id));
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_team WHERE club_id in ' .
				'(SELECT club_id FROM '.cms_db_prefix().'module_tss_club WHERE association_id = ?)';
			$db->Execute($query, array($association_id));
		}
		
		// Remove the connected clubs
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_club WHERE association_id = ? and club_id <> 0';
		$row = $db->GetRow( $query, array($association_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_club WHERE association_id = ? and club_id <> 0';
			$db->Execute($query, array($association_id) );
		}
		
		// Remove the association
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_association WHERE association_id = ?';
		$row = $db->GetRow($query, array($association_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_association WHERE association_id = ?';
			$db->Execute($query, array($association_id) );
			@$this->SendEvent('OnAssociationDeleted', array('association_id' => $association_id, 'description' => $row['description']));
		
			$params = array('tab_message'=> 'associationdeleted', 'active_tab' => 'associations');
		}
		break;
	case 'Clubs':
		$club_id = $params['club_id'];
		/*
		// Reset all the member to no team situation
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_member WHERE team_id IN (SELECT team_id FROM '
			 .cms_db_prefix().'module_tss_team WHERE club_id = ?)';
		$row = $db->GetRow( $query, array($club_id) );
		if ($row) {
			$query = 'UPDATE '.cms_db_prefix().'module_tss_member set team_id=0 WHERE team_id IN (SELECT team_id FROM '
			 .cms_db_prefix().'module_tss_team WHERE club_id = ?)';
			$db->Execute($query, array($club_id) );
		}
		*/
		// Remove any connected teams
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_team WHERE club_id = ?';
		$row = $db->GetRow( $query, array($club_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_team WHERE club_id = ?';
			$db->Execute($query, array($club_id) );
		}
		
		// Remove the club
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_club WHERE club_id = ?';
		$row = $db->GetRow( $query, array($club_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_club WHERE club_id = ?';
			$db->Execute($query, array($club_id) );
			@$this->SendEvent('OnclubDeleted', array('club_id' => $club_id, 'description' => $row['description']));
		
			$params = array('tab_message'=> 'clubdeleted', 'active_tab' => 'clubs');
		}
		
		break;
	case 'FieldDefs':
		$fd_id = $params['fd_id'];
		// Remove the field definition
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_fielddefs WHERE fd_id = ?';
		$row = $db->GetRow( $query, array($fd_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_fielddefs WHERE fd_id = ?';
			$db->Execute($query, array($fd_id) );
			// Disconnect values from connected objects
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_fieldvals WHERE fd_id = ?';
			$db->Execute($query, array($fdid));
			
			$query = 'UPDATE '.cms_db_prefix().'module_tss_fielddefs 
				SET item_order = (item_order - 1) 
				WHERE item_order > ?';
			$db->Execute($query, array($row['item_order']));

			@$this->SendEvent('OnfielddefDeleted', array('fd_id' => $fd_id, 'name' => $row['name']));
		
			$params = array('tab_message'=> 'fielddefdeleted', 'active_tab' => 'fielddefs');
		}
		
		break;
	case 'Matches':
		$gss_id = $params['gss_id'];
		// Remove the match statistics
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_gamestats WHERE gss_id = ?';
		$dbresult = $db->Execute($query, array($gss_id) );
		while ($dbresult && $row = $dbresult->FetchRow()) {
			// Reset the points of this match
			if ($row['hplayer_goal'] > 0) {
				$hplayer_id = $row['hplayer_id'];
				$hplayer_goal = $row['hplayer_goal'];
				$query = 'UPDATE '.cms_db_prefix().'module_tss_member SET points_this_season = points_this_season - ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE member_id = ?';
				$db->Execute($query, array($hplayer_goal, $hplayer_id));
			}
			if ($row['vplayer_goal'] > 0) {
				$vplayer_id = $row['vplayer_id'];
				$vplayer_goal = $row['vplayer_goal'];
				$query = 'UPDATE '.cms_db_prefix().'module_tss_member SET points_this_season = points_this_season - ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE member_id = ?';
				$db->Execute($query, array($vplayer_goal, $vplayer_id));
			}
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_gamestats WHERE gamestat_id = ?';
			$db->Execute($query, array($row['gamestat_id']) );
		}
		// Remove the match
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_gameschedule_score WHERE gss_id = ?';
		$row = $db->GetRow($query, array($gss_id) );
		if ($row)
		{
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_gameschedule_score WHERE gss_id = ?';
			$db->Execute($query, array($gss_id) );
			@$this->SendEvent('OnMatchDeleted', array('gss_id' => $gss_id));
			
			$params = array('tab_message'=> 'matchdeleted', 'active_tab' => 'matches');
		}
		break;
	case 'MatchStats':
		$gamestat_id = $params['gamestat_id'];
		$gss_id = $params['gss_id'];
		// Remove the match statistic
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_gamestats WHERE gamestat_id = ?';
		$row = $db->GetRow($query, array($gamestat_id) );
		if ($row) {
			// Reset the points of this match
			if ($row['hplayer_goal'] > 0) {
				$hplayer_id = $row['hplayer_id'];
				$hplayer_goal = $row['hplayer_goal'];
				$query = 'UPDATE '.cms_db_prefix().'module_tss_member SET points_this_season = points_this_season - ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE member_id = ?';
				$db->Execute($query, array($hplayer_goal, $hplayer_id));
			}
			if ($row['vplayer_goal'] > 0) {
				$vplayer_id = $row['vplayer_id'];
				$vplayer_goal = $row['vplayer_goal'];
				$query = 'UPDATE '.cms_db_prefix().'module_tss_member SET points_this_season = points_this_season - ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE member_id = ?';
				$db->Execute($query, array($vplayer_goal, $vplayer_id));
			}
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_gamestats WHERE gamestat_id = ?';
			$db->Execute($query, array($gamestat_id) );
			#@$this->SendEvent('OnMatchStatDeleted', array('gamestat_id' => $gamestat_id));
			
			$params = array('tab_message'=> 'matchstatdeleted', 'gss_id' => $gss_id);
			$this->Redirect($id, 'editmatchstats', $returnid, $params);
		}
		
		break;		
	case 'Members':
		$member_id = $params['member_id'];
		// Remove the member
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_member WHERE member_id = ?';
		$row = $db->GetRow( $query, array($member_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_member WHERE member_id = ?';
			$db->Execute($query, array($member_id) );
			#@$this->SendEvent('OnmemberDeleted', array('member_id' => $member_id, 'name' => $row['first_name'.'last_name']));
			
			$params = array('tab_message'=> 'memberdeleted', 'active_tab' => 'members');
		}
		break;
	case 'Leagues':
		$league_id = $params['league_id'];
		// Remove the league
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_leagues WHERE league_id = ?';
		$row = $db->GetRow( $query, array($league_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_leagues WHERE league_id = ?';
			$db->Execute($query, array($league_id) );
			@$this->SendEvent('OnleagueDeleted', array('league_id' => $team_id, 'league_name' => $row['name']));
			
			$params = array('tab_message'=> 'leaguedeleted', 'active_tab' => 'leagues');
		}
		break;
	case 'Seasons':
		$season_id = $params['season_id'];
		// Reset all the teams to no season situation
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_team WHERE season_id = ?';
		$row = $db->GetRow( $query, array($season_id) );
		if ($row) {
			$query = 'UPDATE '.cms_db_prefix().'module_tss_team set season_id=0 WHERE season_id = ?';
			$db->Execute($query, array($season_id) );
		}
		
		// Remove the season
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_season WHERE season_id = ?';
		$row = $db->GetRow( $query, array($season_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_season WHERE season_id = ?';
			$db->Execute($query, array($season_id) );
			@$this->SendEvent('OnseasonDeleted', array('season_id' => $season_id, 'season_desc' => $row['season_desc']));
			
			$params = array('tab_message'=> 'seasondeleted', 'active_tab' => 'seasons');
		}
		break;
	case 'Teams':
		$team_id = $params['team_id'];
		// Reset all the members to no team situation
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_member WHERE team_id = ?';
		$row = $db->GetRow( $query, array($team_id) );
		if ($row) {
			$query = 'UPDATE '.cms_db_prefix().'module_tss_member set team_id=0 WHERE team_id = ?';
			$db->Execute($query, array($team_id) );
		}
		
		// Remove the team
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_team WHERE team_id = ?';
		$row = $db->GetRow( $query, array($team_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_team WHERE team_id = ?';
			$db->Execute($query, array($team_id) );
			@$this->SendEvent('OnTeamDeleted', array('team_id' => $team_id, 'team_name' => $row['team_name']));
			
			$params = array('tab_message'=> 'teamdeleted', 'active_tab' => 'teams');
		}
		break;
	case 'Templates':
		$template_id = $params['template_id'];
		// Remove the template (no referencial check!)
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_template WHERE template_id = ?';
		$row = $db->GetRow($query, array($template_id) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_tss_template WHERE template_id = ?';
			$db->Execute($query, array($template_id) );
			$params = array('tab_message'=> 'templatedeleted', 'active_tab' => 'templates');
		}
		break;
	default:
		break;
}

// redirect the user to the default admin screen
$this->Redirect($id, 'defaultadmin', $returnid, $params);

?>