<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Build list of possible template types
$typelist = array();
$typelist[$this->Lang('league_page')] = 1;
$typelist[$this->Lang('team_page')] = 2;
$typelist[$this->Lang('summary_page')] = 3;
$typelist[$this->Lang('stats_page')] = 4;
$templatetypelist = array();
$templatetypelist = array_flip($typelist);

$query = '';
$dbresult = '';
$query = 'SELECT *
		FROM '.cms_db_prefix().'module_tss_template
		ORDER BY title';
$dbresult = $db->Execute($query);

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['template_id'];
	$onerow->title = $this->CreateLink($id, 'edittemplate', $returnid, $row['title'], array('template_id'=>$row['template_id']));
	$onerow->typename = $templatetypelist[$row['type_id']];
	$onerow->editlink = $this->CreateLink($id, 'edittemplate', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('template_id'=>$row['template_id']));
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Templates','template_id'=>$row['template_id']), $this->Lang('areyousuretemplate'));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));

// Setup links
$smarty->assign('addtemplatelink', $this->CreateLink($id, 'addtemplate', $returnid, $this->Lang('addtemplate'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addtemplatelink', $this->CreateLink($id, 'addtemplate', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addtemplate'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addtemplate', $returnid, $this->Lang('addtemplate'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('reimporttemplatelink', $this->CreateLink($id, 'reimporttemplate', $returnid, $this->Lang('reimporttemplate'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('reimporttemplatelink', $this->CreateLink($id, 'reimporttemplate', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/import.gif', $this->Lang('reimporttemplate'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'reimporttemplate', $returnid, $this->Lang('reimporttemplate'), array(), '', false, false, 'class="pageoptions"'));

$smarty->assign('titletext', $this->Lang('title'));
$smarty->assign('typetext', $this->Lang('templatetype'));

// Display the templates
echo $this->ProcessTemplate ('listtemplates.tpl');

?>
