<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$query = '';
$dbresult = '';

$listteam = array();
$listteam[$this->Lang('allteam')] = '';

$query = "SELECT t.*, c.description AS club_desc, season_desc
			 FROM "
						.cms_db_prefix()."module_tss_team t, "
						.cms_db_prefix()."module_tss_club c, "
						.cms_db_prefix()."module_tss_season s
			 WHERE t.club_id = c.club_id AND t.season_id = s.season_id
			 ORDER BY t.team_name";
$dbresult = $db->Execute($query);

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['team_id'];
	$onerow->code = $this->CreateLink($id, 'editteam', $returnid, $row['team_code'], array('team_id'=>$row['team_id']));
	$onerow->name = $this->CreateLink($id, 'editteam', $returnid, $row['team_name'], array('team_id'=>$row['team_id']));
	$onerow->smartyparm = '{... team=\''.$row['team_id'].'\' ...}';
	$onerow->season = $row['season_desc'];
	if ($row['club_id'] > 0) {
			$onerow->description = $row['club_desc'];
	} else {
		if ($id == 0) {
			$onerow->description = $this->Lang('clubnotconnected');
		} else {
			$onerow->description = $this->Lang('clubunknown');
		}
	}

	// Show the icons needed for editing, deleting
	if ($row['status'] == 'A') {
		$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
			$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('table'=>'Team','status'=>'I','record_id'=>$row['team_id']));
	}
	else {
		$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
			$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('table'=>'Team','status'=>'A','record_id'=>$row['team_id']));
	}
	$onerow->editlink = $this->CreateLink($id, 'editteam', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('team_id'=>$row['team_id']));
	if ($row['team_id'] > 0 ) {
		 $onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Teams','team_id'=>$row['team_id']), $this->Lang('areyousureteam'));
	}

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));

// Setup links
$smarty->assign('addteamlink', $this->CreateLink($id, 'addteam', $returnid, $this->Lang('addteam'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addteamlink', $this->CreateLink($id, 'addteam', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addteam'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addteam', $returnid, $this->Lang('addteam'), array(), '', false, false, 'class="pageoptions"'));

$smarty->assign('formstart', $this->CreateFormStart($id, 'defaultadmin', $returnid, $params));
$smarty->assign('teamcodetext', $this->Lang('teamcode'));
$smarty->assign('teamtext', $this->Lang('team'));
$smarty->assign('smartyteamtext', $this->Lang('title_smartyteam'));
$smarty->assign('seasontext', $this->Lang('season'));
$smarty->assign('clubtext', $this->Lang('club'));
$smarty->assign('statustext', $this->Lang('status'));
$smarty->assign('formend', $this->CreateFormEnd());

// Display template
echo $this->ProcessTemplate('listteams.tpl');

?>
