<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Prepare list of possible leagues to select from
$leaguelist = array();
$leaguelist = $this->GetListLeagues();

// Prepare the possible values of the sexes
$sexelist = array();
$sexelist = $this->GetListSexe();

// Prepare a dropdown list of where the user information is to be derived from
$usrtabledropdown = array();
$usrtabledropdown['CMSMS User table'] = 'CMSMS_USR';
if ($gCms->modules['FrontEndUsers']['installed'] == true &&
	$gCms->modules['FrontEndUsers']['active'] == true) {
	$usrtabledropdown['Front End User Table'] = 'FEU_USR';
	$smarty->assign('info_user_table', $this->Lang('info_user_table'));
}
else {
	$smarty->assign('info_user_table', $this->Lang('info_user_table_no_FEU'));
}
$usrtabledropdown[$this->Lang('usermanualentry')] = 'MAN_USR';

$smarty->assign('startform', $this->CreateFormStart ($id, 'save_admin_options', $returnid));
$smarty->assign('title_dateformat',$this->Lang('title_dateformat'));
$smarty->assign('input_dateformat', $this->CreateInputText($id, 'dateformat', $this->GetPreference('dateformat', '%x'), '50', '255'));
$smarty->assign('title_fieldset_match',$this->Lang('title_fieldset_match'));
$smarty->assign('title_default_league_id',$this->Lang('title_default_league_id'));
$smarty->assign('input_default_league_id', $this->CreateInputDropdown($id, 'default_league_id', $leaguelist, -1, $this->GetPreference('default_league_id', '')));
$smarty->assign('title_24hourclock',$this->Lang('title_24hourclock'));
$smarty->assign('input_24hourclock', $this->CreateInputCheckbox($id, 'use_24hour_clock', true, $this->GetPreference('use_24hour_clock', true)));
$smarty->assign('title_show_seconds',$this->Lang('title_show_seconds'));
$smarty->assign('input_show_seconds', $this->CreateInputCheckbox($id, 'show_seconds', true, $this->GetPreference('show_seconds', true)));
$smarty->assign('title_display0000',$this->Lang('title_display0000'));
$smarty->assign('input_display0000', $this->CreateInputCheckbox($id, 'displaytime_when_0000', true, $this->GetPreference('displaytime_when_0000', true)));
$smarty->assign('title_showstats',$this->Lang('title_showstats'));
$smarty->assign('input_showstats', $this->CreateInputCheckbox($id, 'fe_show_statistics', true, $this->GetPreference('fe_show_statistics', true)));
$smarty->assign('title_fieldset_team',$this->Lang('title_fieldset_team'));
$smarty->assign('title_default_sexes',$this->Lang('title_default_sexes'));
$smarty->assign('input_default_sexes', $this->CreateInputDropdown($id, 'default_sexes', $sexelist, -1, $this->GetPreference('default_sexes', 0)));
$smarty->assign('title_use_referree',$this->Lang('title_use_referree'));
$smarty->assign('input_use_referree', $this->CreateInputCheckbox($id, 'use_referree', true, $this->GetPreference('use_referree', false)));
$smarty->assign('title_fieldset_member',$this->Lang('title_fieldset_member'));
$smarty->assign('title_user_table', $this->Lang('title_user_table'));
$smarty->assign('input_user_table', $this->CreateInputDropdown($id, 'user_table', $usrtabledropdown, -1, $this->GetPreference('user_table', '')));
$smarty->assign('submit', $this->CreateInputSubmit ($id, 'optionssubmitbutton', $this->Lang('submit')));
$smarty->assign('endform', $this->CreateFormEnd ());

// Display the Admin options
echo $this->ProcessTemplate ('listoptions.tpl');

?>
