<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$query = '';
$dbresult = '';

$listleague = array();
$listleague[$this->Lang('allleagues')] = '';

$query = 'SELECT league_id, l.name AS leaguename, l.status AS leaguestatus, season_desc
		FROM '.cms_db_prefix().'module_tss_leagues l, '
			.cms_db_prefix().'module_tss_season s
		WHERE l.season_id = s.season_id
		ORDER BY name';
$dbresult = $db->Execute($query);

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['league_id'];
	$onerow->name = $this->CreateLink($id, 'editleague', $returnid, $row['leaguename'], array('league_id'=>$row['league_id']));
	$onerow->season = $row['season_desc'];

	// Show the icons needed for editing, deleting
	if ($row['leaguestatus'] == 'A')
		{
			$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
				$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('table'=>'League','status'=>'I','record_id'=>$row['league_id']));
		}
	else
		{
			$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
				$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('table'=>'League','status'=>'A','record_id'=>$row['league_id']));
		}
	$onerow->editlink = $this->CreateLink($id, 'editleague', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('league_id'=>$row['league_id']));
	if ($row['league_id'] > 0 ) {
			$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Leagues','league_id'=>$row['league_id']), $this->Lang('areyousureleague'));
	}
	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));

// Setup links
$smarty->assign('addleaguelink', $this->CreateLink($id, 'addleague', $returnid, $this->Lang('addleague'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addleaguelink', $this->CreateLink($id, 'addleague', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addleague'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addleague', $returnid, $this->Lang('addleague'), array(), '', false, false, 'class="pageoptions"'));

$smarty->assign('leaguetext', $this->Lang('leagues'));
$smarty->assign('seasontext', $this->Lang('season'));
$smarty->assign('statustext', $this->Lang('status'));
// Display template
echo $this->ProcessTemplate('listleagues.tpl');
?>
