<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$curclub = (isset($params['curclub'])?$params['curclub']:'');
$allclubs = (isset($params['allclubs'])?$params['allclubs']:'no');
$newclub = $curclub;

if (isset($params['submitclub']))
{
	$newclub = (isset($params['newclub'])?$params['newclub']:$newclub);
}

$query = '';
$dbresult = '';

$curclub = $newclub;
$listclub = array();
$listclub[$this->Lang('allclub')] = '';

$query = "SELECT c.*, a.description AS ass_desc FROM ".cms_db_prefix()."module_tss_club c LEFT OUTER JOIN ".cms_db_prefix()."module_tss_association a ON c.association_id = a.association_id ORDER BY c.description";
$dbresult = $db->Execute($query);

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['club_id'];
	$onerow->description = $this->CreateLink($id, 'editclub', $returnid, $row['description'], array('club_id'=>$row['club_id']));
	if ($row['association_id'] > 0) {
			$onerow->association = $row['ass_desc'];
	} else {
			$onerow->association = 'Unknown';
	}
	$onerow->smartyparm = '{... club=\''.$row['club_id'].'\' ...}';

	// Show the icons needed for editing, deleting
	if ($row['status'] == 'A')
		{
			$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
				$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('table'=>'Club','status'=>'I','record_id'=>$row['club_id']));
		}
	else
		{
			$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
				$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('table'=>'Club','status'=>'A','record_id'=>$row['club_id']));
		}
	$onerow->editlink = $this->CreateLink($id, 'editclub', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('club_id'=>$row['club_id']));
	if ($row['club_id'] > 0 ) {
			$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Clubs','club_id'=>$row['club_id']), $this->Lang('areyousureclub'));
	}
	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));

// Setup links
$smarty->assign('addclublink', $this->CreateLink($id, 'addclub', $returnid, $this->Lang('addclub'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addclublink', $this->CreateLink($id, 'addclub', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addclub'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addclub', $returnid, $this->Lang('addclub'), array(), '', false, false, 'class="pageoptions"'));

$smarty->assign('formstart', $this->CreateFormStart($id, 'defaultadmin', $returnid, $params));
$smarty->assign('clubtext', $this->Lang('club'));
$smarty->assign('smartyclubtext', $this->Lang('title_smartyclub'));
$smarty->assign('TeamSportScoreversion', $this->GetPreference('TeamSportScoreversion'));
$smarty->assign('statustext', $this->Lang('status'));
$smarty->assign('formend', $this->CreateFormEnd());

// Display template
echo $this->ProcessTemplate('listclubs.tpl');

?>
