<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$curassociation = (isset($params['curassociation'])?$params['curassociation']:'');
$allassociations = (isset($params['allassociations'])?$params['allassociations']:'no');
$newassociation = $curassociation;

if (isset($params['submitassociation']))
{
	$newassociation = (isset($params['newassociation'])?$params['newassociation']:$newassociation);
}

$curassociation = $newassociation;
$listassociation = array();
$listassociation[$this->Lang('allassociation')] = '';
$query = "SELECT * FROM ".cms_db_prefix()."module_tss_association ORDER BY description";
$dbresult = $db->Execute($query);

$rowclass = 'row1';
$row = '';
$entryarray = array();

// Prepare images that can be shown
$penaltycardnames = array();
$imageurl = '<img src="'.$config['root_url'].DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'TeamSportScores'.
	DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR;
$imagepcblack = $imageurl.'bf.png" alt="'.$penaltycardnames['BLACK'].'">';
$imagepcblue = $imageurl.'cs.png" alt="'.$penaltycardnames['BLUE'].'">';
$imagepcgreen = $imageurl.'af.png" alt="'.$penaltycardnames['GREEN'].'">';
$imagepcred = $imageurl.'cr.png" alt="'.$penaltycardnames['RED'].'">';
$imagepcwhite = $imageurl.'bw.png" alt="'.$penaltycardnames['WHITE'].'">';
$imagepcyellow = $imageurl.'be.png" alt="'.$penaltycardnames['YELLOW'].'">';
$imagenone = $imageurl.'cardnone.gif">';

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();
	$onerow->id = $row['association_id'];
	$onerow->description = $this->CreateLink($id, 'editassociation', $returnid, $row['description'], array('association_id'=>$row['association_id']));
	$onerow->maxperiods = $row['maxperiods'];
	$onerow->periodheading = $row['periodheading'];
	if ($row['penaltycardblack'] == '1') {
		$onerow->pcblack = $imagepcblack;
	}
	else {
		$onerow->pcblack = $imagenone;
	}
	if ($row['penaltycardblue'] == '1') {
		$onerow->pcblue = $imagepcblue;
	}
	else {
		$onerow->pcblue = $imagenone;
	}
	if ($row['penaltycardgreen'] == '1') {
		$onerow->pcgreen = $imagepcgreen;
	}
	else {
		$onerow->pcgreen = $imagenone;
	}
	if ($row['penaltycardred'] == '1') {
		$onerow->pcred = $imagepcred;
	}
	else {
		$onerow->pcred = $imagenone;
	}
	if ($row['penaltycardwhite'] == '1') {
		$onerow->pcwhite = $imagepcwhite;
	}
	else {
		$onerow->pcwhite = $imagenone;
	}
	if ($row['penaltycardyellow'] == '1') {
		$onerow->pcyellow = $imagepcyellow;
	}
	else {
		$onerow->pcyellow = $imagenone;
	}
	// Show the icons needed for editing, deleting
	$onerow->editlink = $this->CreateLink($id, 'editassociation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('association_id'=>$row['association_id']));
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Associations','association_id'=>$row['association_id']), $this->Lang('areyousureassociation'));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));

// Setup links
$smarty->assign('addassociationlink', $this->CreateLink($id, 'addassociation', $returnid, $this->Lang('addassociation'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addassociationlink', $this->CreateLink($id, 'addassociation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addassociation'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addassociation', $returnid, $this->Lang('addassociation'), array(), '', false, false, 'class="pageoptions"'));

$smarty->assign('associationtext', $this->Lang('association'));
$smarty->assign('titlemaxperiods', $this->Lang('title_maxperiods'));
$smarty->assign('titleperiodheading', $this->Lang('periodheading'));
$smarty->assign('titlepcblack', $this->Lang('title_pcblack'));
$smarty->assign('titlepcblue', $this->Lang('title_pcblue'));
$smarty->assign('titlepcgreen', $this->Lang('title_pcgreen'));
$smarty->assign('titlepcred', $this->Lang('title_pcred'));
$smarty->assign('titlepcwhite', $this->Lang('title_pcwhite'));
$smarty->assign('titlepcyellow', $this->Lang('title_pcyellow'));

// Display template
echo $this->ProcessTemplate('listassociations.tpl');

?>
