<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

#The tabs
if (FALSE == empty($params['active_tab']))
{
	$tab = $params['active_tab'];
} else {
	$tab = 'matches';
}

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}

$TeamSportScoreversion = $this->GetPreference('TeamSportScoreversion');

echo $this->StartTabHeaders();
	if ($this->CheckPermission('Modify TeamSportScores')) {
		echo $this->SetTabHeader('matches',$this->Lang('matches'), ('matches' == $tab)?true:false);
		echo $this->SetTabHeader('associations',$this->Lang('associations'), ('associations' == $tab)?true:false);
		echo $this->SetTabHeader('clubs',$this->Lang('clubs'), ('clubs' == $tab)?true:false);
		echo $this->SetTabHeader('teams',$this->Lang('teams'), ('teams' == $tab)?true:false);
		echo $this->SetTabHeader('members',$this->Lang('members'), ('members' == $tab)?true:false);
		echo $this->SetTabHeader('leagues',$this->Lang('leagues'), ('leagues' == $tab)?true:false);
		echo $this->SetTabHeader('seasons',$this->Lang('seasons'), ('seasons' == $tab)?true:false);
	}
	if ($this->CheckPermission('Modify Templates')) {
		echo $this->SetTabHeader('templates',$this->Lang('templates'), ('templates' == $tab)?true:false);
	}
	if ($this->CheckPermission('Modify Site Preferences')) {
		echo $this->SetTabHeader('options',$this->Lang('options'), ('options' == $tab)?true:false);
	}
	if ($TeamSportScoreversion == 'silver') {
		echo $this->SetTabHeader('silveroptions',$this->Lang('title_optionssilver'), ('silveroptions' == $tab)?true:false);
		echo $this->SetTabHeader('fielddefs',$this->Lang('title_fielddefs'), ('fielddefs' == $tab)?true:false);
	}
echo $this->EndTabHeaders();

# The content of the tabs
echo $this->StartTabContent();
	// --- Start tab Matches ---
	echo $this->StartTab('matches', $params);
	if ($this->CheckPermission('Modify TeamSportScores')) {
		include(dirname(__FILE__).'/function.admin_matchestab.php');
	}

	echo $this->EndTab();
	// --- End tab Matches ---

	// --- Start tab Associations ---
	echo $this->StartTab('associations', $params);
	if ($this->CheckPermission('Modify TeamSportScores')) {
		include(dirname(__FILE__).'/function.admin_associationstab.php');
	}

	echo $this->EndTab();

	// --- End tab Associations ---

	// --- Start tab Clubs ---
	echo $this->StartTab('clubs', $params);
	if ($this->CheckPermission('Modify TeamSportScores')) {
		include(dirname(__FILE__).'/function.admin_clubstab.php');
	}

	echo $this->EndTab();
	// --- End tab Clubs ---
	
	// --- Start tab Teams ---
	echo $this->StartTab('teams', $params);
	if ($this->CheckPermission('Modify TeamSportScores')) {
		include(dirname(__FILE__).'/function.admin_teamstab.php');
	}

	echo $this->EndTab();
	// --- End tab Teams ---
	
	// --- Start tab Members ---
	echo $this->StartTab('members', $params);
	if ($this->CheckPermission('Modify TeamSportScores')) {
		include(dirname(__FILE__).'/function.admin_memberstab.php');
	}

	echo $this->EndTab();
	// --- End tab Member ---

	// --- Start tab Leagues ---
	echo $this->StartTab('leagues', $params);
	if ($this->CheckPermission('Modify TeamSportScores')) {
		include(dirname(__FILE__).'/function.admin_leaguestab.php');
	}

	echo $this->EndTab();
	// --- End tab leagues ---	

	// --- Start tab Seasons ---
	echo $this->StartTab('seasons', $params);
	if ($this->CheckPermission('Modify TeamSportScores')) {
		include(dirname(__FILE__).'/function.admin_seasonstab.php');
	}

	echo $this->EndTab();
	// --- End tab Seasons ---

	// --- Start tab Templates ---
	echo $this->StartTab('templates', $params);
	if ($this->CheckPermission('Modify Templates')) {
		include(dirname(__FILE__).'/function.admin_templatestab.php');
	}
	
	echo $this->EndTab();
	// --- End tab Templates ---

	// --- Start tab Options ---
	echo $this->StartTab('options', $params);
	if ($this->CheckPermission('Modify Site Preferences')) {
		// Display the options
		include(dirname(__FILE__).'/function.admin_optionstab.php');
	}
	
	echo $this->EndTab();
	// --- End tab Options ---

	switch ($TeamSportScoreversion)
	{
		case 'gold':
			// --- Start tab Gold ---
			echo $this->StartTab('goldoptions', $params);
			
			echo $this->Lang('nogoldoptions');
		
			echo $this->EndTab();
			// --- End tab Gold ---
			// When Gold version in use, all Silver extensions included 
			//break;
		case 'silver':
			// --- Start tab Silver ---
			echo $this->StartTab('silveroptions', $params);
			$ap = cms_join_path(dirname(__FILE__),'silver','silver.admin_optionstab.php');
			if( file_exists( $ap ) )
			{
				include_once $ap;
			}
			else {
				echo $this->Lang('nosilveroptions');
			}
			echo $this->EndTab();
			
			echo $this->StartTab('fielddefs', $params);
			$ap = cms_join_path(dirname(__FILE__),'silver','silver.admin_fielddefstab.php');
			if( file_exists( $ap ) )
			{
				include_once $ap;
			}
			else {
				echo $this->Lang('nofielddefinitions');
			}
			#Display template
			echo $this->ProcessTemplate('listfielddefs.tpl');
			echo $this->EndTab();
			// --- End tab Silver ---
			break;
	}

echo $this->EndTabContent();

?>