<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown
#
# This function will handle adding a club
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
$db = cmsms()->GetDb();

if (!$this->CheckPermission('Modify TeamSportScores'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Modify TeamSportScores')));
	return;
}

$usedassociation = '';
if (isset($params['association_id'])) {
	$usedassociation = $params['association_id'];
}

$logo = '';
if (isset($params['logo'])) {
	// The logo contains both the path as well as the filename when returning
	// abstract the filename to save
	$logo = end(explode("/", $params['logo']));
}

$image = '';
if (isset($params['image'])) {
	$image = end(explode("/", $params['image']));
}

$status = 'A';
if (isset($params['status'])) {
	$status = $params['status'];
}

if (isset($params['cancel'])) {
	$params = array('active_tab' => 'clubs');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$desc = '';
if (isset($params['description'])) {
	$desc = $params['description'];
	if ($desc != '') {
		$clubid = $db->GenID(cms_db_prefix()."module_tss_club_seq");
		$time = $db->DBTimeStamp(time());
		$query = 'INSERT INTO '.cms_db_prefix().'module_tss_club (club_id, description, 
			association_id, status, image, logo, create_date, modified_date)
			VALUES (?,?,?,?,?,?,'.$time.','.$time.')';
		$db->Execute($query, array($clubid, $desc, $usedassociation, $status, $image, $logo));

		@$this->SendEvent('ClubAdded', array('club_id' => $assid, 'description' => $desc));

		$params = array('tab_message'=> 'clubadded', 'active_tab' => 'clubs');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else {
		echo $this->ShowErrors($this->Lang('noclubdescgiven'));
	}
}
// Include the option to set logo and image of club
$fn = cms_join_path(dirname(__FILE__),'silver','silver.clubmedia.php');
if (file_exists($fn)) {
	include_once($fn);
}

$statusdropdown = array();
$statusdropdown[$this->Lang('status_active')] = 'A';
$statusdropdown[$this->Lang('status_inactive')] = 'I';

// Prepare a list of the associations
$associationlist = array();
$associationlist = $this->GetListAssociations();

#Display template
$smarty->assign('startform', $this->CreateFormStart($id, 'addclub', $returnid, 'post', 
	'multipart/form-data', '', '', array('a'=>'a'), 'name="clubmedia"'));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('nametext', $this->Lang('clubdescription'));
$smarty->assign('inputname', $this->CreateInputText($id, 'description', $desc, 40, 40));
$smarty->assign('associationtext', $this->Lang('association'));
$smarty->assign('inputassociation', $this->CreateInputDropdown($id, 'association_id', $associationlist, -1, $usedassociation));
$smarty->assign('statustext', $this->Lang('status'));
$smarty->assign('inputstatus', $this->CreateInputDropdown($id, 'status', $statusdropdown, -1, $status));
$smarty->assign('TeamSportScoreversion', $this->GetPreference('TeamSportScoreversion'));
$smarty->assign('hidden', '');
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editclub.tpl');
?>
