<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown
#
# This function will install the module Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
 
class TeamSportScores extends CMSModule
{

	function GetName()
	{
		return 'TeamSportScores';
	}

	function GetFriendlyName()
	{
		// Set the version in a preference, for speed and check in various other 
		// team sport score programs
		$this->SetPreference('TeamSportScoreversion', 'free');
		$fn = cms_join_path(dirname(__FILE__),'gold');
		if (file_exists( $fn ) ) {
			$this->SetPreference('TeamSportScoreversion', 'gold');
			return $this->Lang('friendlynamegold');
		}
		$fn = cms_join_path(dirname(__FILE__),'silver');
		if (file_exists( $fn ) ) {
			$this->SetPreference('TeamSportScoreversion', 'silver');
			return $this->Lang('friendlynamesilver');
		}
		return $this->Lang('friendlyname');
	}

	function GetVersion()
	{
		return '1.1.9';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Duketown';
	}

	function GetAuthorEmail()
	{
		return '';
	}

	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.inc');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}

	function GetAdminSection()
	{
		return 'extensions';
	}

	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}

	function VisibleToAdminUser()
	{
        return $this->CheckPermission('Use TeamSportScores');
	}

	function GetDependencies()
	{
	  return array('CGExtensions'=>'1.23');
	}

	function MinimumCMSVersion()
	{
		return '1.8.1';
	}

	function MaximumCMSVersion()
	{
		return '1.9.9';
	}
	
	function SetParameters()
	{
		# The top most parameter will be first in helptext (so mentioned here alphabetical)
		$this->CreateParameter('cancelledcode', '', $this->Lang('helpcancelled'));
		$this->CreateParameter('club', '', $this->Lang('helpclub'));
		$this->CreateParameter('dateformat', 'F j, Y, g:i a', $this->Lang('helpdateformat'));
		$this->CreateParameter('display', '', $this->Lang('helpdisplay'));
		$this->CreateParameter('league', '', $this->Lang('helpleague'));
		$this->CreateParameter('member', '', $this->Lang('helpmember'));
		$this->CreateParameter('matchlimit', '', $this->Lang('helpmatchlimit'));
		$this->CreateParameter('noheading', '', $this->Lang('helpnoheading'));
		$this->CreateParameter('noscorecode', '', $this->Lang('helpnoscorecode'));
		$this->CreateParameter('orderby', '', $this->Lang('helporderby'));
		$this->CreateParameter('played', '', $this->Lang('helpplayed'));
		$this->CreateParameter('showlocation', '1', $this->Lang('helpshowlocation'));
		$this->CreateParameter('sortorder', '', $this->Lang('helpsortorder'));
		$this->CreateParameter('team', '', $this->Lang('helpteam'));
		$this->CreateParameter('teamlength', '50', $this->Lang('helpteamlength'));
		$this->CreateParameter('template', '', $this->Lang('helptemplate'));
		$this->CreateParameter('templatereport', '', $this->Lang('helptemplatereport'));
		$this->CreateParameter('templatestats', '', $this->Lang('helptemplatestats'));
		$this->CreateParameter('timeformat', 'g:i a', $this->Lang('helptimeformat'));
	}


	/*---------------------------------------------------------
	   GetHeaderHTML()
	   This function inserts javascript (and links) into header of HTML
	  ---------------------------------------------------------*/
	function GetHeaderHTML()
	{
		$javascript = '';
		// Include javascript so easy date selection is possible
		$javascript .= '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"></script>';
		$javascript .= '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/jquery-ui.min.js"></script>';
		$javascript .= '<link type="text/css" rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/themes/smoothness/jquery-ui.css" />';

		$javascript .= '<script type="text/javascript">
			$(document).ready(function() {
				$(function() {$(\'div.datepicker input\').datepicker({dateFormat: \''.$this->GetPreference('dateformat', 'd-m-yy').'\'});});
				});
				</script>';
		// Include script so sorting of tables in backend is possible
		$javascript .= '<script type="text/javascript" src="../modules/JQueryTools/lib/jquery.tablesorter.js"></script>'."\n";
		$javascript .= '<link rel="stylesheet" type="text/css" href="../modules/JQueryTools/lib/css/JQueryTools.css" media="screen" />'."\n";
		$javascript .= '<script type="text/javascript" id="js">jQuery(document).ready(function() 
		{ 
			jQuery(".cms_sortable")
				.tablesorter( 
				); 
		} 
		); 
		</script>';
		return $javascript;
	}

	function GetEventDescription ( $eventname )
	{
		return $this->Lang('event_info_'.$eventname );
	}


	function GetEventHelp ( $eventname )
	{
		return $this->Lang('event_help_'.$eventname );
	}

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}
	
	function DisplayErrorPage($id, &$params, $returnid, $message='')
	{
		$this->smarty->assign('title_error', $this->Lang('error'));
		if ($message != '')
			{
				$this->smarty->assign_by_ref('message', $message);
			}

	    // Display the populated template
	    echo $this->ProcessTemplate('error.tpl');
	}

	function DisplayAdminNav($id, &$params, $returnid) {
		$this->smarty->assign('admin_nav',
			$this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('title_mod_admin'), array()) .
			' : ' .
			$this->CreateLink($id, 'admin_prefs', $returnid, $this->Lang('title_mod_prefs'), array()));
	}


	/* --------------------------------------------------------
		DecodeDropdownData($str)
		A function to return all possible dropdown values in an array
		--------------------------------------------------------*/	
	function DecodeDropdownData($str)
	{
		$tmp = explode("\n",$str);
		$tmp2 = array();
		for( $i = 0; $i < count($tmp); $i++ )
		{
			if( strpos($tmp[$i],'=') === FALSE )
			{
				$tmp2[$tmp[$i]] = $tmp[$i];
			}
			else {
				list($okey,$ovalue) = explode('=',$tmp[$i],2);
				$tmp2[$ovalue] = $okey;
			}
		}
		return $tmp2;
	}

	/* --------------------------------------------------------
		GetDateformats()
		A function to return all possible date formats in an array
		--------------------------------------------------------*/	
	function GetDateformats()
	{
		$dateformatlist = array();
		$dateformatlist['d-m-Y'] = 'd-m-yy';
		$dateformatlist['m-d-Y'] = 'm-d-yy';
		
		return $dateformatlist;
	}

	/* --------------------------------------------------------
		GetListAssociations()
		A function to return all associations in an array
		--------------------------------------------------------*/	
	function GetListAssociations()
	{
		// Initialize the Database
		$db = cmsms()->GetDb();
		
		$associationlist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_association 
			ORDER BY description';
		$dbresult = $db->Execute($query);
		
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$associationlist[$row['description']] = $row['association_id'];
		}
		
		return $associationlist;
	}

	/* --------------------------------------------------------
		GetListBelongsto()
		A function to return all tables that it can belong to in an array
		--------------------------------------------------------*/	
	function GetListBelongsto()
	{
		  return array($this->Lang('title_members') => 'members',
			   $this->Lang('title_teams') => 'teams',
			   $this->Lang('title_clubs') => 'clubs',
			   $this->Lang('title_leagues') => 'leagues');
	}

	/* --------------------------------------------------------
		GetListClubs($status = 'A')
		A function to return all clubs in an array
		A status of '%' means all clubs will be listed
		--------------------------------------------------------*/	
	function GetListClubs($status = 'A')
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$clublist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_club';
		$query .= ' WHERE status = ?';
		$query .= ' ORDER BY description';
		$dbresult = $db->Execute($query, array($status));
		
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$clublist[$row['description']] = $row['club_id'];
		}
		return $clublist;
	}		

	/* --------------------------------------------------------
		GetListFieldDefs($admin = false, $belongsto='', $public = true)
		A function to return all field definitions in an array
		$admin can be either true or false, where true would returns all
		$belongsto can contain the type of fielddef
		$public if set to false only non public field definitions are returned
		--------------------------------------------------------*/	
	function GetListFieldDefs($admin = false, $belongsto='', $public = true)
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$fielddeflist = array();
		if( $admin == true && $public == true )
		  {
			// All fields.
			$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_fielddefs';
			$query .= ' WHERE 1=1';
		  }
		else if( $public == true )
		  {
			// public fields only.
			$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_fielddefs 
				WHERE public > 0';
		  }
		else
		  {
			// non-admin fields.
			$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_fielddefs 
				WHERE admin_only <= 0';
		  }
		$query .= ' AND belongsto LIKE "%' . $belongsto .'"';
		$query .= ' ORDER BY name';
		$dbresult = $db->Execute($query);

		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$onerow = new stdClass();
			
			$onerow->fd_id = $row['fd_id'];
			$onerow->name = $row['name'];
			$onerow->type = $row['type'];
			$onerow->max_length = $row['max_length'];
			$onerow->dropdown_data = $row['dropdown_data'];
			$fielddeflist[] = $onerow;
		}
		
		return $fielddeflist;
	}

	/* --------------------------------------------------------
		GetFieldDefsFor($belongsto, $ext_id, $admin = false, $public = true)
		A function to return all values of fields in an array
		$belongsto can contain the type of fielddef
		$ext_id is foreign key to connected table
		$admin can be either true or false, where true would returns all
		$public if set to false only non public field definitions are returned
		--------------------------------------------------------*/	
	function GetFieldDefsFor($belongsto, $ext_id, $admin = false, $public = true)
	{
		// Initialize the Database
		$db = cmsms()->GetDb();
		
		$entryarray = array();
		$entryarray = $this->GetListFieldDefs($admin, $belongsto, $public);

		$query = '';
		if( $admin == true && $public == true )
		  {
			$query = 'SELECT fv.* FROM '.cms_db_prefix().'module_tss_fieldvals fv 
				WHERE fv.ext_id = ?';
		  }
		else if( $public == true )
		  {
			$query = 'SELECT b.* FROM '.cms_db_prefix().'module_tss_fielddefs a,
				'.cms_db_prefix().'module_tss_fieldvals b WHERE a.fd_id = b.fd_id 
				AND a.public > 0 and b.ext_id = ?';
		  }
		else 
		  {
			$query = 'SELECT b.* FROM '.cms_db_prefix().'module_tss_fielddefs a,
				'.cms_db_prefix().'module_tss_fieldvals b WHERE a.fd_id = b.fd_id 
				AND a.admin_only <= 0 and b.ext_id = ?';
		  }
		$query .= ' AND belongsto LIKE "%' . $belongsto .'"';
		$dbresult = $db->Execute($query, array($ext_id));

		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$count = 0;
			foreach ($entryarray as $field)
			{
				if ($row['fd_id'] == $field->fd_id)
				{
					$entryarray[$count]->fd_id = $field->fd_id;
					$entryarray[$count]->ext_id = $ext_id;
					$entryarray[$count]->value = $row['value'];
				}
				$count++;
			}
		}
		
		return $entryarray;
	}

	/* --------------------------------------------------------
		GetListFieldTypes()
		A function to return all type of fields in an array
		--------------------------------------------------------*/	
	function GetListFieldTypes()
	{
	  return array('textbox'  => $this->Lang('field_textbox'),
				   'checkbox' => $this->Lang('field_checkbox'),
				   'textarea' => $this->Lang('field_textarea'),
				   'dropdown' => $this->Lang('field_dropdown'),
				   'image' => $this->Lang('field_image'));
	}

	/* --------------------------------------------------------
		GetListLeagues($status = 'A')
		A function to return all leagues in an array
		A status of '%' means all leagues will be listed
		--------------------------------------------------------*/	
	function GetListLeagues($status = 'A')
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$leaguelist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_leagues';
		$query .= ' WHERE status LIKE ?';
		$query .= ' ORDER BY name';
		$dbresult = $db->Execute($query, array($status));
		
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$leaguelist[$row['name']] = $row['league_id'];
		}
		return $leaguelist;
	}		

	/* --------------------------------------------------------
		GetListSeasons($status = 'A')
		A function to return all seasons in an array
		A status of '%' means all seasons will be listed
		--------------------------------------------------------*/	
	function GetListSeasons($status = 'A')
	{
		// Initialize the Database
		$db = cmsms()->GetDb();
		
		$seasonlist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_season';
		$query .= ' WHERE status LIKE ?';
		$query .= ' ORDER BY start_date desc';
		$dbresult = $db->Execute($query, array($status));
		
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$seasonlist[$row['season_desc']] = $row['season_id'];
		}
		
		return $seasonlist;
	}

	/* --------------------------------------------------------
		GetListSexe()
		A function to return all types of sexe in an array
		--------------------------------------------------------*/	
	function GetListSexe()
	{
		$sexelist = array();
		$sexelist[$this->Lang('male')] = 'MALE';
		$sexelist[$this->Lang('female')] = 'FEMALE';
		$sexelist[$this->Lang('both')] = 'BOTH';

		return $sexelist;
	}		

	/* --------------------------------------------------------
		GetListTeams($status = 'A', $extra = '')
		A function to return all teams in an array
		A status of '%' means all teams will be listed
		Use parameter $extra if you want to add a list of specific statusses or All
		--------------------------------------------------------*/	
	function GetListTeams($status = 'A', $extra = '')
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$teamlist = array();
		if (isset($extra) && $extra != '') {
			foreach ($extra as $team => $description) {
				$teamlist[$description] = $team;
			}
		}
		$query = 'SELECT * FROM '.cms_db_prefix().'module_tss_team';
		$query .= ' WHERE status LIKE ?';
		$query .= ' ORDER BY team_name';
		$dbresult = $db->Execute($query, array($status));
		
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$teamlist[$row['team_name']] = $row['team_id'];
		}
		return $teamlist;
	}

}

?>
