<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgfbuserdata
{
  public function construct() {}

  /**
   * Initialize cgfbuserdata smarty plugins.
   *
   * @access private
   */
  public static function init()
  {
    $smarty = cmsms()->GetSmarty();
    $smarty->register_function('cgfbuserdata_get',array('cgfbuserdata','get'));
    $smarty->register_function('cgfbuserdata_set',array('cgfbuserdata','set'));
    $smarty->register_function('cgfbuserdata_erase',array('cgfbuserdata','erase'));
    $smarty->register_function('cgfbuserdata_eraseuser',array('cgfbuserdata','eraseuser'));
    $smarty->register_function('cgfbuserdata_appfriends',array('cgfbuserdata','appfriends'));
  }


 
  /**
   * Get all data from the database associated with the specified facebook user
   * usage: {cgfbuserdata_get uid=<string> [assign=<string>]}
   */
  public static function get($params,&$smarty)
  {
    $uid = get_parameter_value($params,'uid');
    if( !$uid ) return;

    $db = cmsms()->GetDb();
    $obj = new AssocData($db,'cgfbapp');
    $data = $obj->Get($uid);
    
    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$data);
	return;
      }
    return $data;
  }


  // {cgfbuserdata_set uid=abcdefg key='a.b.c.d' val='foo'}
  public static function set($params,&$smarty)
  {
    $uid = get_parameter_value($params,'uid');
    $key = get_parameter_value($params,'key');
    $val = get_parameter_value($params,'val');

    if( !$uid || !$key || !$val ) return;

    // get the data
    $data = self::get(array('uid'=>$uid));
    $tmp = explode('.',$key);
    if( !$data ) $data = array();
    $rec =& $data;
    if( count($tmp) > 1 )
      {
	for( $i = 0; $i < count($tmp) - 1; $i++ )
	  {
	    if( !isset($rec[$tmp[$i]]) )
	      {
		$rec[$tmp[$i]] = array();
	      }
	    $rec =& $rec[$tmp[$i]];
	  }
      }
    $rec[$tmp[count($tmp)-1]] = $val;
    debug_to_log($data,'cgfbuserdata_set');

    $db = cmsms()->GetDb();
    $obj = new AssocData($db,'cgfbapp');
    $obj->Set($uid,$data);
  }


  // {cgfbuserdata_erase uid=abcdef key='a.b.c.d'}
  public static function erase($params,&$smarty)
  {
    $uid = get_parameter_value($params,'uid');
    $key = get_parameter_value($params,'key');
    if( !$uid || !$key ) return;

    $data = self::get(array('uid'=>$uid));
    $tmp = explode('.',$key);
    $rec =& $data;
    if( count($tmp) > 1 )
      {
	for( $i = 0; $i < count($tmp) - 1; $i++ )
	  {
	    if( !isset($rec[$tmp[$i]]) )
	      {
		// nothing to do, key doesn't exist.
		return;
	      }
	    $rec =& $rec[$tmp[$i]];
	  }
      }
    unset($rec[$tmp[count($tmp)-1]]);

    debug_to_log($data,'cgfbuserdata_delete');
    $db = cmsms()->GetDb();
    $obj = new AssocData($db,'cgfbapp');
    if( count($tmp) )
      {
	$obj->Set($uid,$data);
      }
    $obj->Delete($uid);
  }


  public static function eraseuser($params,&$smarty)
  {
    $uid = get_parameter_value($params,'uid');
    if( !$uid ) return;

    $db = cmsms()->GetDb();
    $obj = new AssocData($db,'cgfbapp');
    $obj->Delete($uid);
  }


  public static function appfriends($params,&$smarty)
  {
    $uid = get_parameter_value($params,'uid');
    if( !$uid ) return;

    // get the users friends.
    $res = cgfb::api('/me/friends','GET');
    if( !$res ) return;
    if( !is_array($res) ) return;

    $friend_uids = cge_array::extract_field($res,'uid');
    
    $db = cmsms()->GetDb();
    $obj = new AssocData($db,'cgfbapp');
    $res = $obj->find($friend_uids);

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$data);
	return;
      }
    return $data;
  }
} // end of class

#
# EOF
#
?>