<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgfb_post_attachment
{
  private $_keys = array('name','href','caption','description','comments_xid');
  private $_data = array();
  private $_assoc = array();
  private $_props = array();
  private $_media = array();

  public function __construct($name,$href,$caption = '',$description = '')
  {
    if( !$name || !$href ) 
      {
	throw new Exception('Attempt to create invalid attachment object');
      }

    $this->name = $name;
    $this->href = $href;
    if( $caption ) $this->caption = $caption;
    if( $description ) $this->description = $description;
  }


  public function __get($key)
  {
    if( !in_array($key,$this->_keys) )
      {
	throw new Exception('Attempt to retrieve invalid value from post_attachment object');
      }

    if( !isset($this->_data[$key]) ) return;
    return $this->_data[$key];
  }


  public function __set($key,$value)
  {
    if( !in_array($key,$this->_keys) )
      {
	throw new Exception('Attempt to modify invalid value from post_attachment object');
      }
    
    switch( $key )
      {
      case 'media':
	$value = strtolower($value);
	if( $value != 'image' && $value != 'flash' && $value != 'music' )
	  {
	    throw new Exception('Attempt to modify attachment object with invalid value');
	  }
	break;
      }

    $this->$key = $value;
  }


  public function add_media($type,$src,$href)
  {
    if( ($type != 'image' && $type != 'flash' && $type != 'music') || !$src || !$href )
      {
	throw new Exception('Attempt to add invalid media to an attachment object');
      }

    if( count($this->_media) == 5 )
      {
	throw new Exception('Attempt to add too many media objects to an attachment');
      }

    $tmp = array('type'=>$type,'src'=>$src,'href'=>$href);
    $this->_media[] = $tmp;
  }


  public function add_property($name,$text,$href = '')
  {
    if( !$name || !$text )
      {
	throw new Exception('Attempt to add invalid property to an attachment object');
      }

    if( $href )
      {
	$text = array('text'=>$text,'href'=>$href);
      }

    $this->_props[$name] = $text;
  }


  public function add_data($key,$value)
  {
    if( !$key || !$value )
      {
	throw new Exception('Attempt to add invalid property to an attachment object');
      }

    $this->_assoc[$key] = $value;
  }


  public function to_array()
  {
    $output = array();
    $output['name'] = $this->name;
    $output['href'] = $this->href;
    if( $this->caption ) $output['caption'] = $this->caption;
    if( $this->description ) $output['description'] = $this->description;
    if( $this->comments_xid ) $output['comments_xid'] = $this->comments_xid;

    if( count(array_keys($this->_props)) )
      {
	$output['properties'] = array();
	foreach( $this->_props as $key => $value )
	  {
	    $output['properties'] = array($key,$value);
	  }
      }

    if( count($this->_media) )
      {
	$output['media'] = $this->_media;
      }

    if( count($this->_assoc) )
      {
	foreach( $this->_assoc as $key => $value )
	  {
	    $output[$key] = $value;
	  }
      }

    return $output;
  }
} // end of class

#
# EOF
#
?>
