<?php

require_once(dirname(__FILE__).'/facebook.php');

/**
 * A simple extension for the facebook php class to provide extended functions
 *
 * @author Robert Campbell
 */
class CGFacebook extends Facebook
{
  private $_app_access_token = null;
  private $_use_app_token = FALSE;

  /**
   * Retrieve the application access token.  If no cached
   * value is found the value is retrieved from facebook
   * and cached
   *
   * @return string
   */
  protected function getAppAccessToken()
  {
    if( !$this->_app_access_token ) 
      {
	$args = array(
		      'grant_type' => 'client_credentials',
		      'client_id' => $this->appId,
		      'client_secret' => $this->apiSecret
		      );

	$ch = curl_init();
	$url = 'https://graph.facebook.com/oauth/access_token';
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $args);
	$data = curl_exec($ch);
	
	$this->_app_access_token = json_encode($data);
      }
    return $this->_app_access_token;
  }

  
  /**
   * Toggle using the application access token, or the user access token
   * for requests.
   *
   * @param bool Flag indicating wether to enable or disable using the app token for further requests
   * @return void
   */
  public function enableAppToken($flag = TRUE) {
    $this->_use_app_token = $flag;
  }


  /**
   * Get the appropriate access token.  This method understands if the object is currently
   * using the application access token or the user access token.
   *
   * @return string
   */
  public function getAccessToken() {
    if( $this->_use_app_token )
      return $this->getAppAccessToken();
    return parent::getAccessToken();
  }
}

?>