<?php
#-------------------------------------------------------------------------
# Module: Custom Global Settings
# Author: Rolf Tjassens
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/customgs
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

/**
 * Translated Strings
 */
$this->smarty->assign('label_label', $this->Lang('label_label'));
$this->smarty->assign('label_help_text', $this->Lang('label_help_text'));

$this->smarty->assign('submit',$this->CreateInputSubmit( $id, 'submit', $this->Lang('submit')));
$this->smarty->assign('cancel',$this->CreateInputSubmit( $id, 'cancel', $this->Lang('cancel')));

/**
 * Create Admin tabs
 */ 
echo $this->StartTabHeaders();

if ( ($this->CheckPermission('Custom Global Settings - Manage')) || ($this->CheckPermission('Custom Global Settings - Settings')) ) {
	echo $this->SetTabHeader("general",$this->Lang("title_general"));
}

if ($this->CheckPermission('Custom Global Settings - Settings')) {
	echo $this->SetTabHeader("settings",$this->Lang("title_settings"));
	echo $this->SetTabHeader("checkboxes",$this->Lang("title_checkboxes"));
	echo $this->SetTabHeader("textfields",$this->Lang("title_textfields"));
	}

echo $this->EndTabHeaders();


echo $this->StartTabContent();

if ( ($this->CheckPermission('Custom Global Settings - Manage')) || ($this->CheckPermission('Custom Global Settings - Settings')) ){

	echo $this->StartTab("general");
		include(dirname(__FILE__).'/function.admin_general.php');
	echo $this->EndTab();

}

if ($this->CheckPermission('Custom Global Settings - Settings')) {

	echo $this->StartTab("settings");
		include(dirname(__FILE__).'/function.admin_settings.php');
	echo $this->EndTab();

	echo $this->StartTab("checkboxes");
		include(dirname(__FILE__).'/function.admin_checkboxes.php');
	echo $this->EndTab();

	echo $this->StartTab("textfields");
		include(dirname(__FILE__).'/function.admin_textfields.php');
	echo $this->EndTab();

	}

echo $this->EndTabContent();
?>