<?php
#-------------------------------------------------------------------------
# Module: Custom Global Settings
# Author: Rolf Tjassens
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2011 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/customgs
#-------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

class CustomGS extends CMSModule
{
	function GetName()
	{
		return 'CustomGS';
	}

	function GetFriendlyName()
	{
		return $this->GetPreference('input_custom_modulename');
	}
	
	function GetVersion()
	{
		return '1.0';
	}
	
	function MinimumCMSVersion()
	{
		return '1.9.4.3';
	}
	
	function GetHelp()
	{
		return file_get_contents(dirname(__FILE__).'/help_text.inc');
	}
	
	function GetAuthor()
	{
		return 'Rolf Tjassens';
	}
	
	function GetAuthorEmail()
	{
		return 'rolf at cmsmadesimple dot org';
	}
	
	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.inc');
	}
	
	function IsPluginModule()
	{
		return true;
	}
	
	function HasAdmin()
	{
		return true;
	}
	
	function GetAdminSection()
	{
		return 'extensions';
	}
	
	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}
	
	function VisibleToAdminUser() 
	{
		return ($this->CheckPermission('Custom Global Settings - Manage' || 'Custom Global Settings - Settings'));
	}
	
	function GetDependencies()
	{
		return array();
	}
	
	function SetParameters()
	{
		$this->RegisterModulePlugin();
	  $this->RestrictUnknownParams();
	}
	
	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('uninstall_confirm');
	}
	
	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}
}
?>