<?php
#-------------------------------------------------------------------------
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/cartms/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$prog = cms_join_path(dirname(__FILE__),'library','orders.api.php');
include_once($prog);
$prog = cms_join_path(dirname(__FILE__),'library','admin.functions.php');
include_once($prog);

class CartMadeSimple extends CMSModule
{
	var $orders;

	function CartMadeSimple() {
    	parent::CMSModule();
    	$this->orders = new CMSOrders($this);
	}

	function GetName()
	{
		return 'CartMadeSimple';
	}

	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}

	function GetVersion()
	{
		return '0.4.1';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Duketown';
	}

	function GetAuthorEmail()
	{
		// For spam reasons the mail address has been left out
		return '';
	}

	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.inc');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}

	function GetAdminSection()
	{
    global $CMS_VERSION;
    if( version_compare($CMS_VERSION,'1.8','<') ) return 'extensions';
    return 'ecommerce';
	}

	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}

	function VisibleToAdminUser()
	{
		return $this->CheckPermission('Use CartMadeSimple') ||
			$this->CheckPermission('Delete CartMadeSimpleOrders') ||
			$this->CheckPermission('Modify Templates') ||
			$this->CheckPermission('Modify Site Preferences');
	}

	function GetDependencies()
	{
		return array('FrontEndUsers'=>'1.12.0',
				'ShopMadeSimple'=>'0.3.0');
	}

	function MinimumCMSVersion()
	{
		return '1.9.4';
	}

	function MaximumCMSVersion()
	{
		return '1.10.9';
	}
	
	/*---------------------------------------------------------
	   SetParameters()
	   This function enables you to create mappings for
	   your module when using "Pretty Urls".
	   
	   Typically, modules create internal links that have
	   big ugly strings along the lines of:
	   index.php?mact=ModName,cntnt01,actionName,0&cntnt01param1=1&cntnt01param2=2&cntnt01returnid=3
	   
	   You might prefer these to look like:
	   /ModuleFunction/2/3
	   
	   To do this, you have to register routes and map
	   your parameters in a way that the API will be able
	   to understand.

	   Also note that any calls to CreateLink will need to
	   be updated to pass the pretty url parameter.
	   
	   Since the Skeleton doesn't really create any links,
	   the section below is commented out, but you can
	   use it to figure out pretty urls.
	   
	   ---------------------------------------------------------*/
	function SetParameters()
	{
	/*
		$this->CreateParameter('cartmadesimple', '', $this->lang('help_cartmadesimple'));
		// For viewing a picture
		$this->RegisterRoute('/cartmadesimple\/(?P<numeric_param_name>[0-9]+)\/(?P<string_param_name>[a-zA-Z]+)\/(?P<returnid>[0-9]+)$/', 
array('action'=>'default'));

		// now, any url that looks like:
		//    /cartmadesimple/3/foo/5
		// will call the default action, with:
		//     params['numeric_param_name'] set to 3
		//     params['string_param_name'] set to "foo"
		//    and returnid set to 5
		
	*/
	}

	/*---------------------------------------------------------
	   GetHeaderHTML()
	   This function inserts javascript (and links) into header of HTML
	  ---------------------------------------------------------*/
	function GetHeaderHTML()
	{
		$javascript = '';
		// Include javascript so easy date selection is possible
		$javascript .= '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"></script>';
		$javascript .= '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/jquery-ui.min.js"></script>';
		$javascript .= '<link type="text/css" rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/themes/smoothness/jquery-ui.css" />';

		$javascript .= '<script type="text/javascript">
			$(document).ready(function() {
				$(function() {$(\'div.datepicker input\').datepicker({dateFormat: \''.$this->GetPreference('dateformat', 'd-m-yy').'\'});});
				});
				</script>';
		// Include script so sorting of tables in backend is possible
		$javascript .= '<script type="text/javascript" src="../modules/JQueryTools/lib/jquery.tablesorter.js"></script>'."\n";
		$javascript .= '<link rel="stylesheet" type="text/css" href="../modules/JQueryTools/lib/css/JQueryTools.css" media="screen" />'."\n";
		$javascript .= '<script type="text/javascript" id="js">jQuery(document).ready(function() 
		{ 
			jQuery(".cms_sortable")
				.tablesorter( 
				); 
		} 
		); 
		</script>';
		return $javascript;
	}

	function GetEventDescription ( $eventname )
	{
		return $this->Lang('event_info_'.$eventname );
	}

	function GetEventHelp ( $eventname )
	{
		return $this->Lang('event_help_'.$eventname );
	}

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}

	function ValidateEmailAddress($emailaddress) {
		if(!preg_match("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i", $emailaddress)) {
			return false;
		}
		else {
			return true;
		}	
	}
	
	/**
	 * Translates a number to a short alhanumeric version
	 *
	 * Translated any number up to 9007199254740992
	 * to a shorter version in letters e.g.:
	 * 9007199254740989 --> PpQXn7COf
	 *
	 * specifiying the second argument true, it will
	 * translate back e.g.:
	 * PpQXn7COf --> 9007199254740989
	 *
	 * this function is based on any2dec && dec2any by
	 * fragmer[at]mail[dot]ru
	 * see: http://nl3.php.net/manual/en/function.base-convert.php#52450
	 *
	 * If you want the alphaID to be at least 3 letter long, use the
	 * $pad_up = 3 argument
	 *
	 * In most cases this is better than totally random ID generators
	 * because this can easily avoid duplicate ID's.
	 * For example if you correlate the alpha ID to an auto incrementing ID
	 * in your database, you're done.
	 *
	 * The reverse is done because it makes it slightly more cryptic,
	 * but it also makes it easier to spread lots of IDs in different
	 * directories on your filesystem. Example:
	 * $part1 = substr($alpha_id,0,1);
	 * $part2 = substr($alpha_id,1,1);
	 * $part3 = substr($alpha_id,2,strlen($alpha_id));
	 * $destindir = "/".$part1."/".$part2."/".$part3;
	 * // by reversing, directories are more evenly spread out. The
	 * // first 26 directories already occupy 26 main levels
	 *
	 * more info on limitation:
	 * - http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-talk/165372
	 *
	 * if you really need this for bigger numbers you probably have to look
	 * at things like: http://theserverpages.com/php/manual/en/ref.bc.php
	 * or: http://theserverpages.com/php/manual/en/ref.gmp.php
	 * but I haven't really dugg into this. If you have more info on those
	 * matters feel free to leave a comment.
	 *
	 * @author  Kevin van Zonneveld <kevin@vanzonneveld.net>
	 * @author  Simon Franz
	 * @author  Deadfish
	 * @copyright 2008 Kevin van Zonneveld (http://kevin.vanzonneveld.net)
	 * @license   http://www.opensource.org/licenses/bsd-license.php New BSD Licence
	 * @version   SVN: Release: $Id: alphaID.inc.php 344 2009-06-10 17:43:59Z kevin $
	 * @link    http://kevin.vanzonneveld.net/
	 *
	 * @param mixed   $in    String or long input to translate
	 * @param boolean $to_num  Reverses translation when true
	 * @param mixed   $pad_up  Number or boolean padds the result up to a specified length
	 * @param string  $passKey Supplying a password makes it harder to calculate the original ID
	 *
	 * @return mixed string or long
	 */
	function alphaID($in, $to_num = false, $pad_up = false, $passKey = null) {
	  $index = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	  if ($passKey !== null) {
	    // Although this function's purpose is to just make the
	    // ID short - and not so much secure,
	    // with this patch by Simon Franz (http://blog.snaky.org/)
	    // you can optionally supply a password to make it harder
	    // to calculate the corresponding numeric ID
	 
	    for ($n = 0; $n<strlen($index); $n++) {
	      $i[] = substr( $index,$n ,1);
	    }
	 
	    $passhash = hash('sha256',$passKey);
	    $passhash = (strlen($passhash) < strlen($index))
	      ? hash('sha512',$passKey)
	      : $passhash;
	 
	    for ($n=0; $n < strlen($index); $n++) {
	      $p[] =  substr($passhash, $n ,1);
	    }
	 
	    array_multisort($p,  SORT_DESC, $i);
	    $index = implode($i);
	  }
	 
	  $base  = strlen($index);
	 
	  if ($to_num) {
	    // Digital number  <<--  alphabet letter code
	    $in  = strrev($in);
	    $out = 0;
	    $len = strlen($in) - 1;
	    for ($t = 0; $t <= $len; $t++) {
	      $bcpow = bcpow($base, $len - $t);
	      $out   = $out + strpos($index, substr($in, $t, 1)) * $bcpow;
	    }
	 
	    if (is_numeric($pad_up)) {
	      $pad_up--;
	      if ($pad_up > 0) {
	        $out -= pow($base, $pad_up);
	      }
	    }
	    $out = sprintf('%F', $out);
	    $out = substr($out, 0, strpos($out, '.'));
	  } else {
	    // Digital number  -->>  alphabet letter code
	    if (is_numeric($pad_up)) {
	      $pad_up--;
	      if ($pad_up > 0) {
	        $in += pow($base, $pad_up);
	      }
	    }
	 
	    $out = "";
	    for ($t = floor(log($in, $base)); $t >= 0; $t--) {
	      $bcp = bcpow($base, $t);
	      $a   = floor($in / $bcp) % $base;
	      $out = $out . substr($index, $a, 1);
	      $in  = $in - ($a * $bcp);
	    }
	    $out = strrev($out); // reverse
	  }
	 
	  return $out;
	}

	/*---------------------------------------------------------
	   InventoryDecrease()
	   This function checks if one wants to track inventory.
	   If so the number of sold items is subtracted from the available quantity.
	   Quantity on stock is either per product or per attribute
	   These values are held in Shop Made Simple
	   If module Inventory Management is installed, transactions are prepared
	   Parameters:
	   	- order_id	used to get all order lines with products and quantities
	   	- status The status of the order at the moment it was passed here
	   ---------------------------------------------------------*/
	function InventoryDecrease($order_id, $status = 'CNF') {
		$db = cmsms()->GetDb();
		$gCms = cmsms();

		// Check if Shop Made Simple/Inventory Management are installed
		global $CMS_VERSION;
		if (version_compare($CMS_VERSION,'1.10-beta0','>') &&
			version_compare($CMS_VERSION,'1.11','<')) {
			$modops = cmsms()->GetModuleOperations();
			$ShopMS = $modops->get_module_instance('ShopMadeSimple');
			$DTI = $modops->get_module_instance('DTInventory');
		}
		else {
			$ShopMS =& $gCms->modules['ShopMadeSimple']['object'];
			$DTI =& $gCms->modules['DTInventory']['object'];
		}
		// Only process the order item quantities if this is correct timing
		if ($status != $ShopMS->GetPreference('salesinventtiming', 'CNF')) {
			return false;
		}
		if( $ShopMS )	{
			$inventorytype = $ShopMS->GetSMSPreference('inventorytype', 'none');
			if ($inventorytype != 'none') {
				// Update inventory based upon order lines
				foreach ($this->orders->GetOrderLines( $order_id ) as $orderline) {
					$InventParms = array();
					switch ($inventorytype) {
						case 'prod':
							$sql = 'UPDATE '.cms_db_prefix().'module_sms_products 
								SET maxattributes = maxattributes - ? 
								WHERE product_id = ?';
							$dbresult = $db->Execute( $sql, array( $orderline->qty,
								$orderline->product_id));
							$item_id = $orderline->product_id;
							$description = substr($orderline->categoryname.' | '.$orderline->productname, 0, 80);
							break;
						case 'attr':
							$sql = 'UPDATE '.cms_db_prefix().'module_sms_product_attributes 
								SET maxallowed = maxallowed - ?
								WHERE attribute_id = ?';
							$dbresult = $db->Execute( $sql, array( $orderline->qty, 
								$orderline->attribute_id));
							$item_id = $orderline->attribute_id;
							$description = substr($orderline->productname.' | '.$orderline->attributename, 0, 80);
							break;
					}

					if( $DTI )	{
						// Generate sales transaction for Inventory Management
						$InventParms['inventorytype'] = $inventorytype;
						$InventParms['item_id'] = $item_id;
						$InventParms['location_id'] = 0; // Default set in DTInventory
						$InventParms['quantity'] = $orderline->qty;
						$InventParms['type_code'] = $DTI->GetPreference('defaultsalestype_code');
						$InventParms['cost_price'] = $orderline->price;
						$InventParms['remark'] = $this->Lang('inventtransactionremark',$order_id);
						$InventParms['itemnumber'] = $orderline->itemnumber;
						$InventParms['description'] = $description;
						$transaction_id = $DTI->GenerateTransaction($InventParms);
						$DTI->AdjustQuantityOnLocation($InventParms);
					}

				}				
			}
		}
	}

	/*---------------------------------------------------------
	   InventoryOnStockAvail()
	   This function checks if one wants to track inventory.
	   If so the number of available items is returned 
	   with a maximum of 20 (this could change into a preference).
	   Quantity on stock is either per product or per attribute
	   These values are held in Shop Made Simple
	   Parameters:
	   	- category_id Can be used later if inventory held per category
	   	- product_id
	   	- attribute_id
	   ---------------------------------------------------------*/
	function InventoryOnStockAvail($category_id, $product_id, $attribute_id) {
		$db = cmsms()->GetDb();
		$maxquantityperorderline = 20;
		
		$ShopMS =& $this->GetModuleInstance('ShopMadeSimple');
		if( $ShopMS )	{
			$inventorytype = $ShopMS->GetSMSPreference('inventorytype', 'none');
			$maxquantityperorderline = $ShopMS->GetSMSPreference('maxquantityperorderline', 20);
			if ($inventorytype != 'none') {
				// Check inventory based type of inventory
				switch ($inventorytype) {
					case 'prod':
						$sql = 'SELECT maxattributes FROM '.cms_db_prefix().'module_sms_products 
							WHERE product_id = ?';
						$row = $db->GetRow( $sql, array( $product_id));
						if ($row) {
							$quantityonstock = $row['maxattributes'];
						}
						break;
					case 'attr':
						$sql = 'SELECT maxallowed FROM '.cms_db_prefix().'module_sms_product_attributes 
							WHERE attribute_id = ?';
						$row = $db->GetRow( $sql, array( $attribute_id));
						if ($row) {
							$quantityonstock = $row['maxallowed'];
						}
						break;
				}
				if ($quantityonstock < $maxquantityperorderline) {
					return $quantityonstock;
				}
			}
		}
		return $maxquantityperorderline;
	}

	/*---------------------------------------------------------
		Using a preference a new invoice number will be prepared and
		returned to calling statement
	  ---------------------------------------------------------*/	
	function PrepareInvoiceNo() {
		$maxinvoices = $this->GetPreference('maxinvoices', 10000);
		$invoiceno = $this->GetPreference('invoiceno'.date('Y'), date('Y') * $maxinvoices) + 1;
		$this->SetPreference('invoiceno'.date('Y'), $invoiceno);
		$invoiceno = $this->GetPreference('invoice_prefix','I') . $invoiceno;
		return $invoiceno;		
	}

	/*---------------------------------------------------------
		This function allow retrieval from preferences from this module
		when needed in another module
	  ---------------------------------------------------------*/	
	function GetCartMSPreference($preference, $default='') {
		return $this->GetPreference($preference, $default);
	}

	function SendInvoiceAsAttach($order_id) {
		$orderheader = array();
		$orderheader = $this->orders->GetOrderHeader( $order_id );
		$shipto = array();
		$shipto = $this->orders->GetOrderShipTo( $orderheader['customer_id'] );
		// Translations
		$invlabel_invoicefrom = $this->Lang('invoicefrom');
		$invlabel_invoice = $this->Lang('inv_invoice');
		$invlabel_order = $this->Lang('inv_order');
		$invoicepath = cms_join_path($this->config['uploads_path'],$this->getName(),$orderheader['invoiceno'].'.pdf');
		// Send the invoice
		$cmsmailer = $this->GetModuleInstance('CMSMailer');

		// Fill the mail body. This will become data merged with a template
		if ($orderheader['order_id'] != '' ) $this->smarty->assign('order_id', $orderheader['order_id']);
		if ($orderheader['customer_id'] != '' ) $this->smarty->assign('customer_id', $orderheader['customer_id']);
		if ($orderheader['invoiceno'] != '' ) $this->smarty->assign('invoiceno', $orderheader['invoiceno']);
		if ($shipto['shiptoname'] != '' ) $this->smarty->assign('shiptoname', $shipto['shiptoname']);
		if ($shipto['addressstreet'] != '' ) $this->smarty->assign('shiptostreet', $shipto['addressstreet']);
		if ($shipto['addresscity'] != '' ) $this->smarty->assign('shiptocity', $shipto['addresscity']);
		if ($shipto['addressstate'] != '' ) $this->smarty->assign('shiptostate', $shipto['addressstate']);
		if ($shipto['addresszip'] != '' ) $this->smarty->assign('shiptozip', $shipto['addresszip']);
		if ($shipto['addresscountry'] != '' ) $this->smarty->assign('shiptocountry', $shipto['addresscountry']);
		if ($shipto['telephone'] != '' ) $this->smarty->assign('shiptotelephone', $shipto['telephone']);
		if ($shipto['billtoname'] != '' ) $this->smarty->assign('billtoname', $shipto['billtoname']);
		if ($shipto['billaddressstreet'] != '' ) $this->smarty->assign('billtostreet', $shipto['billaddressstreet']);
		if ($shipto['billaddresscity'] != '' ) $this->smarty->assign('billtocity', $shipto['billaddresscity']);
		if ($shipto['billaddressstate'] != '' ) $this->smarty->assign('billtostate', $shipto['billaddressstate']);
		if ($shipto['billaddresszip'] != '' ) $this->smarty->assign('billtozip', $shipto['billaddresszip']);
		if ($shipto['billaddresscountry'] != '' ) $this->smarty->assign('billtocountry', $shipto['billaddresscountry']);
		if ($shipto['email'] != '' ) $this->smarty->assign('email', $shipto['email']);
		$mailbody = $this->ProcessTemplateFromDatabase('cust_invmail_template');
		$cmsmailer->AddAddress($shipto['email']);
		$cmsmailer->SetBody($mailbody);
		$cmsmailer->IsHTML( true );
		$cmsmailer->SetSubject($this->GetPreference('cust_invmail_subject', $this->Lang('yourinvoice')));
		$cmsmailer->AddAttachment( $invoicepath, $invlabel_invoice.$orderheader['invoiceno'].'.pdf',
			'base64', 'application/octent-stream' );
		$mailsend = $cmsmailer->Send();
	}

	/*---------------------------------------------------------
		This function prepares a list of possible actions that can be taken
		Parameter orderstatus will be excluded from list
	  ---------------------------------------------------------*/	
	function GetMassActions($orderstatus = '') {
		$massactionlist = array();
		
		if ($orderstatus == 'INT') {
			// Deletion allowed?
			if ($this->CheckPermission('Modify CartMadeSimple')) {
				$massactionlist[$this->Lang('massactiondelete')] = 'MADel';
			}
			$massactionlist[$this->Lang('massactionconfirmed')] = 'MACNF';
			$massactionlist[$this->Lang('massactionpaid')] = 'MAPAY';
			$massactionlist[$this->Lang('massactionshipped')] = 'MASHP';
			$massactionlist[$this->Lang('massactioninvoiced')] = 'MAINV';
		}
		if ($orderstatus == 'CNF') {
			$massactionlist[$this->Lang('massactionpaid')] = 'MAPAY';
			$massactionlist[$this->Lang('massactionshipped')] = 'MASHP';
			$massactionlist[$this->Lang('massactioninvoiced')] = 'MAINV';
			$massactionlist[$this->Lang('massactioninitialized')] = 'MAINT';
			// Deletion allowed?
			if ($this->CheckPermission('Modify CartMadeSimple')) {
				$massactionlist[$this->Lang('massactiondelete')] = 'MADel';
			}
		}
		if ($orderstatus == 'PAY') {
			$massactionlist[$this->Lang('massactionshipped')] = 'MASHP';
			$massactionlist[$this->Lang('massactioninvoiced')] = 'MAINV';
			$massactionlist[$this->Lang('massactionconfirmed')] = 'MACNF';
			$massactionlist[$this->Lang('massactioninitialized')] = 'MAINT';
			// Deletion allowed?
			if ($this->CheckPermission('Modify CartMadeSimple')) {
				$massactionlist[$this->Lang('massactiondelete')] = 'MADel';
			}
		}
		if ($orderstatus == 'SHP') {
			$massactionlist[$this->Lang('massactioninvoiced')] = 'MAINV';
			$massactionlist[$this->Lang('massactionpaid')] = 'MAPAY';
			$massactionlist[$this->Lang('massactionconfirmed')] = 'MACNF';
			$massactionlist[$this->Lang('massactioninitialized')] = 'MAINT';
			// Deletion allowed?
			if ($this->CheckPermission('Modify CartMadeSimple')) {
				$massactionlist[$this->Lang('massactiondelete')] = 'MADel';
			}
		}
		if ($orderstatus == 'INV') {
			// Deletion allowed?
			if ($this->CheckPermission('Modify CartMadeSimple')) {
				$massactionlist[$this->Lang('massactiondelete')] = 'MADel';
			}
			$massactionlist[$this->Lang('massactionshipped')] = 'MASHP';
			$massactionlist[$this->Lang('massactionconfirmed')] = 'MACNF';
			$massactionlist[$this->Lang('massactionpaid')] = 'MAPAY';
			$massactionlist[$this->Lang('massactioninitialized')] = 'MAINT';
		}
		//$massactionlist[$this->Lang('massactionexport')] = 'MAEXP';

		return $massactionlist;
	}
	
	/*---------------------------------------------------------
		This function obviously retrieves only a description of payment gateway
	  ---------------------------------------------------------*/	
	function GetPaymentGatewayDescription ($paymethod) {
		$db = cmsms()->GetDb();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_pms_gateways 
			WHERE active > 0 AND gateway_code = ?';
		$row = $db->GetRow($query, array($paymethod));
		if ($row) {
			return $row['description'];
		}
		else {
			return '';
		}
	}	
		
}

?>