﻿<?php

#-------------------------------------------------------------------------
# TruetypeText library - This library can be used to write any text with a TrueType font.
# Effects can also be applied on resulting images
#-------------------------------------------------------------------------
# Copyright (c) 2007 by Damien GAUTHIER (trigau@free.fr)
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------


class TTTimage
{
	var $zerox; // int, calculated internally, x position of the zero point
	var $zeroy; // int, calculated internally, y position of the zero point
	var $width; // int, calculated internally, final width of the image
	var $height; // int, calculated internally, final height of the image
	var $color; // string (format : #ABCDEF), background color
	var $transparency; // boolean

	var $im; // gd image, internal
	var $bg; //gd background color, internal
	var $elements;

	function TTTimage($color='#FFFFFF', $transparency = true)
	{
		$this->zerox = 0;
		$this->zeroy = 0;
		$this->width = 0;
		$this->height = 0;
		$this->color = $color;
		$this->transparency = $transparency;
		$this->im = false;
		$this->bg = false;
		$this->elements = array();
	}

	function create()
	{
		$this->im = @imagecreatetruecolor($this->width, $this->height);
		if (!$this->im) return;
		$this->bg = $this->colorallocate($this->color);
		imagefill ( $this->im, 0, 0, $this->bg);
		if ($this->transparency)
			$this->colortransparent();
	}

	function copyfrom($otherTTTimage)
	{
		$this->zerox = $otherTTTimage->zerox;
		$this->zeroy = $otherTTTimage->zeroy;
		$this->width = $otherTTTimage->width;
		$this->height = $otherTTTimage->height;
		$this->color = $otherTTTimage->color;
		$this->transparency = $otherTTTimage->transparency;

		if ($otherTTTimage->im!==false)
		{
			$this->destroy();
			$this->create();
			return imagecopymerge ( $this->im, $otherTTTimage->im, 0, 0, 0, 0, $otherTTTimage->width, $otherTTTimage->height,100 );
		}
		else
		{
			$this->im = false;
			$this->bg = false;
		}

	}

	function add($TTTelement)
	{
		$this->elements[] = $TTTelement;
	}

	function getsize()
	{
		$size = array(0,0);
		$zero = array(0,0);
		foreach($this->elements as $element)
		{
			switch(strtolower(get_class($element)))
			{
				case 'ttttext' :
					$newzero = array($element->originx - $element->deltax, $element->originy - $element->deltay);
					$newzero[0] = max ($newzero[0], $zero[0]);
					$newzero[1] = max ($newzero[1], $zero[1]);
					$size[0] = max($size[0], $newzero[0] + $element->deltax + $element->width - $element->originx);
					$size[1] = max($size[1], $newzero[1] + $element->deltay + $element->height - $element->originy);
					$zero = $newzero;
					break;
				case 'ttteffect' :
					$delta = ($element->type=='edge' ? 3 : 1);
					$size[0] += 2*$delta;
					$size[1] += 2*$delta;
					$zero[0] +=$delta;
					$zero[1] +=$delta;
					break;
				case 'tttmirror' :
					$size[1] += round($size[1] * $element->ratio/100);
					break;
			}
		}
		return $size;
	}

	function draw()
	{
		if (!$this->im) $this->create();
		foreach($this->elements as $element)
			$element->draw($this);
	}

	// Enlarge image if necessary
	function enlarge($left,$top,$right,$bottom)
	{
		$new = new TTTimage;
		$new->copyfrom($this);
		$left = min ($left, - $this->zerox);
		$top = min ($top, - $this->zeroy);
		$right = max ($right, $this->width - $this->zerox);
		$bottom = max ($bottom, $this->height - $this->zeroy);
		$new->zerox = -$left;
		$new->zeroy = -$top;
		$new->width = $right - $left;
		$new->height = $bottom - $top;
		if ($new->width != $this->width || $new->height != $this->height)
		{
			$new->create();
			if ($this->im!==false)
				imagecopymerge($new->im,$this->im,$new->zerox-$this->zerox,$new->zeroy-$this->zeroy,0,0,$this->width,$this->height,100);
			$this->copyfrom($new);
		}
	}

	function output($format = 'png', $filename=NULL)
	{
		if (!$this->im) $this->draw();
		switch($format)
		{
			case 'gif':
				imagetruecolortopalette($this->im,true,256);
				if ($filename==NULL)
					{ header("Content-type: image/gif"); imagegif($this->im);}
				else imagegif($this->im, $filename);
				break;
			case 'jpg':
				if ($filename==NULL)
					header("Content-type: image/jpg");
				imagejpeg($this->im, $filename,85);
				break;
			case 'png': default:
				//imagesavealpha($this->im, true);
				if ($filename==NULL)
					{header("Content-type: image/png"); imagepng($this->im);}
				else imagepng($this->im, $filename);
		}
	}

	function destroy()
	{
		if ($this->im!==false)
			@imagedestroy($this->im);
		$this->im = false;
	}

	function colorallocate($color, $im = false) // html color conversion from format #ABCDEF
	{
		if (!$im) $im = &$this->im;
		if (!$im) return;

		$int = hexdec('0x'.substr(strtoupper($color),1));
		if (strlen($color)==9)
			return imagecolorallocatealpha($im, 0xFF & ($int >> 0x18), 0xFF & ($int >> 0x10), 0xFF & ($int >> 0x8), floor((0xFF & $int)/2));
		else
			return imagecolorallocate($im, 0xFF & ($int >> 0x10), 0xFF & ($int >> 0x8), 0xFF & $int);
	}

	function colortransparent($im=false, $bg=false) //transparent color allocation
	{
		if (!$im) $im = &$this->im;
		if (!$bg) $bg = &$this->bg;
		if (!$im || !$bg || !$this->transparency) return;
		return imagecolortransparent($im, $bg);
	}

	function colorat($x,$y)
	{
		if ($x<0 || $y<0 || $x>=$this->width || $y>=$this->height)
			return $this->bg;
		else
			return imagecolorat($this->im,$x,$y);
	}

}

class TTTtext
{
	var $text; // string
	var $deltax; // int, x position compared to zero point
	var $deltay; // int, y position compared to zero point
	var $fontsize; // int, font size in pixels
	var $fontfile; // string, fontfile location
	var $color; // string (format : #ABCDEF)
	var $fullheight; // boolean, indicates if height is supposed to be extended to maximum text height
	var $angle;

	var $originx; // int, calculated internally, x position compared to surrounding text box
	var $originy; // int, calculated internally, y position compared to surrounding text box
	var $width; // int, calculated internally, final width of the image
	var $height; // int, calculated internally, final height of the image

	function TTTtext($text='', $fontfile='', $fontsize=20, $color='#000000', $x=0, $y=0, $angle=0, $fullheight=false)
	{
		$this->text = $text;
		$this->deltax = $x;
		$this->deltay = $y;
		$this->angle = $angle;
		$this->fontsize = $fontsize;
		$this->fontfile =$fontfile;
		$this->color = $color;
		$this->fullheight = $fullheight;
		$bbox = imagettfbbox_ttt($this->fontsize, $this->angle, $this->fontfile, $this->text,$this->fullheight);
		if ($bbox===false) return false;

		$this->width = max($bbox[0],$bbox[2],$bbox[4],$bbox[6]) - min($bbox[0],$bbox[2],$bbox[4],$bbox[6]) + 2 ;
		$this->height = max($bbox[1],$bbox[3],$bbox[5],$bbox[7]) - min($bbox[1],$bbox[3],$bbox[5],$bbox[7]) + 2;
		$this->originx = - min($bbox[0],$bbox[2],$bbox[4],$bbox[6]) + 1;
		$this->originy = - min($bbox[1],$bbox[3],$bbox[5],$bbox[7]) + 1;
	}

	function draw(& $TTTimage)
	{
		$left = $this->deltax - $this->originx; // left position compared to zero point
		$top = $this->deltay - $this->originy; // top position compared to zero point
		$right = $left + $this->width; // right position compared to zero point
		$bottom = $top + $this->height; // bottom position compared to zero point

		$TTTimage->enlarge($left,$top,$right,$bottom);

		$color = $TTTimage->colorallocate($this->color);
		imagettftext_ttt ( $TTTimage->im, $this->fontsize, $this->angle, $TTTimage->zerox + $this->deltax,  $TTTimage->zeroy + $this->deltay, $color,  $this->fontfile,  $this->text);

	}
}

class TTTeffect
{
	var $type; //string
	function TTTeffect($type='')
	{
		$this->type = $type;
	}

	function draw(& $TTTimage)
	{
		$delta = ($this->type=='edge' ? 3 : 1);
		$left = -$TTTimage->zerox - $delta; // left position compared to zero point
		$top = -$TTTimage->zeroy - $delta; // top position compared to zero point
		$right = $left + $TTTimage->width + 2*$delta; // right position compared to zero point
		$bottom = $top + $TTTimage->height + 2*$delta; // bottom position compared to zero point

		$TTTimage->enlarge($left,$top,$right,$bottom);
		imagefilter_ttt($TTTimage->im, $this->type);
	}
}

class TTTmirror
{
	var $ratio;
	var $up_transparency;
	var $down_transparency;
	var $bgcolor;

	function TTTmirror($ratio = 70, $bgcolor = false, $up_transparency = 60, $down_transparency = 1)
	{
		$this->ratio = $ratio;
		$this->up_transparency = $up_transparency;
		$this->down_transparency = $down_transparency;
		$this->bgcolor = $bgcolor;
	}

	function draw(& $TTTimage)
	{
		$bgcolor = ($this->bgcolor ? $this->bgcolor : $TTTimage->bg);
		imagemirror_ttt($TTTimage->im, $bgcolor, $this->ratio,$this->up_transparency,$this->down_transparency);
		$TTTimage->height += round($TTTimage->height * $this->ratio / 100);
	}
}

class TTTtransformation
{
	var $type; //string
	function TTTtransformation($type='')
	{
		$this->type = $type;
	}

	function draw(& $TTTimage)
	{
		switch($this->type)
		{
		case 'fliphorizontal':
			imageflip_ttt($TTTimage->im, false);
			break;
		case 'flipvertical':
			imageflip_ttt($TTTimage->im, true);
			break;
		case 'flipboth':
			imageflip_ttt($TTTimage->im, false);
			imageflip_ttt($TTTimage->im, true);
			break;
		case 'rotate90':
			if (!function_exists('imagerotate')) break;
			imagerotate_ttt($TTTimage->im,90);
			$TTTimage->zerox = $TTTimage->zeroy;
			$TTTimage->zeroy = $TTTimage->width - $TTTimage->zerox;
			$oldwidth = $TTTimage->width.
			$TTTimage->width = $TTTimage->height;
			$TTTimage->height = $oldwidth;
			break;
		case 'rotate270':
			if (!function_exists('imagerotate')) break;
			imagerotate_ttt($TTTimage->im,270);
			$TTTimage->zerox = $TTTimage->zeroy;
			$TTTimage->zeroy = $TTTimage->zerox;
			$oldwidth = $TTTimage->width.
			$TTTimage->width = $TTTimage->height;
			$TTTimage->height = $oldwidth;
			break;
		}
	}
}





function minmax($value, $min, $max)
{return min(max($value,$min),$max); }







// *********************   Alternative TTF functions fixing GD bugs when angle is not null   ***********************
function imagettftext_ttt($image, $size, $angle, $x, $y, $color, $fontfile, $text,$fullheight=false)
{
	if ($angle%360==0)
		return imagettftext($image, $size, $angle, $x, $y, $color, $fontfile, $text);

	$curx = $x ;
	$cury = $y ;
	$deltax = 0;
	$cos = cos(deg2rad($angle));
	$sin = sin(deg2rad($angle));
	for ($i=0; $i<strlen($text);$i++)
	{
		$char = substr($text,$i,1);
		$bbox1 = imagettfbbox($size, 0, $fontfile, substr($text,0,$i+1));
		$bbox2 = imagettfbbox($size, 0, $fontfile, $char);
		$deltax = $bbox1[4]-$bbox2[4];//-$bbox[6];
		$newx = $x+$deltax * $cos;
		$newy = $y-$deltax * $sin;
		imagettftext($image, $size, $angle, $newx, $newy, $color, $fontfile, $char);
	}

	return imagettfbbox_ttt($size, $angle, $fontfile, $text,$fullheight);
}

function imagettfbbox_ttt($size, $angle, $fontfile, $text,$fullheight=false)
{
	if (!function_exists('imagettfbbox')) return false;
	if (!file_exists($fontfile)) return false;
	if ($text=='') return array(0,0,0,0,0,0,0,0);

	$bbox = imagettfbbox($size, 0, $fontfile, $text);

	if ($fullheight) {
		$nlines = substr_count($text,"\n");
		$alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz?!";
		for ($i=0; $i < $nlines; $i++)
			$alphabet .= "\nABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz?!";
		$bboxref = imagettfbbox($size, 0, $fontfile, $alphabet);
		$bbox[1] = $bboxref[1];
		$bbox[3] = $bboxref[3];
		$bbox[5] = $bboxref[5];
		$bbox[7] = $bboxref[7];
	}

	$cos = cos(deg2rad($angle));
	$sin = sin(deg2rad($angle));
	for ($i=0; $i<4; $i++)
	{
		$x = $bbox[$i*2];
		$y = $bbox[$i*2+1];
		$bbox[$i*2] = $x * $cos +  $y * $sin;
		$bbox[$i*2+1] = - $x * $sin +  $y * $cos;
	}
	return $bbox;
}

// *********************   Alternative imageconvolution function for php < 5.1.0   ***********************
function imageconvolution_ttt(&$image, $matrix, $div=false, $offset=false)
{
	$imagex = imagesx($image);
	$imagey = imagesy($image);
	$transp = imagecolortransparent($image);
	$newimg = imagecreatetruecolor($imagex, $imagey);
	imagealphablending($newimg, false);
	$colors = array(array(0,0,0),array(0,0,0),array(0,0,0));
	$lastx = $imagex - 1;
	$lasty = $imagey - 1;

	if (count($matrix)==9) $matrix = array_chunk($matrix, 3);

	if ($div===false)
	{
		$div = array_sum($matrix[0]) + array_sum($matrix[1]) + array_sum($matrix[2]);
		if ($div==0) $div=1;
	}
	if ($offset===false) $offset = 0;

	for ($y=0; $y<$imagey; $y++)
	{
		for ($x=0; $x<$imagex; $x++)
		{
			if  ($x==0) // $x==0, row beginning, recalculate matrix
			{
				for ($i = 1; $i<3; $i++) {
					for ($j = 0; $j<3; $j++)
						$colors[$i][$j] = imagecolorat($image,minmax($i-1,0,$imagex-1),minmax($y+$j-1,0,$imagey-1));
				}
				$colors[0] = $colors[1];
			}
			else // $x>0, just add a new column
			{
				array_shift($colors);
				if ($x<$lastx)
					$colors[] = array(imagecolorat($image,$x+1,max($y-1,0)), imagecolorat($image,$x+1,$y), imagecolorat($image,$x+1,min($y+1,$imagey-1)));
				else
					$colors[2] = $colors[1];
			}
			if ($y==0)
			{
				for ($i = 0; $i<3; $i++)
					$colors[$i][0] = $colors[$i][1];
			}
			elseif ($y==$lasty)
			{
				for ($i = 0; $i<3; $i++)
					$colors[$i][2] = $colors[$i][1];
			}

			$newcol = array(0,0,0,0);
			for ($i=0;$i<3;$i++) {
				for ($j=0;$j<3;$j++) {
					$coef = & $matrix[$i][$j];
					$newcol[0] += floatval(($colors[$i][$j] >> 16) & 0xFF) * $coef; //red
					$newcol[1] += floatval(($colors[$i][$j] >> 8) & 0xFF)* $coef; //green
					$newcol[2] += floatval($colors[$i][$j] & 0xFF)* $coef; //blue

				}
			}

			for ($i=0;$i<3;$i++) {
				$newcol[$i] = round($newcol[$i]/$div) + $offset;
				if ($newcol[$i]<0) $newcol[$i] = 0;
				elseif ($newcol[$i]>255) $newcol[$i] = 255;
			}
			imagesetpixel($newimg, $x, $y, imagecolorallocatealpha($newimg, $newcol[0], $newcol[1], $newcol[2], ($colors[1][1] >> 24) & 0xFF));
		}

	}
	imagealphablending($newimg,true);

	imagealphablending($image, false);
	imagecopy($image, $newimg, 0, 0, 0, 0, $imagex, $imagey);
	imagealphablending($image, true);
	imagedestroy($newimg);
}







function imagefilter_ttt($image, $filter)
{
	switch($filter)
	{
		case 'edge':
			imageconvolution_ttt($image, array(0.045, 0.122, 0.045, 0.122, 0.332, 0.122, 0.045, 0.122, 0.045)); // flou gaussien
			imageconvolution_ttt($image, array(1,1,1,1,-8,1,1,1,1)); // dtection de bord, laplacien
			imageconvolution_ttt($image, array(0,0,0,0,-1,0,0,0,0),1,255); // inversion
			break;
		case 'blur':
			imageconvolution_ttt($image, array(1,1,1,1,1,1,1,1,1)); // flou
			break;
		case 'emboss':
			imageconvolution_ttt($image, array(-2,-1,0,-1,1,1,0,1,2)); // repoussage
			break;
		case 'relief':
			imageconvolution_ttt($image, array(2,1,0,1,1,-1,0,-1,-2)); // relief
			break;
		case 'sharpen':
			imageconvolution_ttt($image, array(-0.25,-1,-0.25,-1,6,-1,-0.25,-1,-0.25)); // accentuation
			break;
		case 'gaussianblur':
			imageconvolution_ttt($image, array(0.045, 0.122, 0.045, 0.122, 0.332, 0.122, 0.045, 0.122, 0.045)); // flou
			break;
	}
}


function imagemirror_ttt(&$image, $bgcolor, $percentage=70,$transp1=60,$transp2=1)
{
	$transp1 = max(0,min($transp1,100));
	$transp2 = min(100,max($transp2,0));

	$imagewidth = imagesx($image);
	$imageheight = imagesy($image);
	$mirrorheight = round(floatval($imageheight)*$percentage/100);

	if (imagecolortransparent($image)>=0)
		$transp = imagecolorsforindex($image, imagecolortransparent($image));
	$bgcolor = imagecolorsforindex($image, $bgcolor);

	$mirrorim = imagecreatetruecolor($imagewidth, $mirrorheight);
	if (is_array($transp))
	{
		imagecolortransparent($mirrorim, imagecolorallocatealpha($mirrorim, $transp['red'], $transp['green'], $transp['blue'], $transp['alpha']));
		imagefill($mirrorim,0,0,imagecolortransparent($mirrorim));
	}

	$greaterim = imagecreatetruecolor($imagewidth, $imageheight+$mirrorheight);
	if (is_array($transp))
		imagecolortransparent($greaterim, imagecolorallocatealpha($greaterim, $transp['red'], $transp['green'], $transp['blue'], $transp['alpha']));
	imagefill($greaterim,0,$imageheight,imagecolorallocatealpha($greaterim, $bgcolor['red'], $bgcolor['green'], $bgcolor['blue'], $bgcolor['alpha']));

	imagecopyresized($mirrorim,$image,0,0,0,0,$imagewidth,$mirrorheight,$imagewidth,$imageheight);
	imagecopy($greaterim, $image,0,0,0,0,$imagewidth,$imageheight);
	for ($i=0;$i<$mirrorheight;$i++)
	{
		$t = $transp1 + $i * ($transp2-$transp1) / $mirrorheight;
		imagecopymerge($greaterim, $mirrorim,0,$imageheight+$i,0,$mirrorheight-$i-1,$imagewidth,1,$t);
	}
	imagedestroy($image);
	$image = $greaterim;
	imagedestroy($mirrorim);
}

function imageflip_ttt(&$image, $vertical=false)
{
    $w = imagesx($image);
    $h = imagesy($image);
	$flipped = imagecreatetruecolor($w, $h);
	imagealphablending($flipped,false);
	imagealphablending($image,false);
	if (imagecolortransparent($image)>=0)
		$transp = imagecolorsforindex($image, imagecolortransparent($image));
	if (is_array($transp))
	{
		imagecolortransparent($flipped, imagecolorallocatealpha($flipped, $transp['red'], $transp['green'], $transp['blue'], $transp['alpha']));
		imagefill($flipped,0,0,imagecolortransparent($flipped));
	}

	if ($vertical)
	{
		for ($y=0; $y<$h; $y++) {
			imagecopymerge($flipped, $image, 0, $y, 0, $h - $y - 1, $w, 1,100);
		}
	}
	else
	{
		for ($x=0; $x<$w; $x++) {
	        imagecopymerge($flipped, $image, $x, 0, $w - $x - 1, 0, 1, $h,100);
		}
	}
	imagealphablending($flipped,true);
	imagedestroy($image);
	$image = $flipped;
}


function imagerotate_ttt(&$image,$angle)
{
	if (!function_exists('imagerotate'))
		return false;
	$rotated = @imagerotate($image,$angle,0);
	imagedestroy($image);
	$image = $rotated;
	return true;
}

?>
