﻿<?php
class TTTstylelist {
	var $styles;
	var $db;
	function TTTstylelist()
 	{
		$this->db = cmsms()->GetDb();
		$this->styles = array();
		$this->loaddb();
	}
	function loaddb()
	{
		$this->styles = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_truetypetext_styles ORDER BY name';
		$dbresult = $this->db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow())		{
			$tttstyle = new TTTstyle;
			$tttstyle->loadrow($row);
			$this->styles[] = $tttstyle;
		}
		return ($dbresult !== false);
	}
	function & getstyle($style)	{
		if (is_numeric($style))
			$index = 'id';
		else
			$index = 'name';
		for ($i = 0; $i < count($this->styles); $i++)
		{
			if ($this->styles[$i]->$index == $style) return $this->styles[$i];
		}
		$result = false;
		return $result;
	}
	
	function getstylesbyfont($fontfile)	{
		$result = array();
		for ($i=0 ; $i<count($this->styles); $i++)
		{
			if ($this->styles[$i]->checkfont($fontfile))
				$result[] = & $this->styles[$i];
		}
		return $result;
	}
	
	function & stylearray()	{
		return $this->styles;
	}
}

class TTTstyle {
	var $db;
	var $id;
	var $name;
	var $backgroundcolor;// background color (text will be transparent by default)
	var $format;// image format ('jpg', 'png' or 'gif')
	var $fulllineheight;// image will be adjusted to maximum line height (boolean)
	var $maxwidth;// maximum image width (text will be split in multiple lines)
	var $pictureperword; // one picture per word (boolean)
	var $transparent;
	var $elements;
		
		
	function TTTstyle($name = '', $backgroundcolor = "#FFFFFF",$format = 'png', $fulllineheight = true, $maxwidth = 0, $pictureperword = false, $transparent = true)	{
		$this->db = cmsms()->GetDb();
		$this->id = -1;
		$this->name = $name;
		$this->backgroundcolor = $backgroundcolor;
		$this->format = $format;
		$this->fulllineheight = $fulllineheight;
		$this->maxwidth = $maxwidth;
		$this->pictureperword = $pictureperword;
		$this->transparent = $transparent;
		$this->elements = array();
	}
	function loadDb($id = -1)
	{
		if ($id!=-1)
			$this->id = $id;
		if ($this->id == -1)
			return false;
		$query = 'SELECT * FROM '.cms_db_prefix().'module_truetypetext_styles WHERE id = ?';
		$row = $this->db->GetRow($query, array($id));
		if ($row)		
			$this->loadrow($row);
		return ($row !== false);
	}
	
	function loadDbByName($name="")
	{
		if ($name != '')
			$this->name = $name;
		if ($this->name == '')
			return false;
		$query = 'SELECT * FROM '.cms_db_prefix().'module_truetypetext_styles WHERE name = ?';
		$row = $this->db->GetRow($query, array($name));
		if ($row)
			$this->loadrow($row);
		return ($row !== false);
	}
	
	function loadrow($row)	{
		$this->id = $row['id'];
		$this->name = $row['name'];
		$this->backgroundcolor = $row['backgroundcolor'];
		$this->format = $row['format'];
		$this->fulllineheight = $row['fulllineheight'];
		$this->maxwidth = $row['maxwidth'];
		$this->pictureperword = $row['pictureperword'];
		$this->transparent = $row['transparent'];
		$this->loadelements($row['elements']);
	}
	function loadelements($elements)
	{
		$rows = explode('\n',$elements);
		$this->elements = array();
		foreach ($rows as $row)
			$this->elements[] = explode(';',$row);
	}
	function getelements()
	{
		$elements = array();
		foreach ($this->elements as $element)
			$elements[] = implode(';',$element);
		return implode('\n', $elements);
	}
	
	function saveDbNew()
	{
		$newid = $this->db->GenID(cms_db_prefix()."module_truetypetext_styles_seq");
		$this->id = $newid;
		$query = 'INSERT INTO '.cms_db_prefix().'module_truetypetext_styles (id,name, format, backgroundcolor, fulllineheight, maxwidth, pictureperword, transparent,elements) VALUES (?,?,?,?,?,?,?,?,?)';
		$dbresult = $this->db->Execute($query, array($newid,$this->name,$this->format,$this->backgroundcolor,$this->fulllineheight,$this->maxwidth,$this->pictureperword, $this->transparent, $this->getelements()));
		if ($dbresult )
			return $this->id;
		else
			return false;
	}
	function updateDb()
	{
		if ($this->id == -1) return false;
		$query = 'UPDATE '.cms_db_prefix().'module_truetypetext_styles SET name=?, format=?, backgroundcolor=?, fulllineheight=?, maxwidth=?, pictureperword=?, transparent=?, elements=? WHERE id = ?';
		$dbresult = $this->db->Execute($query, array($this->name,$this->format,$this->backgroundcolor,$this->fulllineheight,$this->maxwidth,$this->pictureperword, $this->transparent, $this->getelements(), $this->id));
		return ($dbresult !== false);
	}
	
	function deleteDb()
	{
		if ($this->id == -1) return false;
		$query = "DELETE FROM ".cms_db_prefix()."module_truetypetext_styles WHERE id = ?";
		$dbresult = $this->db->Execute($query, array($this->id));
		return ($dbresult !== false);
	}
	
	function addTextElement($fontfile, $size = 20, $color = "#000000", $x = 0, $y = 0, $angle = 0)	{
		$this->elements[] = array('text',$fontfile,$size,$color,$x,$y,$angle);
	}
	function addEffectElement($type = 'blur')
	{
		$this->elements[] = array('effect',$type);
	}
	function addMirrorElement($ratio = 70, $up_transparency = 70, $down_transparency = 10)
	{
		$this->elements[] = array('mirror',$ratio,$up_transparency,$down_transparency);
	}
	function addTransformationElement($type="fliphorizontal")
	{
		$this->elements[] = array('transformation',$type);
	}
	
	function checkfont($fontfile)	{
		foreach ($this->elements as $element)
		{
			if ($element[0] == 'text' && $element[1] == $fontfile)
				return true;
		}
		return false;
	}
	function getCacheName($text)
	{
		$name = $text;
		$name .= ';'.$this->backgroundcolor;
		$name .= ';'.$this->fulllineheight;
		$name .= ';'.$this->maxwidth;
		$name .= ';'.$this->pictureperword;
		$name .= ';'.$this->transparent;
		$name .= '\n'.$this->getelements();
		$name = md5($name);
		return $name;
	}
	
	function getImages ($text) {
		if ($text == '') return '';
		$text = html_entity_decode($text, ENT_QUOTES);
		
		$images = array();

		if ($this->pictureperword)
		{
			$this->pictureperword = false;
			$lines = explode("\n",$text);
			foreach ($lines as $line)
			{
				if (!empty($images))
					$images[] = array("text"=>"\n", "src"=>"", "size"=>"");
				$words = explode(" ", $line);
				foreach ($words as $word)
					$images = array_merge($images,$this->getImages($word.' '));
			}
			$this->pictureperword = true;
			return $images;
		}
		
		
		if (count($this->elements)==0)
			return '<!-- TruetypeText error : empty style -->'.$text;
		$urlpath = 'cache/' . $this->getCacheName($text) . '.' . $this->format;
		$fileabsolutepath = cms_join_path(dirname(__FILE__), 'cache', $this->getCacheName($text) . '.' . $this->format);
		if (!file_exists($fileabsolutepath))
			$result = $this->createImage($text, $fileabsolutepath);
		else
			$result = true;
		if ($result)
		{
			$size = @getimagesize($fileabsolutepath);
			global $CMS_ADMIN_PAGE;
			if (isset($CMS_ADMIN_PAGE))
				$urlpath = '../modules/TruetypeText/'.$urlpath;
			else
				$urlpath = './modules/TruetypeText/'.$urlpath;
			return array(array("text"=>$text, "src" => $urlpath, "size"=>$size[3]));
		}
		else return '<!-- Truetypetext error -->'.$text;
		
		
	}

	function getImage($text, $alt=true, $moretext="")
	{
		if ($text == '') return '';
		$images = $this->getImages($text);
		$result = "";
		foreach ($images as $image)
		{
			if ($image["text"]=="\n")
				$result .= "<br \>";
			else
				$result .= '<img src="'.$image["src"].'"'.($alt=true ? ' alt="'.$image["text"].'"' : '').' '.$moretext.' '.$image["size"].'/>';
		}
		
		return $result;
	}
	
	function getImageSrc($text)
	{
		if ($text == '') return '';
		$this->pictureperword = false;
		$images = $this->getImages($text);
		return $images[0]["src"];		
	}
	
	
/*	function getImage($text, $alt=true, $moretext="")
	{
		if ($moretext=="test") return $this->getImage2($text,$alt,$moretext);
		
		if ($text == '') return '';
		$text = html_entity_decode($text);
		if ($this->pictureperword)
		{
			$this->pictureperword = false;
			$returntext = "";
			$lines = explode("\n",$text);
			foreach ($lines as $line)
			{
				if ($returntext != "")
					$returntext.="<br />\n";
				$words = explode(" ", $line);
				foreach ($words as $word)
				$returntext .= $this->getImage($word.' ');
			}
			$this->pictureperword = true;
			return $returntext;
		}
		if (count($this->elements)==0)
			return '<!-- TruetypeText error : empty style -->'.$text;
		$filepath = cms_join_path('cache', $this->getCacheName($text).'.'.$this->format);
		$fileabsolutepath = cms_join_path(dirname(__FILE__), $filepath);
		if (!file_exists($fileabsolutepath))
			$result = $this->createImage($text, $fileabsolutepath);
		else
			$result = true;
		if ($result)
		{
			$size = @getimagesize($fileabsolutepath);
			global $CMS_ADMIN_PAGE;
			if (isset($CMS_ADMIN_PAGE))
				$filepath = cms_join_path('..','modules','TruetypeText',$filepath);
			else
				$filepath = cms_join_path('modules','TruetypeText',$filepath);
			return ($result ? '<img src="'.$filepath.'"'.($alt=true ? ' alt="'.$text.'"' : '').($class='' ? ' class="'.$class.'"' : '').' '.$size[3].'/>' : $text);

		}
		else return '<!-- Truetypetext error -->'.$text;
		
		
	}*/
	
	function getImageClean($text)
	{
		$text = str_replace('<br />',"\n",$text);
		$text = preg_replace('@<[\/\!]*?[^<>]*?>@si', '', $text);
		return $this->getimage($text);
	}
	
	function createImage($text, $file)
	{
		if ($text == '') return true;
		if (! $this->pictureperword)
			$text = $this->wrap($text);
		$TTTimage = $this->getTTTimage($text);
		if (!$TTTimage) return false;
		$TTTimage->output($this->format, $file);
		$TTTimage->destroy();
		return $TTTimage->getsize();
	}
	
	function wrap($text)
	{
		if ($text == '') return '';
		if ($this->maxwidth<=0) return $text;
		$words = explode (' ', $text);
		$newtext = '';
		$line = '';
		foreach ($words as $word)
		{
			$TTTimage = $this->getTTTimage( ($line=='' ? $word : $line.' '.$word) );
			if (!$TTTimage) return $text;
			$size = $TTTimage->getsize();
			if ($size[0] >= $this->maxwidth && $line!='')
			{
				$newtext .= ($newtext=='' ? '' : '\n').$line;
				$line = '';
			}
			else
				$line .= ($line=='' ? '' : ' ').$word;
		}
		if ($line!='')
			$newtext .= ($newtext=='' ? '' : '\n').$line;
		return $newtext;
	}
	
	function getTTTimage($text)	{
		include_once dirname(__FILE__)."/class.ttt.php";
		$TTTimage = new TTTimage($this->backgroundcolor, $this->transparent);
		foreach ($this->elements as $element)
		{
			switch ($element[0])
			{
				case 'text' :
					if (!is_file(cms_join_path(dirname(__FILE__),'fonts',$element[1])))						return false;
					$TTTimage->add(new TTTtext($text, cms_join_path(dirname(__FILE__),'fonts',$element[1]),								$element[2], $element[3], $element[4], $element[5], $element[6], $this->fulllineheight));
					// text;fontfile;size;color;x;y;angle
				break;
				case 'effect' :
					$TTTimage->add(new TTTeffect($element[1]));
					// effect;type
					break;
				case 'mirror' :
					$TTTimage->add(new TTTmirror($element[1], false, $element[2], $element[3]));
					// mirror;ratio;transparency1;transparency2
					break;
				case 'transformation' :
					$TTTimage->add(new TTTtransformation($element[1]));
					//effect;type
			}
		}
		return $TTTimage;
	}
}
?>
