﻿<?php
class TTTreplacementlist {
	var $replacements;
	var $db;
	
	function TTTreplacementlist() 
	{
		$this->db = cmsms()->GetDb();
		$this->replacements = array();
		$this->loaddb();
	}
	
	function loaddb($type='')
	{
		$this->replacements = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_truetypetext_replacements';
		$dbresult = $this->db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$tttreplacement = new TTTreplacement;
			$tttreplacement->loadrow($row);
			$this->replacements[] = $tttreplacement;
		}
		return ($dbresult !== false);
	}
	
	function & getreplacement($replacement)
	{
		for ($i = 0; $i < count($this->replacements); $i++)
		{
			if ($this->replacements[$i]->id== $replacement) return $this->replacements[$i];
		}
		return false;
	}
	
	
	function & replacementarray()
	{return $this->replacements;}
}


class TTTreplacement {
	var $db;
	var $id;
	var $tag;
	var $additional;
	var $style;
	
	var $elements;
	
	function TTTreplacement($tag = '', $additional = '', $style = '')
	{
		$this->db = cmsms()->GetDb();
		
		$this->id = -1;
		$this->tag = $tag;
		$this->additional = $additional ;
		$this->style= $style;
	}
	
	function loadDb($id = -1)
	{
		if ($id!=-1)
			$this->id = $id;
		if ($this->id == -1)
			return false;

		$query = 'SELECT * FROM '.cms_db_prefix().'module_truetypetext_replacements WHERE id = ?';
		$row = $this->db->GetRow($query, array($id));
		if ($row)
			$this->loadrow($row);
		
		return ($row !== false);
	}
	
	
	function loadrow($row)
	{
		$this->id = $row['id'];
		$this->tag = $row['tag'];
		$this->additional = $row['additional'];
		$this->style = $row['style'];
	}
	
	function saveDbNew()
	{
		$newid = $this->db->GenID(cms_db_prefix()."module_truetypetext_replacements_seq");
		$this->id = $newid;
		$query = 'INSERT INTO '.cms_db_prefix().'module_truetypetext_replacements (id,tag,additional,style) VALUES (?,?,?,?)';
		$dbresult = $this->db->Execute($query, array($newid,$this->tag,$this->additional,$this->style));
		if ($dbresult )
			return $this->id;
		else
			return false;
	}
	
	function updateDb()
	{		
		if ($this->id == -1) return false;
		$query = 'UPDATE '.cms_db_prefix().'module_truetypetext_replacements SET tag=?, additional=?, style=? WHERE id = ?';
		$dbresult = $this->db->Execute($query, array($this->tag,$this->additional,$this->style, $this->id));
		return ($dbresult !== false);
	}
	
	function deleteDb()
	{
		if ($this->id == -1) return false;
		$query = "DELETE FROM ".cms_db_prefix()."module_truetypetext_replacements WHERE id = ?";
		$dbresult = $this->db->Execute($query, array($this->id));
		return ($dbresult !== false);
	}

}
?>