<?php
if(! $this->CheckPermission( 'Use TruetypeText' ) ) exit;

$styletype = (isset($params['predefinedstyle']) ? $params['predefinedstyle'] : '');
$errors = array();
$newparams = array();

if ($styletype=='')
	$errors[] = $this->lang('error_unknownpredefinedstyle');

$fontfiles = $this->getFonts();
if (count($fontfiles)==0)
	$errors[] = $this->lang('error_nofontfile');
else
	$font = $fontfiles[0];

include_once dirname(__FILE__).'/class.style.php';


$TTTstyle = new TTTstyle();

switch ($styletype)
{
	case 'mirror' :
		$TTTstyle->fulllineheight = false;
		$TTTstyle->addTextElement($font,30);
		$TTTstyle->addMirrorElement();
		break;
	case 'shadow' :
		$TTTstyle->addTextElement($font,30,"#BBBBBB",5,5);
		$TTTstyle->addTextElement($font,30,"#000000",0,0);
		break;
	case 'ghost' :
		$TTTstyle->addTextElement($font,30);
		$TTTstyle->addEffectElement();
		$TTTstyle->addTextElement($font,30,"#FFFFFF");
		break;
	case 'double' :
		$TTTstyle->addTextElement($font,40,"#FFCECE",10,10);
		$TTTstyle->addTextElement($font,30,"#000000");
		break;
	default :
		$errors[] = $this->lang('error_unknownpredefinedstyle');
}

if (count($errors)==0)
{
	$TTTsl = new TTTstylelist();
	$i=1;
	$name = $styletype;
	while ($TTTsl->getstyle($name))
		$name = $styletype." (".($i++).")";

	$TTTstyle->name = $name;
	if (!$TTTstyle->savedbnew())
		$errors[] = $this->lang('error_unabletosavestyle');
}

if (count($errors)==0)
	$this->Redirect($id, 'defaultadmin', $returnid, array('module_message'=>$this->lang('predefinedstyleadded',$TTTstyle->name)));
else
	$this->Redirect($id, 'defaultadmin', $returnid, array('module_error'=>implode('<br />', $errors)));



?>