<?php
#-------------------------------------------------------------------------
# Module: TruetypeText - This module can be used to write any text with a TrueType font.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2006 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
# This file originally created by ModuleMaker module, version 0.2
# Copyright (c) 2006 by Samuel Goldstein (sjg@cmsmadesimple.org) 
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class TruetypeText extends CMSModule
{
    public function GetName()
    {
        return 'TruetypeText';
    }
    public function GetFriendlyName()
    {
        return $this->lang('friendlyname');
    }
    public function GetVersion()
    {
        return '2.2';
    }
	public function MinimumCMSVersion()
	{
		return '1.9.4.2';
	}
	public function MaximumCMSVersion()
	{
		return '1.10.3';
	}
    public function GetHelp()
    {
    	$smarty = cmsms()->GetSmarty();
		$config = cmsms()->GetConfig();

		$smarty->assign('rooturl', $config['root_url']);

		$smarty->assign('usage', $this->Lang('usage'));
		$smarty->assign('styles', $this->Lang('styles'));
		$smarty->assign('auto_replacement', $this->Lang('auto_replacement'));
		$smarty->assign('about', $this->Lang('about'));

		$smarty->assign('usage_text', $this->Lang('help_usage'));
		$smarty->assign('styles_text', $this->Lang('help_styles'));
		$smarty->assign('auto_replacement_text', $this->Lang('help_auto_replacement'));
		$smarty->assign('about_text', $this->Lang('help_about'));

		return $this->ProcessTemplate('help.tpl');
    }
    public function GetDescription()
    {
        return $this->lang('description');
    }
    public function GetAdminDescription()
    {
        return $this->lang('admindescription');
    }
    public function GetAuthor()
    {
        return 'Damien GAUTHIER';
    }
    public function HasAdmin()
    {
        return true;
    }
    public function GetAdminSection()
    {
        return 'layout';
    }
	function VisibleToAdminUser()
	{
		return $this->CheckPermission('Use TruetypeText');
	}
    public function IsPluginModule()
    {
        return true;
    }
	public function SetParameters() 
	{
		if (version_compare(CMS_VERSION, '1.10') < 0) {
			$this -> InitializeFrontend();
			$this -> InitializeAdmin();
		}		
	}
	public function InitializeFrontend()
	{
		$this->RegisterModulePlugin();
		$this->RestrictUnknownParams();

		$this->SetParameterType('text', CLEAN_STRING);
		$this->SetParameterType('style', CLEAN_STRING);
		$this->SetParameterType('hidealttext', CLEAN_INT);
		$this->SetParameterType('moretext', CLEAN_STRING);			
		$this->SetParameterType('imagesrc', CLEAN_INT);		
		
		$this->RegisterRoute('/'.$this->prefix.'\/(?P<returnid>[0-9]+)\/(?P<detailtemplate>[0-9]+)\/(?P<item>.+?)$/', array('action' => 'detail'));
	}
	public function InitializeAdmin()
	{
		// parameters that can be called in the module tag
		$this->CreateParameter('text', '', $this->Lang('help_param_text'));
		$this->CreateParameter('style', '', $this->Lang('help_param_style'));
		$this->CreateParameter('hidealttext', 0, $this->Lang('help_param_hidealttext'));
		$this->CreateParameter('moretext', '', $this->Lang('help_param_moretext'));	
		$this->CreateParameter('imagesrc', 'false', $this->Lang('help_param_imagesrc'));
	}
	public function LazyLoadFrontend() 
	{
		return true;
	}
    public function getHTMLimg(&$ttt, $text)
    {
        global $CMS_ADMIN_PAGE;
        
        $image = cms_join_path('modules', $this->GetName(), $ttt->getImage($text));
        if (isset($CMS_ADMIN_PAGE))
            $image = cms_join_path('..', $image);
        return '<img src="' . $image . '" alt="' . $text . '" />';
    }

    public function getFonts()
    {
        $fontfiles = array();
        if ($handle = @opendir(cms_join_path(dirname(__FILE__), 'fonts'))) {
            while (false !== ($file = @readdir($handle))) {
                if (endswith(strtolower($file), '.ttf') || endswith(strtolower($file), '.otf')) {
                    $fontfiles[] = $file;
                }
            }
            @closedir($handle);
        }
        return $fontfiles;
    }

    public function ContentPostRender(&$content)
    {
        if ($this->getpreference('replacepublic function') != 'ContentPostRender')
            return;
        
        include_once cms_join_path(dirname(__FILE__), 'class.replacements.php');
        $TTTrl = new TTTreplacementlist();
        if (count($TTTrl->replacements) == 0)
            return;
        
        $this->autoreplace($content, $TTTrl->replacements);
    }
    
    public function ContentPostCompile(&$content)
    {
        if ($this->getpreference('replacepublic function') != 'ContentPostCompile')
            return;
        
        include_once cms_join_path(dirname(__FILE__), 'class.replacements.php');
        $TTTrl = new TTTreplacementlist();
        if (count($TTTrl->replacements) == 0)
            return;
        
        $this->autoreplace($content, $TTTrl->replacements);
    }
    
    public function AutoReplace(&$content, $replacementlist)
    {
        include_once cms_join_path(dirname(__FILE__), 'class.style.php');
        $TTTsl     = new TTTstylelist();
        $TTTstyles = array();
        foreach ($TTTsl->styles as $TTTstyle)
            $TTTstyles[$TTTstyle->id] = $TTTstyle;
        
        $patterns     = array();
        $replacements = array();
        
        foreach ($replacementlist as $TTTr) {
            $patterns[]     = '|(<' . $TTTr->tag . '(?:[^>]*)' . ($TTTr->additional == '' ? '' : $TTTr->additional . '(?:[^>]*)') . '>)(.*?)(</' . $TTTr->tag . '>)|seim';
            $replacements[] = '"\\1".\$TTTstyles[' . $TTTr->style . ']->getImageClean("\\2")."\\3"';
        }
        //$content .= '<!-- '.count($replacements).' - '.$replacements[0].' -->';
        $content = preg_replace($patterns, $replacements, $content);
        
    }
    
}

?>