<?php

// Some useful functions for events
class EventsManager_events_ops
{
	/* Returns an array with all the events */
	/* PARAMS :
		status : the status of the events to be returned
		category_id : only get events in that or these category/categories
		category_name : same with the name or names
		show : upcoming, past, all or custom
		start_datetime / end_datetime : if "show=custom", only display the events that are valid for the start and end datetime
		myevents : if true, only display the current FEUser events (to which he is registered to)
	*/
	static public function get_events($status='published', $category_id='', $category_name='', $show='all', $start_datetime='', $end_datetime='', $myevents=false)
	{
		$db = cmsms()->GetDb();
		$query = 'SELECT e.* FROM '.cms_db_prefix().'module_events e';
		
		if (!empty($category_name))
			$query .= ' LEFT JOIN '.cms_db_prefix().'module_events_categories ec ON (e.id_category=ec.id)';
		
		if ($myevents)
		{
			$feu_module = cms_utils::get_module('FrontEndUsers');
			$id_user = $feu_module->LoggedInId();
			
			if ($id_user)
				$query .= ' LEFT JOIN '.cms_db_prefix().'module_events_registrations er ON (e.id=er.id_event)';
				
		}
		
		// ***********************************************************************************************
		// Specific params ?
		
		// Save the fact that the "where" has been used
		$where_used = false;

		if (!empty($category_id) OR !empty($category_name))
		{
			$query .= ' WHERE ';
			$where_used = true;
			$qclauses = array();
			$qparams = array();
		}
		
		// Specific categories IDs ?
		if (!empty($category_id))
		{
			// List in an array
			$category_id_array = explode(',', $category_id);
			
			foreach($category_id_array as $val)
			{
				$qclauses[] = "e.`id_category`=?";
				$qparams[] = trim($val);
			}
		}
		
		// Specific categories names ?
		if (!empty($category_name))
		{
			// List in an array
			$category_array = explode(',', $category_name);
			
			foreach ($category_array as $val)
			{
				$qclauses[] = "ec.`name`=?";
				$qparams[] = trim($val);
			}
		}
		
		// ***********************************************************************************************
		// Build the query
		if (isset($qclauses) and count($qclauses))
		{
			$clauses = implode(' OR ', $qclauses);
			$query .= $clauses;
		}
		
		// Status
		if ($status != 'all' && $status != '')
		{
			$query .= ($where_used) ? " AND " : " WHERE ";
			$query .="e.status=?";
			$qparams[] = $status;
			
			$where_used = true;
		}
		
		// Past, upcoming, current or all events ?
		if ($show!= 'all' && $show != '')
		{
			$query .= ($where_used) ? " AND " : " WHERE ";
			
			switch ($show) {
				case 'past':
					$query .= "e.end_datetime < NOW()";
					break;
				case 'upcoming':
					$query .= "e.end_datetime > NOW()";
					break;
				case 'currently':
					$query .="e.start_datetime < NOW() AND e.end_datetime > NOW()";
					break;
				case 'custom':
					if ($start_datetime != '')
					{
						$query .= "e.end_datetime > ?";
						$qparams[] = $start_datetime;
						
						if ($end_datetime != '')
							$query .= ' AND ';
					}
					if ($end_datetime != '')
					{
						$query .= "e.start_datetime < ?";
						$qparams[] = $end_datetime;
					}
			}
			
			$where_used = true;
		}
		
		// Show only current FEUser events ?
		if ($myevents && $id_user)
		{
			$query .= ($where_used) ? " AND " : " WHERE ";
			$query .= "er.id_user=? AND er.nb_persons > 0";
			$qparams[] = $id_user;
		}
		
		$query .=' ORDER BY `name`';
		$res = $db->GetArray($query, $qparams);
		
		$events = array();
		if ($res)
		{
			foreach($res as $oneline)
			{
				// Create an empty object
				$event = new EventsManager_event();
				$event->load_from_array($oneline);
				// And add values from db
				$events[] = $event;
			}
		}
		
		return $events;
	}
}

?>