<?php
if (!isset($gCms)) exit;
if (!$this->HasPermission()) exit;

if (isset($params['id_event']))
{
	$event = new EventsManager_event($params['id_event']);
	
	$registrations = $event->get_registrations();
	$feu_module = cms_utils::get_module('FrontEndUsers');
	
	$result = '"ID","' . $this->Lang('regdate') . '","' . $this->Lang('feuname') . '","' . $this->Lang('nb_persons') . '"';
	$displayed_feu_properties = explode(',', $this->GetPreference('displayed_feu_properties', ''));
	
	// Feu informations
	foreach($displayed_feu_properties as $feuprop)
		$result .= ',"' . $feuprop . '"';
	
	// Add some FEU informations
	foreach ($registrations as &$registration)
	{
		$registration->username = $feu_module->GetUserName($registration->id_user);
		$registration->feu_props = $feu_module->GetUserProperties($registration->id_user);
		
		$result .= "\n";
		$result .= $registration->id . ',"' . $registration->modify_datetime . '","' . $registration->username . '","' . $registration->nb_persons . '"';
		
		foreach($registration->feu_props as $feuprop)
			$result .= ',"' . $feuprop['data'] . '"';
	}
	
	$aliased_title = munge_string_to_url($event->name);
	$file_name = date('Y-m-d') . '_' . $aliased_title . '_registrations.csv';
	
	@ob_clean();
	@ob_clean();
	header('Pragma: public');
	header('Expires: 0');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Cache-Control: private',false);
	header('Content-Description: File Transfer');
	header('Content-Type: text/csv; charset='.$this->GetPreference('exportencoding','utf-8'));
	header('Content-Length: ' . strlen($result));
	header('Content-Disposition: attachment; filename=' . $file_name);
	
	echo $result;
	
	exit;
}

?>