<?php
if (!isset($gCms)) exit;

// Display the list of events
$events = EventsManager_events_ops::get_events('all');
$items = array();

$rowclass = 'row1';
foreach ($events as $event)
{
	// Admin Links
	$event->name_editlink = $this->CreateLink($id, 'admin_addeditevent', $returnid, $event->name, array('id_event'=>$event->id));
	
	$event->togglestatuslink = $this->CreateLink($id, 'admin_togglestatusevent', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/' . ( ($event->status=='published') ? 'true' : 'false') . '.gif', $this->Lang('toggle_status'), '', '', 'systemicon'), array('id_event'=>$event->id, 'status'=>($event->status=='published') ? 'draft' : 'published'));
	
	$event->viewreguserslink = $this->CreateLink($id, 'admin_viewregusers', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/topfiles/usersgroups.gif', $this->Lang('view_regusers'), '24', '29', 'systemicon') . ' ' . lang('view'), array('id_event'=>$event->id));
	
	$event->exportreguserslink = $this->CreateLink($id, 'admin_exportregusers', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/export.gif', $this->Lang('export_regusers'), '24', '29', 'systemicon') . ' ' . $this->Lang('export_regusers'), array('id_event'=>$event->id, 'disable_theme'=>1));
	
	$event->toggleregistationlink = $this->CreateLink($id, 'admin_toggleregistrationevent', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/' . ( ($event->allow_registration) ? 'true' : 'false') . '.gif', $this->Lang('toggle_registration'), '', '', 'systemicon'), array('id_event'=>$event->id, 'allow_registration'=>($event->allow_registration) ? '0' : '1'));
	
	$event->editlink = $this->CreateLink($id, 'admin_addeditevent', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'), '', '', 'systemicon'), array('id_event'=>$event->id));
	
	$event->deletelink = $this->CreateLink($id, 'admin_deleteevent', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'), '', '', 'systemicon'), array('id_event'=>$event->id), $this->Lang('areyousure'));
	
	$event->rowclass = $rowclass;
	$items[] = $event;
	
	($rowclass=="row1" ? $rowclass="row2" : $rowclass="row1");
}

// Assign to smarty
$smarty->assign('items', $events);
$smarty->assign('addlink', $this->CreateLink($id, 'admin_addeditevent', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addevent'), '', '', 'systemicon') . $this->Lang('addevent')));

echo $this->ProcessTemplate('admin_tab_events.tpl');

?>