<?php

$lang['friendlyname'] = "Events Manager";
$lang['admindescription'] = "A module to manage Events like shows, training lessons, etc.. and allow your FEUsers to register to them";

$lang['postinstall'] = "The EventsManager module has been successfully installed. You can access it in the 'Content' Menu. Be sure to set 'Use EventsManager' permissions to use this module!";
$lang['preuninstall'] = "Really? You're sure you want to uninstall the EventsManager module and all it's data?";
$lang['postuninstall'] = "The EventsManager module has been uninstalled.";

# General
$lang['name'] = 'Name';
$lang['published'] = 'Published';
$lang['draft'] = 'Draft';

# Tabs
$lang['events'] = 'Events';
$lang['preferences'] = 'Preferences';
$lang['categories'] = 'Categories';

$lang['edit'] = 'Edit';
$lang['delete'] = 'Delete';
$lang['areyousure'] = 'Are you sure?';

# Events
$lang['addevent'] = 'Add a new event';
$lang['editevent'] = 'Edit an event';
$lang['eventdescription'] = 'Description';
$lang['start_datetime'] = 'Start date and time';
$lang['end_datetime'] = 'End date and time';
$lang['number_of_regusers'] = 'Number of registrations';
$lang['capacity'] = 'Capacity';
$lang['unlimitedcapacity'] = 'Unlimited capacity';
$lang['unlimited'] = 'Unlimited';
$lang['capacity_per_feu'] = "Max number of registrations per FrontEnd User";
$lang['unlimitedcapacity_per_feu'] = "Unlimited number of registrations for each FrontEnd User";
$lang['view_regusers'] = 'View registered users';
$lang['allow_registration'] = 'Allow registrations';
$lang['allow_registration_detail'] = 'Allow FEUsers to register to that event';
$lang['registration_allowed'] = 'Registrations allowed';
$lang['toggle_registration'] = 'Allow/disallow registrations';
$lang['toggle_status'] = 'Publish/Hide';
$lang['allowed_feu_groups'] = "FEUsers groups allowed to register to that event - If none selected, all FEUsers will be able to register";
$lang['back_toeventslist'] = 'Back to the events list';
$lang['price'] = 'Price';

# Registration
$lang['nb_persons'] = 'Number of users';
$lang['register'] = 'Register to that event';
$lang['cancelregister'] = 'Cancel the registration';
$lang['registrations_for'] = 'Registrations to the event';
$lang['feuname'] = 'Username';
$lang['regdate'] = 'Registration date';
$lang['export_regusers'] = 'Export the registrations';
$lang['exportencoding'] = 'Registrations CSV file encoding';

# Categories
$lang['category'] = 'Category';
$lang['addcategory'] = 'Add an events category';
$lang['editcategory'] = 'Edit an events category';

# Errors
$lang['error_emptyname'] = "Please give a name";
$lang['error_nameused'] = "Another category with the same name already exists";
$lang['error_db'] = "An error occured during the insertion/update process in the database";
$lang['error_registration_notallowed'] = "You cannot register to that event";
$lang['error_notconnected'] = "You must be connected to register";
$lang['error_paramsmissing'] = "One or more parameters are missing";

# Messages
$lang['message_registration_ok'] = "Your registration has been saved.";

# Prefs
$lang['generaloptions'] = 'General preferences';
$lang['label_menuname'] = "Custom module name in the admin menu - If none, the default name will be used";

$lang['urloptions'] = "URLs preferences";
$lang['urlprefix'] = "Prefix to use for every URLs in the module";
$lang['registerurlprefix'] = "Prefix to use for every registration link";

$lang['eventdetailoptions'] = "Event details preferences";
$lang['label_dflt_detailpage'] = "Event detail default page. If 'None' is selected, the current page will be used";

$lang['eventregistrationoptions'] = "Event registration preferences";
$lang['label_dflt_registrationpage'] = "Registration default page. If 'None' is selected, the current page will be used";

$lang['reguserslistoptions'] = 'Event registrations list preferences';
$lang['displayed_feu_properties'] = "FEU properties displayed in the registrations list and in the export file";

# Templates / Admin
$lang['summarytemplates'] = 'Summary templates';
$lang['detailtemplates'] = 'Detail templates';
$lang['registrationtemplates'] = "Registration templates";

$lang['summarytemplate_addedit'] = "Add / Edit an events summary template";
$lang['detailtemplate_addedit'] = "Add / Edit an event details template";
$lang['registrationtemplate_addedit'] = "Add / Edit an event registration form template";

# Help with params
$lang['param_action'] = "Specify the behaviour of the module. Possible values are:
<ul>
	<li><em>default</em> - Display a summary of events - You can use <em>action='summary'</em> too</li>
	<li>detail - Display a detail view of a single event - Use the 'event_id' parameter to specify the event to display</li>
	<li>register - Display a form to registrer to an event - Use the 'event_id' parameter to specify the event to which register</li>
</ul>
";

$lang['param_event_id'] = "Useful only with the <em>detail</em> and <em>register</em> actions - Specifies the event to display / to register to";
$lang['param_detailpage'] = "Page ID to use to display an event detail - If not filled, the current page, or the one defined in the preferences will be used";
$lang['param_category_id'] = "Useful only with the <em>default</em> action, this parameter will be used to display only the events that are in the specified category id - You can use a comma seperated list to specify multiples categories IDs. Example : <em>category_id='2,3'</em>";
$lang['param_category'] = "Useful only with the <em>default</em> action, this parameter will be used to display only the events that are in the specified category name - You can use a comma seperated list to specify multiples categories names. Example : <em>category_id='show,training'</em>";

$lang['param_status'] = "Useful only with the <em>default</em> action, this parameter specifies the status of events to display
<br />
Possible values are:
<ul>
	<li>published : published events - default param</li>
	<li>draft : draft events</li>
	<li>all : all the events</li>
</ul>";
$lang['param_show'] = "Useful only with the <em>default</em> action, thie parameter is used to display events according to their datetimes
<br />
Possible values are:
<ul>
	<li>upcoming : upcoming events - default param</li>
	<li>past : past events</li>
	<li>currently : current events (start date < current date < end date)</li>
	<li>custom : specify a start and end date and time - See the start/end_datetime params</li>
</ul>";
$lang['param_start_datetime'] = "Useful only with the <em>default</em> action, and only when show='custom', this parameter defines the start date and time of the events to be displayed. Date and time must be in standard format : YYYY-MM-DD HH:MM:SS
<br />Examples:
<ul>
	<li>complete date/time: start_datetime='2011-10-07 15:00:00'</li>
	<li>date only: start_datetime='2011-10-07'</li>
	<li>year only: start_datetime='2011' - '2011' means 2011-01-01</li>
</ul>";
$lang['param_end_datetime'] = "Useful only with the <em>default</em> action, and only when show='custom', this parameter defines the end date and time of the events to be displayed. Date and time must be in standard format : YYYY-MM-DD HH:MM:SS - See the start_datetime param for examples";
$lang['param_summarytemplate'] = "Useful only with the <em>default</em> action, this parameter specifies the template that should be used for the summary mode display. If no value is specified, the default template of that type is used";
$lang['param_detailtemplate'] = "Useful only with the <em>detail</em> action, this parameter specifies the template that should be used for the detail mode display. If no value is specified, the default template of that type is used";
$lang['param_registrationtemplate'] = "Useful only with the <em>register</em> action, this parameter specifies the template that should be used for the registrater mode display. If no value is specified, the default template of that type is used";

# Help
$lang['help'] = "
<h3>What does this do?</h3>
<p>The EventsManager module is designed to manage Events like Shows, Training lessons, Conferences, ... and all kind of 'events' that does have a start and end date and time. You can create events, display them and handle FEU registrations.</p>
<p>For the time being, this module is under development and will provide more functions later (E-commerce, Fields definitions, etc.)</p>

<h3>How do I use it?</h3>
<ul>
	<li>Create one or more events in the admin</li>
	<li>Add the <strong>{EventsManager}</strong> tag to a page to display an upcoming events summary view</li>
</ul>
<p>You can customize your templates with some parameters and options (see below)</p>

<h3>Support</h3>
<p>This module does not include commercial support. However there are a number of resources available to help you with it:</p>
<ul>
	<li>For the latest version of this module, FAQs or to file a bug report, please visit the cms made simple Developers Forge and do a search for 'EventsManager'</li>
	<li>To obtain commercial support, please send an email to the author Mathieu Muths (french prefered but I can speak english) : <a href=\"mailto:mailto:contact@airelibre.fr\">contact@airelibre.fr</a></li>
	<li>Additional discussion of this module may also be found in the CMS Made Simple Forms.</li>
</ul>
<h3>Copyright et Licence</h3>
<p>Copyright © 2011, Mathieu Muths (contact@airelibre.fr) - All rights reserved</p>
<p>This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed as an addon module to CMS Made Simple. You may not use this software in any Non GPL version of CMS Made simple, or in any version of CMS Made simple that does not indicate clearly and obviously in its admin section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA Or <a
href=\"http://www.gnu.org/licenses/licenses.html#GPL\" target=\"_blank\">read it online</a></p>";
?>