<?php
if (!isset($gCms)) exit;

/* Registration form */
$errors = array();
$messages = array();

// A variable to see if we do display the registration form
$display_event_registration_form = false;

// Some default values
$inline = 0;
if ( (isset($params['inline'])) AND ($params['inline'] != '') )
	$inline = $params['inline'];

// Load the event and see if registration is allowed
if (isset($params['event_id']))
{
	// Load the event and registration
	$event = new EventsManager_event($params['event_id']);
	$registration = new EventsManager_registration(false, true, $event->id);
	
	// Submit ?
	if (isset($params['submit']) OR isset($params['cancel']))
	{
		if ($params['submit'])
		{
			// Check the number of persons asked - If the param is not provided, we consider only 1 person
			if (isset($params['nb_persons']))
				$nb_persons = $params['nb_persons'];
			else
				$nb_persons = 1;
			
			// Nb max ? 
			if ( ($event->capacity_per_feu != 0) AND ($nb_persons > $event->capacity_per_feu) )
				$nb_persons = $event->capacity_per_feu;
		}
		else
		{
			// Cancel registration
			$nb_persons = 0;
		}
		
		if ($event->registration_allowed($nb_persons) OR ($nb_persons == 0))
		{
			$registration->nb_persons = $nb_persons;
			
			// Ready - Just have to store the actual id to see if it's an addition or update
			$id_before_addedit = $registration->id;
			
			if ($registration->addedit())
			{
				$messages[] = $this->Lang('message_registration_ok');
				
				// Send events
				$parms['registration_id'] = $registration->id;
				
				if ($id_before_addedit)
					$this->SendEvent('EventsManagerRegistrationEdited', $parms);
				else
					$this->SendEvent('EventsManagerRegistrationAdded', $parms);
				
				// Redirect to originating url
				$url = html_entity_decode($params['orig_url']);
				redirect($url);
			}
			else
				$errors[] = $this->Lang('error_db');
		}
		else
		{
			$errors[] = $this->Lang('error_registration_notallowed');
		}
	}
	
	
	// Registration form / Only if we can register to this event
	if ($event->registration_allowed())
	{
		$display_event_registration_form = true;
		
		$smarty->assign('form_start', $this->CreateFormStart($id, 'register', $returnid, 'POST', '', $inline));
		$smarty->assign('form_end', $this->CreateFormEnd());
		$smarty->assign('hidden', $this->CreateInputHidden($id, 'event_id', $params['event_id']) . $this->CreateInputHidden($id, 'orig_url', cge_url::current_url()));
		$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('register')));
		
		// Cancel
		$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancelregister')));
		
		// Quantity
		$smarty->assign('nb_persons_input', $this->CreateInputText($id, 'nb_persons', '1', 4));
		$smarty->assign('nb_persons_label', $this->CreateLabelForInput($id, 'nb_persons', $this->Lang('nb_persons')));
	}
	else
	{
		$errors[] = $this->Lang('error_registration_notallowed');
	}
}
else
{
	$errors[] = $this->Lang('error_paramsmissing');
}

/******************************************************************************
// Display */

// Smarty
$smarty->assign('errors', $errors);
$smarty->assign('messages', $messages);
$smarty->assign('display_event_registration_form', $display_event_registration_form);
$smarty->assign('event', $event);

if ($registration->id)
	$smarty->assign('registration', $registration);

// Display
$template = $this->GetPreference('dflt_registration_template');
if (!empty($params['registrationtemplate']))
	$template = $params['registrationtemplate'];

echo $this->ProcessTemplateFromDatabase('registration_' . $template);
?>