<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function supports the back end for the module servicedesk
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$query = '';
$dbresult = '';
$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_incidents';
$query .= ' WHERE status != "CL"';
$query .= ' ORDER BY create_date';
$dbresult = $db->Execute($query);
$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->incident_id = $this->CreateLink($id, 'editincident', $returnid, $row['incident_id'], array('incident_id'=>$row['incident_id']));
	// Retrieve user name, this could be mail address. This depends on settings in Front End User
	$onerow->requestor = $this->GetFEUUsername($row['requestor_id']);
	$onerow->requestorref = $row['requestor_ref'];
	$onerow->description = $this->CreateLink($id, 'editincident', $returnid, $row['description'], array('incident_id'=>$row['incident_id']));
	$onerow->create_date = $row['create_date'];
	$onerow->status = $row['status'];
	$onerow->priority = $row['priority'];
	$onerow->priorityseq = $row['priorityseq'];

	$onerow->editlink = $this->CreateLink($id, 'editincident', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('incident_id'=>$row['incident_id']));
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Incidents','incident_id'=>$row['incident_id']), $this->Lang('areyousureincident'));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$this->smarty->assign_by_ref('items', $entryarray);
$this->smarty->assign('itemcount', count($entryarray));

// Setup links
$this->smarty->assign('addincidentlink', $this->CreateLink($id, 'addincident', $returnid, $this->Lang('addincident'), array(), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('addincidentlink', $this->CreateLink($id, 'addincident', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addincident'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addincident', $returnid, $this->Lang('addincident'), array(), '', false, false, 'class="pageoptions"'));

// Create headings
$this->smarty->assign('incidenttext', $this->Lang('incident'));
$this->smarty->assign('requestortext', $this->Lang('requestor'));
$this->smarty->assign('priorityseqtext', $this->Lang('title_priorityseq'));
$this->smarty->assign('requestorreftext', $this->Lang('requestor_ref'));
$this->smarty->assign('descriptiontext', $this->Lang('incidentdescription'));
$this->smarty->assign('create_datetext', $this->Lang('created'));
$this->smarty->assign('statustext', $this->Lang('status'));
// Display the incidents
echo $this->ProcessTemplate('listincidents.tpl');

?>
